## Setup
### Enveriment

```
conda create -n qslaw python=3.8 -y
conda activate qslaw

# install pytorch
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 -c pytorch

# install dependency and qslaw
pip install -r requirements.txt
pip install -e .
```

### Data
- Plearse follow the [official repo](https://github.com/lupantech/ScienceQA) to prepare ScienceQA
- Please download LLaMA-7B from [Huggingface repo](https://huggingface.co/nyanko7/LLaMA-7B/tree/main)
- Orginize checkpoints and data folders like [original LaVIN](https://github.com/luogen1996/LaVIN/blob/main)
- You can perform quantization initilization in our code but we recommend using the parameters from [OmniQuant](https://huggingface.co/ChenMnZ/OmniQuant/tree/main) and run `python convert.py` to convert keys in theparameter dict.  


## Fine-tuning
Reproduce the performance of **LaVIN-7B-QSLAW** on ScienceQA. For LLaMA-7B model, we fine-tune it on 1x A100.

```
bash scripts/finetuning_sqa_7b_lite.sh
```
