# import dependencies
import subprocess



# Uses LeNet trained in main.py and approximates even more Hessian eigenvalues
# and eigenvectors for an investigation regarding the decomposition of the
# weight vector in the Hessian eigenbasis and the accuarcy of the network.



# Hessian_Lanczos
#
# Approximates eigenvectors of the network at the final training weight vector
# after 100 epochs. In total the script calculates the 10^4 biggest
# eigenvalues and the corresponding eigenvectors. Additionally the script plots
# the eigenvalue density of these 10^4 eigenvalues

print("Hessian_Lanczos")
subprocess.run(["python", "-u", "Hessian_Lanczos.py", "--para_str=Htop1e+04"])



# Plot_Hessian_Projection
#
# Plots the Hessian eigendecompostion of the weight vector and how the accurcay
# depends on the this eigendecomposition.

print("Plot_Hessian_Projection")
subprocess.run(["python", "-u", "Plot_Hessian_Projection.py", "--para_str=Htop1e+04"])

