# import dependencies
import subprocess



# Similar analysis as in main.py, but for ResNet20



# Create ResNet20
#
# Creates a folder with the name "resnet20_wd1e-04_lr5e-03_b50_m0.90_32_1"
# indicating the hyperparameters, number format and seed used to train the
# network. Subfolders "data" and "plots" are created. After that the ResNet is
# trained with the training schedule described in the appendix for 100 epochs.

print("Create_ResNet20")
subprocess.run(["python", "-u", "Create_ResNet20.py"])



# Hessian_Lanczos
#
# Approximates eigenvectors of the network at the final training weight vector
# after 100 epochs. In total the script calculates the 2*10^3 biggest
# eigenvalues and the corresponding eigenvectors. Additionally the script plots
# the eigenvalue density of these 2*10^3 eigenvalues

print("Hessian_Lanczos")
subprocess.run(["python", "-u", "Hessian_Lanczos.py", "--para_str=Htop4e+02", "--model_type=resnet20"])



# Analysis_Training
#
# Trains the network for 20 more epochs with a constant learning rate. While
# doing so it projects the weights onto the 2*10^3 approximated Hessian
# eigenvectors and saves the resulting time series of projected weights.

print("Analysis_Training")
subprocess.run(["python", "-u", "Analysis_Training.py", "--para_str=Htop4e+02", "--model_type=resnet20"])



# Analysis_Evaluation
#
# Takes the recored weight series and subtracts the mean velocity. Then it
# analyzes the weight variance, the velocity variance and the velocity
# correlation time. It does so in the Hessian eigenbasis the weights were
# projected onto and saves the the variances and the correlation time for the
# individual Hessian eigenvectors with the corresponding Hessian eigenvalue.
# Additionally it calculates and saves the theoretical prediction for the
# correlation time.

print("Analysis_Evaluation")
subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", "--para_str=Htop4e+02", "--model_type=resnet20"])



# Plot_Variance
#
# Takes the previously calculated variances and correlation times and plots them
# against the corresponding Hessian eigenvalue. For the correlation time it
# additionally plots the theory predictions from the main text.

print("Plot_Variance")
subprocess.run(["python", "-u", "Plot_Variance.py", "--subtract_mean", "--para_str=Htop4e+02", "--model_type=resnet20"])

