# import dependencies
import subprocess



# Create_Lenet
#
# Creates a folder with the name "lenet_wd0e+00_lr5e-03_b50_m0.90_64_1"
# indicating the hyperparameters, number format and seed used to train the
# network Subfolder "data" and "plots" are created. After that the LeNet is
# trained with the training schedule described in the main text for 100 epochs.

print("Create_LeNet")
subprocess.run(["python", "-u", "Create_LeNet.py", "-w=0", "--dtype=float64"])



# Hessian_Layer
#
# Calculates the Hessian matrix with respect to the first layer at the final
# training weight vector after 100 epochs.

print("Hessian_Layer")
subprocess.run(["python", "-u", "Hessian_Layer.py", "-w=0", "--dtype=float64", "--para_str=lyr0"])



# Analysis_Training
#
# Trains the network for 20 more epochs with a constant learning rate. While
# doing so it saves the weights of the first layer for every step

print("Analysis_Training")
subprocess.run(["python", "-u", "Analysis_Training.py", "-w=0", "--dtype=float64", "--para_str=lyr0", "--epochs=10"])



# Analysis_Evaluation
#
# Takes the recorded weight series and calculates the weight variance, the
# velocity variance and the velocity correlation time. First it does so for the
# weights projected on to the Hessian eigenbasis of the first layer, their it
# also subtracts the mean velocity of the weight series. Then it
# calculates them in the eigenbasis of the covariance matrix of the weight
# series. It saves every variance and the correlatiom time with the second
# derivative of the corresponding direction. Additionally it calculates and
# saves the theoretical prediction for the correlation time.

print("Analysis_Evaluation")
subprocess.run(["python", "-u", "Analysis_Evaluation.py", "-w=0", "--dtype=float64", "--para_str=lyr0", "--epochs=10", "--subtract_mean"])
subprocess.run(["python", "-u", "Analysis_Evaluation.py", "-w=0", "--dtype=float64", "--para_str=lyr0", "--epochs=10", "--basis_str=sigma"])



# Plot_Variance
#
# Takes the previously calculated variances and correlation times and plots them
# against the corresponding second derivative. For the correlation time it
# additionally plots the theory predictions from the main text.

print("Plot_Variance")
subprocess.run(["python", "-u", "Plot_Variance.py", "-w=0", "--dtype=float64", "--para_str=lyr0", "--epochs=10", "--subtract_mean"])
subprocess.run(["python", "-u", "Plot_Variance.py", "-w=0", "--dtype=float64", "--para_str=lyr0", "--epochs=10", "--basis_str=sigma"])



# Artificial_SGD
#
# Simulates SGD in a isotropic quadratic loss function with gaussian noise which
# has an isotropic covariance matrix and is uncorrelated over time. Calculates
# the weight variance, the velocity variance and the velocity correlation time
# first in the original simulation basis and then in the eigenbasis of the
# weight covariance matrix. Plots the variance and the correlation time against
# the basis vector index.

print("Artificial_SGD")
subprocess.run(["python", "-u", "Artificial_SGD.py"])

