# import dependencies
import subprocess



# Similar analysis as in main.py, but for multiple sets of hyperparameters for
# multiple seeds
para_str = "--para_str=Htop2e+03"
seed_list = [2,3,4,5,6]



# Create_Lenet
#
# Creates a folders with for the different hyperparameters and seeds.
# Subfolders "data" and "plots" are created. After that the networks are
# trained with the training schedule described in the main text for 100 epochs.

print("Create_LeNet")
for seed in seed_list:
  seed_str = "-s="+str(seed)
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.005", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.01", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.02", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.03", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.04", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.005", "--batch_size=32", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.005", "--batch_size=64", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.005", "--batch_size=100", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.005", "--batch_size=128", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.02", "--momentum=0.00", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.02", "--momentum=0.50", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.02", "--momentum=0.70", seed_str])
  subprocess.run(["python", "-u", "Create_LeNet.py", "-l=0.02", "--momentum=0.95", seed_str])



# Hessian_Lanczos
#
# Approximates eigenvectors of the networks at the final training weight vector
# after 100 epochs. In total the script calculates the 2*10^3 biggest
# eigenvalues and the corresponding eigenvectors. Additionally the script plots
# the eigenvalue density of these 2*10^3 eigenvalues

print("Hessian_Lanczos")
for seed in seed_list:
  seed_str = "-s="+str(seed)
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.005", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.01", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.02", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.03", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.04", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.005", "--batch_size=32", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.005", "--batch_size=64", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.005", "--batch_size=100", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.005", "--batch_size=128", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.02", "--momentum=0.00", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.02", "--momentum=0.50", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.02", "--momentum=0.70", seed_str])
  subprocess.run(["python", "-u", "Hessian_Lanczos.py", para_str, "-l=0.02", "--momentum=0.95", seed_str])



# Analysis_Training
#
# Trains the networks for 20 more epochs with a constant learning rate. While
# doing so it projects the weights onto the 2*10^3 approximated Hessian
# eigenvectors and saves the resulting time series of projected weights.

print("Analysis_Training")
for seed in seed_list:
  seed_str = "-s="+str(seed)
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.005", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.01", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.02", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.03", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.04", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.005", "--batch_size=32", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.005", "--batch_size=64", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.005", "--batch_size=100", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.005", "--batch_size=128", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.02", "--momentum=0.00", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.02", "--momentum=0.50", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.02", "--momentum=0.70", seed_str])
  subprocess.run(["python", "-u", "Analysis_Training.py", para_str, "-l=0.02", "--momentum=0.95", seed_str])



# Analysis_Evaluation
#
# Takes the recored weight series and subtracts the mean velocity. Then it
# analyzes the weight variance, the velocity variance and the velocity
# correlation time. It does so in the Hessian eigenbasis the weights were
# projected onto and saves the the variances and the correlation time for the
# individual Hessian eigenvectors with the corresponding Hessian eigenvalue.
# Additionally it calculates and saves the theoretical prediction for the
# correlation time.

print("Analysis_Evaluation")
subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", "--para_str=Htop5e+03"])
for seed in seed_list:
  seed_str = "-s="+str(seed)
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.005", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.01", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.02", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.03", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.04", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.005", "--batch_size=32", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.005", "--batch_size=64", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.005", "--batch_size=100", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.005", "--batch_size=128", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.02", "--momentum=0.00", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.02", "--momentum=0.50", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.02", "--momentum=0.70", seed_str])
  subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", para_str, "-l=0.02", "--momentum=0.95", seed_str])



# Plot_Hyperparameters
#
# Takes the previously calculated variances and correlation times and extracts
# the empirical tau_sgd and lambda_cross from it. Plots these quantities against
# the theory curve.

print("Plot_Hyperparameters")
process_list = ["python", "-u", "Plot_Hyperparameters.py", "--subtract_mean", para_str]
for seed in seed_list:
  seed_list_str = "--seed_list="+str(seed)
  process_list.append(seed_list_str)
subprocess.run(process_list)

