# import dependencies
import subprocess



# Create_Lenet
#
# Creates a folder with the name "lenet_wd1e-04_lr5e-03_b50_m0.90_32_1"
# indicating the hyperparameters, number format and seed used to train the
# network. Subfolders "data" and "plots" are created. After that the LeNet is
# trained with the training schedule described in the main text for 100 epochs.

print("Create_LeNet")
subprocess.run(["python", "-u", "Create_LeNet.py"])



# Hessian_Lanczos
#
# Approximates eigenvectors of the network at the final training weight vector
# after 100 epochs. In total the script calculates the 5*10^3 biggest
# eigenvalues and the corresponding eigenvectors. Additionally the script plots
# the eigenvalue density of these 5*10^3 eigenvalues

print("Hessian_Lanczos")
subprocess.run(["python", "-u", "Hessian_Lanczos.py", "--para_str=Htop5e+03"])



# Analysis_Training
#
# Trains the network for 20 more epochs with a constant learning rate. While
# doing so it projects the weights onto the 5*10^3 approximated Hessian
# eigenvectors and saves the resulting time series of projected weights.

print("Analysis_Training")
subprocess.run(["python", "-u", "Analysis_Training.py", "--para_str=Htop5e+03"])



# Analysis_Evaluation
#
# Takes the recored weight series and subtracts the mean velocity. Then it
# analyzes the weight variance, the velocity variance and the velocity
# correlation time. It does so in the Hessian eigenbasis the weights were
# projected onto and saves the the variances and the correlation time for the
# individual Hessian eigenvectors with the corresponding Hessian eigenvalue.
# Additionally it calculates and saves the theoretical prediction for the
# correlation time.

print("Analysis_Evaluation")
subprocess.run(["python", "-u", "Analysis_Evaluation.py", "--subtract_mean", "--para_str=Htop5e+03"])



# Plot_Variance
#
# Takes the previously calculated variances and correlation times and plots them
# against the corresponding Hessian eigenvalue. For the correlation time it
# additionally plots the theory predictions from the main text.

print("Plot_Variance")
subprocess.run(["python", "-u", "Plot_Variance.py", "--subtract_mean", "--para_str=Htop5e+03"])



# Analysis_Training_Noiseterm
#
# The further training of 20 more epochs is repeated, this time, additionally,
# the total gradient with respect to all examples is calculated at every step.
# The total gradient and the bathch gradient, calculated only with respect to
# the examples of the current batch is projected onto the approximated Hessian
# eigenvectors and saved. The script recording the weights and this script are
# kept separate as only saving the weights is relatively fast but calculating
# the total gradient is very resource intensive.

print("Analysis_Training_Noiseterm")
subprocess.run(["python", "-u", "Analysis_Training_Noiseterm.py", "--para_str=Htop5e+03"])



# Plot_Autocorrelation
#
# From the previously calculated batch and total gradients, the noise term of
# every step of the further training is calculated. Then, the autocorrelation of
# this noise in the direction of every single one of the approximated Hessian
# eigenvectors is calculated. After that, the average of these 5*10^3
# autocorrelation functions is calculated an plotted together with the theory
# prediction of the main text.

print("Plot_Autocorrelation")
subprocess.run(["python", "-u", "Plot_Autocorrelation.py", "--para_str=Htop5e+03"])

