# PsychoNet
___
This repository contains the official implementation of the PsychoNet architecture from the paper "Learning frequency domain codes for semantic vision".


## Usage
___

### Requirements
- `torch >= 2.6.0`
- `torchvision >= 2.6.0`

### Model loading
`model_building.py` contains functions for building models defined in YAML config files to a usable `nn.Module` instance. Config for all models used in the main body of our paper are included in the `configs` folder. For example, the following code snippet can be used to build the Psycho-S model.
```python
# EXAMPLE: load Psycho-S
model = build_model('configs/psycho_s.yaml')
print(model)

# count parameters, layers and FLOPs
print(f"{count_model_params(model) / 1e6:.4f}M parameters")
print(count_model_layers(model))
print(f"{count_flops(model, (1, 3, 224, 224)) / 1e9:.4f}G FLOPS")
```


## Acknowledgements
___
We acknowledge the following third-party libraries used in this repository.

- We use the complex-valued neural network blocks implemented in [`complexPyTorch`](https://github.com/wavefrontshaping/complexPyTorch). This library is included as `modules/complexPyTorch`.

## License
___
MIT License