clear
clc

nominal_masses = [1;2.5;5.7;3.9;2.5;2.5;0.7];
nominal_inertias = [0.02;0.04;0.06;0.05;0.04;0.04;0.01];
load('trajectories.mat')

for kk=1:500
    mass_offsets = nominal_masses/2;
    inertia_offsets = nominal_inertias/2;    
    

    M = nominal_masses - 2*diag(mass_offsets)*rand(7,1) + mass_offsets ;
    I = nominal_inertias - 2*diag(inertia_offsets)*rand(7,1) + inertia_offsets;
    A_dis = 2*diag(nominal_masses(2:end))*rand(6,1);
    omega_dis = 2*rand(6,1);
    phi_dis = rand(6,1);  
    fric_param = diag(nominal_masses(2:end))*(4*rand(6,1) - 2);
    fric_mat = randi([0,1],6,36);
    cur_traj = traj_vector{kk};
    cur_t = time_vector{kk};
    q0 = zeros(6,1);
    for ii=1:6
        traj_q = cur_traj{ii};
        q0(ii) = traj_q(0);
    end
    
    A_dis_cell{kk} = A_dis;
    omega_dis_cell{kk} = omega_dis;
    phi_dis_cell{kk} = phi_dis;
    fric_param_cell{kk} = fric_param;
    fric_mat_cell{kk} = fric_mat;
    mass_cell{kk} = M;
    inertia_cell{kk} = I;
    state_0_cell{kk} = [q0 + 0.5*rand(6,1)-0.5;rand(6,1)];
end

save('parameters.mat','A_dis_cell','omega_dis_cell','phi_dis_cell','fric_param_cell','fric_mat_cell',...
    'mass_cell','inertia_cell','state_0_cell');
