close all
clear all
clc

%points to visit for UR5
q1 = [-0.07, -1.05, 0.45, 2.3, 1.37, -1.33];
q2 = [1.28, 0.35, 1.75, 0.03, 0.1, -1.22];
q3 = [-0.08, 0.85, -0.23, 2.58, 2.09, -2.36];
q4 = [-0.7, -0.76, -1.05, -0.05, -3.08, 2.37];

q = [q1;q2;q3;q4];


x_min = -pi;
x_max = pi;

N_traj = 1000;
N_points_per_seg = 100;


colors = ['k','r'];

disp('generating test trajectories...')

for kk=1:N_traj
    
    x0 = (x_max-x_min).*rand(6,1) + x_min;
    seg_time = 5 + 4*rand() - 2; %+- 2
    total_N_seg = 4;
    total_seg_time = seg_time * total_N_seg;
    
    rand_idx = randperm(length([1:4]));
    c_nom = [q(rand_idx(1),:); q(rand_idx(2),:); q(rand_idx(3),:); q(rand_idx(4),:)];
    
    c = c_nom + 0.6*rand(4,6) - 0.3; %+-0.3
    
    normal_seq = [1,2,3,4];
    sh_seq = normal_seq(randperm(4));
    idx_nom = 1;
    idx = sh_seq(idx_nom);
    
    q_0 = c(idx,:);
    seg_1 = [linspace(x0(1),q_0(1),N_points_per_seg); linspace(x0(2),q_0(2),N_points_per_seg);linspace(x0(3),q_0(3),N_points_per_seg);...
             linspace(x0(4),q_0(4),N_points_per_seg); linspace(x0(5),q_0(5),N_points_per_seg);linspace(x0(6),q_0(6),N_points_per_seg)];
    all_seg = seg_1;    
    
    q_next = c(idx,:);
    q_now = q_0;    
    
    for jj=1:total_N_seg-1
        
        next_seg = [linspace(q_now(1),q_next(1),N_points_per_seg); linspace(q_now(2),q_next(2),N_points_per_seg);linspace(q_now(3),q_next(3),N_points_per_seg);...
                    linspace(q_now(4),q_next(4),N_points_per_seg); linspace(q_now(5),q_next(5),N_points_per_seg);linspace(q_now(6),q_next(6),N_points_per_seg)];        
        all_seg = [all_seg next_seg];
        q_now = q_next;        
        
        idx_nom=idx_nom+1;   
        idx = sh_seq(idx_nom);
        q_next = c(idx,:);       
        
    end
    
    
    t_(1) = 0;
    for tt=1:numel(all_seg)/6-1     
        t_(tt+1) = t_(tt) + total_seg_time/(numel(all_seg)/6);
    end
    
    disp('creating smooth line..')
    kk
    
    for iii = 1:6
        f{iii} = fit(t_',all_seg(iii,:)','smoothingspline','SmoothingParam',.9);
        %subplot(6,1,iii)
        %plotHandles(:,iii) = plot(f{iii},t_,all_seg(iii,:));        
    end              
    
    
    traj_vector{kk} = f;    
    time_vector{kk} = t_;   
end
save('trajectories.mat','traj_vector','time_vector');