function get_data_UR5

clear
clear global
clc
close all

load('trajectories.mat')
load('parameters.mat')
global cur_traj I M u_max q_dot_max q_dot_sat u_sat ll u_real_max q_max q_sat
global K_LQR LQR_u A_dis omega_dis phi_dis fric_param fric_mat q_des_max error_max  neural_net

%normalize later
u_max = zeros(6,1);
q_dot_max = zeros(6,1);
q_des_max = zeros(6,1);
q_max = zeros(6,1);
error_max  = zeros(6,1);
u_real_max = zeros(6,1);

%these are  upper bounds of the maximum values to be used for normalization
%for the neural network training

u_sat =  [45;160;80;20;32;15];
q_dot_sat = [2;2;2;3;3;2];
q_sat = [3.6;3.6;3.5;3.6;3.7;3.7];
   
%for LQR   
A_LQR = [zeros(6,6) eye(6);zeros(6,12)];
B_LQR = [zeros(6,6);eye(6)];
Q_LQR = eye(12);
R_LQR = eye(6);
K_LQR = lqr(A_LQR, B_LQR, Q_LQR, R_LQR);


for kk = 1:100   
    kk
    
    LQR_u = 0;
    if kk > 50 %LQR controller for some instances
        LQR_u = 1;
    end    
     
    M = mass_cell{kk};
    I = inertia_cell{kk};
    A_dis = A_dis_cell{kk};
    omega_dis = omega_dis_cell{kk};
    phi_dis = phi_dis_cell{kk};  
    fric_param = fric_param_cell{kk};
    fric_mat = fric_mat_cell{kk};
    state_0 = state_0_cell{kk};
    
    cur_traj = traj_vector{kk};
    cur_t = time_vector{kk};
    q0 = zeros(6,1);
    for ii=1:6
        traj_q = cur_traj{ii};
        q0(ii) = traj_q(0);
    end    
    
    tstart = 0;
    tfinal = cur_t(end);
 
    size_data_points = 500;
    tspan = linspace(tstart,tfinal,size_data_points);
    
    atol_ode = 1e-6;
    rtol_ode = 1e-6;
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);

    [tout,qout] = ode45(@control_as,tspan,state_0);
    state_norm = zeros(numel(tout),12);
    u_norm = zeros(numel(tout),6);    
    u = zeros(numel(tout),6);
    t_norm = zeros(numel(tout),1);
    for ii = 1:numel(tout)
        [~,state_norm(ii,:) u_norm(ii,:) u(ii,:)] = control_as(tout(ii),qout(ii,:));
    end
    
    cur_train_data = [state_norm,t_norm/28,u_norm];    
    file_name = sprintf('training_data_python/traj_%d',kk);
    save(file_name,'cur_train_data');

end

function [dydt state_norm u_norm u]= control_as(t,state)

    global cur_traj I M u_max q_dot_max u_sat q_dot_sat neural_net
    global K_LQR LQR_u A_dis omega_dis phi_dis fric_param fric_mat q_max q_sat
     
    if size(state,1)==1
        state = state';
    end
    
    q = state(1:6);
    q_dot = state(7:12);

    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(t);
        [q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
    end     
    
    %dynamic model terms
 
    B_in = inertia(I(1),I(2),I(3),I(4),I(5),I(6),I(7),M(1),M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    C_cor = Coriolis(I(2),I(3),I(4),I(5),I(6),I(7),q_dot(1),q_dot(2),q_dot(3),q_dot(4),q_dot(5),q_dot(6),...
             M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    g_grav = gravity(M(2),M(3),M(4),M(5),M(6),q(2),q(3),q(4),q(5),q(6));

    dis = diag(A_dis)*[...
        sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2));sin(omega_dis(3)*t+phi_dis(3));...
        sin(omega_dis(4)*t+phi_dis(4));sin(omega_dis(5)*t+phi_dis(5));sin(omega_dis(6)*t+phi_dis(6))];
    
    
    friction = q_dot.*fric_mat*diag(fric_param)*q_dot;      
 

    K_p = diag([1; 1; 1; 1; 1; 1]);
    K_v = diag([1; 1; 1; 1; 1; 1]);
    
    error = q-q_des';
    error_dot = q_dot - q_des_dot';
    
    %controller 
        
    u =   - dis - friction + C_cor*q_dot + g_grav + B_in*(q_des_ddot' - K_v*error_dot - K_p*error);
      
    if LQR_u
        u = -dis - friction + C_cor*q_dot + g_grav + B_in*(-K_LQR*[error;error_dot]);
    end
    dynamics = inv(B_in)*( u - g_grav - C_cor*q_dot  + dis + friction);   
    %update max values
    for ii=1:numel(u)
        u_max(ii) = max(u_max(ii),abs(u(ii)));
        q_max(ii) = max(q_max(ii),abs(q(ii)));
        q_dot_max(ii) = max(q_dot_max(ii),abs(q_dot(ii)));
    end

  
    %normalize everything to (0,1)    
    u_norm = max(min(u,u_sat),-u_sat);
    q_dot_norm = max(min(q_dot,q_dot_sat),-q_dot_sat);
    q_norm = max(min(q,q_sat),-q_sat);
    for ii=1:6
        u_norm(ii) = (u_norm(ii) - (-u_sat(ii) ))/ (u_sat(ii)  - (-u_sat(ii) ));
        q_norm(ii) = (q_norm(ii) - (-q_sat(ii) ))/ (q_sat(ii)  - (-q_sat(ii) ));
        q_dot_norm(ii) = (q_dot_norm(ii) - (-q_dot_sat(ii) ))/ (q_dot_sat(ii)  - (-q_dot_sat(ii) ));
    end
    
    state_norm = [q_norm;q_dot_norm];
    
    dydt = [q_dot;dynamics];
    