clear
close all
clc

load('data.mat');

t_vector = linspace(0,28,1000);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50        
        error_cur = error_cell{kk};
        error_dot_cur = error_dot_cell{kk};
        ev_cur = ev_cell{kk};
        d_1_hat_cur = d_1_hat_cell{kk};
        d_2_hat_cur = d_2_hat_cell{kk};
        t_cur = t_cell{kk};
        u_cur = u_cell{kk};
        u_NN_cur = u_NN_cell{kk};
        if time > t_cur(end)
            continue
        end
        [clos_val,clos_idx] = min(abs(t_cur - time));
        for qq=1:6
            error_all(jj,qq) = error_cur(clos_idx,qq);
            u_all(jj,qq) = u_cur(clos_idx,qq);
            u_NN_all(jj,qq) = u_NN_cur(clos_idx,qq);
            error_dot_all(jj,qq) = error_dot_cur(clos_idx,qq);           
            ev_all(jj,qq) = ev_cur(clos_idx,qq);
        end
        d_1_hat_all(jj) = d_1_hat_cur(clos_idx);
        d_2_hat_all(jj) = d_2_hat_cur(clos_idx);        
        error_sums_all(jj) = norm(error_cur(clos_idx,:)) + norm(error_dot_cur(clos_idx,:));
        ev_norm_all(jj) = norm(ev_cur(clos_idx,:));
        jj = jj+1;
    end 
    for qq=1:6
        error_avg(idx,qq) = mean(error_all(:,qq));
        error_std(idx,qq) = std(error_all(:,qq));
        
        u_avg(idx,qq) = mean(u_all(:,qq));
        u_std(idx,qq) = std(u_all(:,qq));
        
        u_NN_avg(idx,qq) = mean(u_NN_all(:,qq));
        u_NN_std(idx,qq) = std(u_NN_all(:,qq));
        
        error_dot_avg(idx,qq) = mean(error_dot_all(:,qq));
        error_dot_std(idx,qq) = std(error_dot_all(:,qq));   
        
        ev_avg(idx,qq) = mean(ev_all(:,qq));
        ev_std(idx,qq) = std(ev_all(:,qq));
    end
    d_1_hat_avg(idx) = mean(d_1_hat_all);
    d_1_hat_std(idx) = std(d_1_hat_all);
    d_2_hat_avg(idx) = mean(d_2_hat_all); 
    d_2_hat_std(idx) = std(d_2_hat_all);  
    error_sums_avg(idx) = mean(error_sums_all);
    error_sums_std(idx) = std(error_sums_all);
    ev_norm_avg(idx) = mean(ev_norm_all);
    ev_norm_std(idx) = std(ev_norm_all);
end
%this plots errors.
figure(1)
subplot(2,2,1)
plot(t_vector,error_sums_avg,'linewidth',2)
hold on
box on
grid on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(\|e(t)\| + \|\dot{e}(t)\|) $','Interpreter','latex','fontsize',20)
xlim([0,20])
subplot(2,2,2)
plot(t_vector,error_sums_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlim([0,20])
ylabel('std$(\|e(t)\| + \|\dot{e}(t)\|) $','Interpreter','latex','fontsize',20)
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);


%this plots ev
figure(2)
subplot(1,2,1)
plot(t_vector,ev_norm_avg,'linewidth',2)
hold on
box on
grid on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(\|e_v(t)\|)$','Interpreter','latex','fontsize',25)
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
xlim([0,20])
subplot(1,2,2)
plot(t_vector,ev_norm_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlim([0,20])
ylabel('std$(\|e_v(t)\|)$','Interpreter','latex','fontsize',25)
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);

%this plots control input
figure(4)
subplot(2,2,1)
plot(t_vector,u_avg,'linewidth',2)
hold on
box on
grid on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(u(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_1$','$u_2$','$u_3$','$u_4$','$u_5$','$u_6$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','south','orientation','horizontal','fontsize',15)
subplot(2,2,2)
plot(t_vector,u_std,'linewidth',2)
box on
grid on
ax = gca;
ax.FontSize = 15; 
ylabel('std$(u(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_1$','$u_2$','$u_3$','$u_4$','$u_5$','$u_6$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','south','orientation','horizontal','fontsize',15)
subplot(2,2,3)
plot(t_vector,u_NN_avg,'linewidth',2)
box on
grid on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('mean$(u_{nn}(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_{nn,1}$','$u_{nn,2}$','$u_{nn,3}$','$u_{nn,4}$','$u_{nn,5}$','$u_{nn,6}$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','south','orientation','horizontal','fontsize',15)
subplot(2,2,4)
plot(t_vector,u_NN_std,'linewidth',2)
box on
grid on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(u_{nn}(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_{nn,1}$','$u_{nn,2}$','$u_{nn,3}$','$u_{nn,4}$','$u_{nn,5}$','$u_{nn,6}$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','south','orientation','horizontal','fontsize',15)
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);


%this plots adaptation signals
figure(5)
subplot(2,1,1)
plot(t_vector,d_1_hat_avg,'linewidth',2)
hold on
plot(t_vector,d_2_hat_avg,'linewidth',2)
box on
grid on
ax = gca;
ax.FontSize = 15; 
legend({'mean($\hat{\ell}_1(t))$','mean($\hat{\ell}_2(t))$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','northeast','orientation','horizontal','fontsize',20)
xlim([0,20])
subplot(2,1,2)
plot(t_vector,d_1_hat_std,'linewidth',2)
hold on
box on
grid on
ax = gca;
ax.FontSize = 15; 
plot(t_vector,d_2_hat_std,'linewidth',2)
legend({'std($\hat{\ell}_1(t))$','std($\hat{\ell}_2(t))$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','northeast','orientation','horizontal','fontsize',20)
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
xlim([0,20])
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);


 
clear error_avg error_std error_dot_avg error_dot_std error_sums_avg error_sums_std  error_sums_all
load('data_only_nn.mat');
t_vector = linspace(0,28,1000);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50
        
        error_cur = error_cell{kk};
        error_dot_cur = error_dot_cell{kk};       
        t_cur = t_cell{kk};
        if time > t_cur(end)
            continue
        end
        [clos_val,clos_idx] = min(abs(t_cur - time));
        for qq=1:6
            error_all(jj,qq) = error_cur(clos_idx,qq);
            error_dot_all(jj,qq) = error_dot_cur(clos_idx,qq);     
            error_sums_all(jj) = norm(error_cur(clos_idx,:)) + norm(error_dot_cur(clos_idx,:));
        end
        jj = jj+1;
    end 
    for qq=1:6
        error_avg(idx,qq) = mean(error_all(:,qq));
        error_std(idx,qq) = std(error_all(:,qq));        
        error_dot_avg(idx,qq) = mean(error_dot_all(:,qq));
        error_dot_std(idx,qq) = std(error_dot_all(:,qq));               
    end    
    
    error_sums_avg(idx) = mean(error_sums_all);
    error_sums_std(idx) = std(error_sums_all);
    
end
figure(1)
subplot(2,2,3)
plot(t_vector,error_sums_avg,'linewidth',2)
box on
grid on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(\|e(t)\| + \|\dot{e}(t)\|) $','Interpreter','latex','fontsize',20)
xlim([0,20])
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
legend({'Non-adaptive'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,4)
plot(t_vector,error_sums_avg,'linewidth',2)
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlim([0,20])
ylabel('std$(\|e(t)\| + \|\dot{e}(t)\|) $','Interpreter','latex','fontsize',20)
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
legend({'Non-adaptive'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)


clear error_avg error_std error_dot_avg error_dot_std d_1_hat_avg d_2_hat_avg error_sums_avg error_sums_std ev_norm_avg ev_norm_std error_sums_all
load('data_no_nn.mat');
t_vector = linspace(0,28,1000);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:49
        if kk==14 || kk==17 %unstable
            continue
        end
        error_cur = error_cell{kk};
        error_dot_cur = error_dot_cell{kk};
        d_1_hat_cur = d_1_hat_cell{kk};
        d_2_hat_cur = d_2_hat_cell{kk};
        ev_cur = ev_cell{kk};
        t_cur = t_cell{kk};
        if time > t_cur(end)
            continue
        end
        [clos_val,clos_idx] = min(abs(t_cur - time));
        for qq=1:6
            error_all(jj,qq) = error_cur(clos_idx,qq);
            error_dot_all(jj,qq) = error_dot_cur(clos_idx,qq);           
        end
        d_1_hat_all(jj) = d_1_hat_cur(clos_idx);
        d_2_hat_all(jj) = d_2_hat_cur(clos_idx);
        error_sums_all(jj) = norm(error_cur(clos_idx,:)) + norm(error_dot_cur(clos_idx,:));
        ev_norm_all(jj) = norm(ev_cur(clos_idx,:));
        jj = jj+1;
    end 
    for qq=1:6
        error_avg(idx,qq) = mean(error_all(:,qq));
        error_std(idx,qq) = std(error_all(:,qq));   

        
        error_dot_avg(idx,qq) = mean(error_dot_all(:,qq));
        error_dot_std(idx,qq) = std(error_dot_all(:,qq));
     end   
        d_1_hat_avg(idx) = mean(d_1_hat_all);
        d_2_hat_avg(idx) = mean(d_2_hat_all);        
        error_sums_avg(idx) = mean(error_sums_all);
        error_sums_std(idx) = std(error_sums_all); 
        ev_norm_avg(idx) = mean(ev_norm_all);
        ev_norm_std(idx) = std(ev_norm_all);
end

figure(1)
subplot(2,2,1)
plot(t_vector,error_sums_avg,'linewidth',2)

legend({'Proposed','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,2)
plot(t_vector,error_sums_std,'linewidth',2)

legend({'Proposed','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)

figure(2)
subplot(1,2,1)
plot(t_vector,ev_norm_avg,'linewidth',2)
legend({'Proposed','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)

subplot(1,2,2)
plot(t_vector,ev_norm_std,'linewidth',2)
legend({'Proposed','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
