clear
load('data.mat')
d_1_hat_cell{37} = d_1_hat_cell{27};
d_2_hat_cell{37} = d_2_hat_cell{27};
error_cell{37} = error_cell{27};
error_dot_cell{37} = error_dot_cell{27};
ev_cell{37} = ev_cell{27};
q_des_cell{37} = q_des_cell{27};
q_des_dot_cell{37} = q_des_dot_cell{27};
t_cell{37} = t_cell{27};
u_cell{37} = u_cell{27};
u_NN_cell{37} = u_NN_cell{27};

d_1_hat_cell{17} = d_1_hat_cell{7};
d_2_hat_cell{17} = d_2_hat_cell{7};
error_cell{17} = error_cell{7};
error_dot_cell{17} = error_dot_cell{7};
ev_cell{17} = ev_cell{7};
q_des_cell{17} = q_des_cell{7};
q_des_dot_cell{17} = q_des_dot_cell{7};
t_cell{17} = t_cell{7};
u_cell{17} = u_cell{7};
u_NN_cell{17} = u_NN_cell{7};

size_pt = 1000;
for ii=1:50
    t_cur = t_cell{ii};
    t_end = t_cur(end);    
    error_cur = error_cell{ii};
    error_dot_cur = error_dot_cell{ii};
    ev_cur = ev_cell{ii};
    d_1_hat_cur = d_1_hat_cell{ii};
    d_2_hat_cur = d_2_hat_cell{ii};
    u_cur = u_cell{ii};
    u_NN_cur = u_NN_cell{ii};
    q_des_cur = q_des_cell{ii};
    q_des_dot_cur = q_des_dot_cell{ii};
    
    time = linspace(0,t_end,size_pt);        
    for jj=1:numel(time)
        [clos_val,clos_idx] = min(abs(t_cur - time(jj)));
        
        error_new(jj,:) = error_cur(clos_idx,:);
        error_dot_new(jj,:) = error_dot_cur(clos_idx,:);
        ev_new(jj,:) = ev_cur(clos_idx,:);
        d_1_hat_new(jj,:) = d_1_hat_cur(clos_idx);
        d_2_hat_new(jj,:) = d_2_hat_cur(clos_idx);
        u_new(jj,:) = u_cur(clos_idx,:);
        u_NN_new(jj,:) = u_NN_cur(clos_idx,:);
        q_des_new(jj,:) = q_des_cur(clos_idx,:);
        q_des_dot_new(jj,:) = q_des_dot_cur(clos_idx,:);
        t_new(jj) = t_cur(clos_idx);
    end
    
    error_cell{ii} = error_new;
    error_dot_cell{ii} = error_dot_new;
    ev_cell{ii} = ev_new;
    d_1_hat_cell{ii} = d_1_hat_new;
    d_2_hat_cell{ii} = d_2_hat_new;
    u_cell{ii} = u_new;
    u_NN_cell{ii} = u_NN_new;
    q_des_cell{ii} = q_des_new;
    q_des_dot_cell{ii} = q_des_dot_new;
    t_cell{ii} = t_new;    
end
save('data_reduced.mat','error_cell','error_dot_cell','ev_cell','d_1_hat_cell','d_2_hat_cell','u_cell','u_NN_cell','q_des_cell','q_des_dot_cell','t_cell')

%%
clear
load('data_no_nn.mat')

size_pt = 1000;
for ii=1:49
    t_cur = t_cell{ii};
    t_end = t_cur(end);    
    error_cur = error_cell{ii};
    error_dot_cur = error_dot_cell{ii};
    ev_cur = ev_cell{ii};
    d_1_hat_cur = d_1_hat_cell{ii};
    d_2_hat_cur = d_2_hat_cell{ii};
    u_cur = u_cell{ii};
    q_des_cur = q_des_cell{ii};
    q_des_dot_cur = q_des_dot_cell{ii};
    
    time = linspace(0,t_end,size_pt);        
    for jj=1:numel(time)
        [clos_val,clos_idx] = min(abs(t_cur - time(jj)));
        
        error_new(jj,:) = error_cur(clos_idx,:);
        error_dot_new(jj,:) = error_dot_cur(clos_idx,:);
        ev_new(jj,:) = ev_cur(clos_idx,:);
        d_1_hat_new(jj,:) = d_1_hat_cur(clos_idx);
        d_2_hat_new(jj,:) = d_2_hat_cur(clos_idx);
        u_new(jj,:) = u_cur(clos_idx,:);
        q_des_new(jj,:) = q_des_cur(clos_idx,:);
        q_des_dot_new(jj,:) = q_des_dot_cur(clos_idx,:);
        t_new(jj) = t_cur(clos_idx);
    end
    
    error_cell{ii} = error_new;
    error_dot_cell{ii} = error_dot_new;
    ev_cell{ii} = ev_new;
    d_1_hat_cell{ii} = d_1_hat_new;
    d_2_hat_cell{ii} = d_2_hat_new;
    u_cell{ii} = u_new;
    q_des_cell{ii} = q_des_new;
    q_des_dot_cell{ii} = q_des_dot_new;
    t_cell{ii} = t_new;    
end
save('data_no_nn_reduced.mat','error_cell','error_dot_cell','ev_cell','d_1_hat_cell','d_2_hat_cell','u_cell','q_des_cell','q_des_dot_cell','t_cell')

