function test

clear
clear global
clc
close all

load('trajectories.mat')
load('parameters.mat')

global cur_traj I M u_max q_dot_max q_dot_sat u_sat ll u_real_max 
global  A_dis omega_dis phi_dis fric_param fric_mat   neural_net K_p K_v k_d_1 k_d_2 q_sat kk


K_p = 1*diag([1; 1; 1; 1; 1; 1]);
K_v = 10*diag([1; 1; 1; 1; 1; 1]);
k_d_1 = 10;
k_d_2 = 10;


%these are used to test maximum obtained values in a first run in order to
%normalize later
u_max = zeros(6,1);
q_dot_max = zeros(6,1);
u_real_max = zeros(6,1);
ll = 1;

kk = 1;
while kk < 50
    
    disp('new trajectory!');
    %take from test instances (>100)
    kk_idx = kk+200;
    
    M = mass_cell{kk_idx};
    I = inertia_cell{kk_idx};
    A_dis = A_dis_cell{kk_idx};
    omega_dis = omega_dis_cell{kk_idx};
    phi_dis = phi_dis_cell{kk_idx};  
    fric_param = fric_param_cell{kk_idx};
    fric_mat = fric_mat_cell{kk_idx};
    state_0 = state_0_cell{kk_idx};
    cur_traj = traj_vector{kk_idx};
    cur_t = time_vector{kk_idx};
    q0 = zeros(6,1);
    for ii=1:6
        traj_q = cur_traj{ii};
        q0(ii) = traj_q(0);
    end
    
   
    
    tstart = 0;
    tfinal = cur_t(end);
    size_data_points = 1000;
    tspan = linspace(0,tfinal,size_data_points);


    atol_ode = 1e-6;
    rtol_ode = 1e-6;
    tstart = tic;
    
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode, 'Events', @(t,y) EventFunction(t,y,tstart));    
    %options = odeset( 'Events',  @(t,y) EventFunction(t,y,tstart));    
    [tout,qout] = ode23(@control_as,[0 tfinal],[state_0;0;0.01],options);    

    error = zeros(numel(tout),6);
    error_dot = zeros(numel(tout),6);
    ev = zeros(numel(tout),6);
    d_1_hat = zeros(numel(tout),1);
    d_2_hat = zeros(numel(tout),1);
    q_des = zeros(numel(tout),6);
    q_des_dot = zeros(numel(tout),6);
    u = zeros(numel(tout),6);

    for ii = 1:numel(tout)
        [~,error(ii,:), error_dot(ii,:), ev(ii,:), u(ii,:), q_des(ii,:), q_des_dot(ii,:),d_1_hat(ii), d_2_hat(ii)] = control_as(tout(ii),qout(ii,:));
    end
   

    state_0 = qout(end,:)' ;
    tNow = tout(end); 
    tspan = linspace(tNow,tfinal,size_data_points/2);
    
    
    if tNow == tfinal
        
        disp('tnow = 50, continuing...') 
        error_cell{kk} = error;
        error_dot_cell{kk} = error_dot;
        ev_cell{kk} = ev;    
        u_cell{kk} = u;
        t_cell{kk} = tout;
        d_1_hat_cell{kk} = d_1_hat;
        d_2_hat_cell{kk} = d_2_hat;
        q_des_cell{kk} = q_des;
        q_des_dot_cell{kk} = q_des_dot;
        figure()
        plot(tout,error)
        kk = kk + 1;
        continue
    end
    
    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(tNow);
        [q_des_dot(ii),q_des_ddot(ii) ] = differentiate(traj_q,tNow);        
    end  
    tspan = linspace(tNow,tfinal,size_data_points/2);
    
    %this is for the sliding surface ev = 0 the system evolves in due to
    %the discontinuity of the controller
    disp('running ode 2...')
    options2 = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);
    [tout2,qout2] = ode45(@sliding,tspan,state_0,options2);
    
    error2 = zeros(numel(tout2),6);
    error_dot2 = zeros(numel(tout2),6);
    ev2 = zeros(numel(tout2),6);
    d_1_hat2 = zeros(numel(tout2),1);
    d_2_hat2 = zeros(numel(tout2),1);
    q_des2 = zeros(numel(tout2),6);
    q_des_dot2 = zeros(numel(tout2),6);
    u2 = zeros(numel(tout2),6);
    
    
    for ii = 1:numel(tout2)
        [~,error2(ii,:), error_dot2(ii,:), ev2(ii,:), u2(ii,:), q_des2(ii,:), q_des_dot2(ii,:),d_1_hat2(ii), d_2_hat2(ii)] = sliding(tout2(ii),qout2(ii,:));
    end
    
    error_all = [error;error2];
    error_dot_all = [error_dot;error_dot2];
    ev_all = [ev;ev2];
    u_all = [u;u2];
    q_des_all = [q_des;q_des2];
    q_des_dot_all = [q_des_dot;q_des_dot2];
    d_1_hat_all = [d_1_hat;d_1_hat2];
    d_2_hat_all = [d_2_hat;d_2_hat2];
    tout_all = [tout;tout2];
    
%     figure()
%      plot(tout_all,error_all)
% %     figure()
% %     plot(tout_all, error_dot_all)
% %     figure()
% %     plot(tout_all,ev_all)
    
    error_cell{kk} = error_all;
    error_dot_cell{kk} = error_dot_all;
    ev_cell{kk} = ev_all;    
    u_cell{kk} = u_all;
    t_cell{kk} = tout_all;
    d_1_hat_cell{kk} = d_1_hat_all;
    d_2_hat_cell{kk} = d_2_hat_all;
    q_des_cell{kk} = q_des_all;
    q_des_dot_cell{kk} = q_des_dot_all;
    kk = kk +1;
end
save('data_no_nn.mat','error_cell','error_dot_cell','ev_cell','u_cell','d_1_hat_cell','d_2_hat_cell',...
    't_cell','q_des_cell','q_des_dot_cell')



function [dydt error2 error_dot2 ev2 u2 q_des2 q_des_dot2 d_1_hat2 d_2_hat2] = sliding(t,state)
    
    global cur_traj I M u_sat q_dot_sat  q_sat
    global A_dis omega_dis phi_dis fric_param fric_mat neural_net K_p K_v k_d_1 k_d_2
    
    if size(state,1)==1
        state = state';
    end
    
    q = state(1:6);
    q_dot = state(7:12);
    d_1_hat = state(13);
    d_2_hat = state(14);
    
    t;
    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(t);
        [q_des_dot(ii),q_des_ddot(ii) ] = differentiate(traj_q,t);        
    end    
    q_des_ddot = q_des_ddot';
    q_des = q_des';    
    q_des2 = q_des;
    q_des_dot = q_des_dot';
    q_des_dot2 = q_des_dot;
    error = q-q_des;
    error_dot = q_dot - q_des_dot;
    
    error2 = error;
    error_dot2 = error_dot;  
       
    
    vd = q_des_dot - K_p*error;
    vd_dot = q_des_ddot - K_p*error_dot;
    ev = q_dot - vd;    %this is zero now - sliding surface
    ev2 = ev;
   
    q_ddot = vd_dot;

    u =  - K_v*ev - d_1_hat*ev;
    
    u2 = u;
    
    d_1_hat_dot = k_d_1*norm(ev)^2;   
    d_2_hat_dot = k_d_2*norm(ev);
    d_1_hat2 = d_1_hat;
    d_2_hat2 = d_2_hat;
    
    dydt = [q_dot; q_ddot;d_1_hat_dot;d_2_hat_dot];


function [dydt error error_dot ev u q_des q_des_dot d_1_hat d_2_hat]= control_as(t,state)
t
    global cur_traj I M     
    global A_dis omega_dis phi_dis fric_param fric_mat K_p K_v k_d_1 k_d_2 kk
    
    if size(state,1)==1
        state = state';
    end
    
    q = state(1:6);
    q_dot = state(7:12);
    d_1_hat = state(13);
    d_2_hat = state(14);

    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(t);
        [q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
    end       
    q_des = q_des';
    q_des_dot = q_des_dot';
    
    B_in = inertia(I(1),I(2),I(3),I(4),I(5),I(6),I(7),M(1),M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    C_cor = Coriolis(I(2),I(3),I(4),I(5),I(6),I(7),q_dot(1),q_dot(2),q_dot(3),q_dot(4),q_dot(5),q_dot(6),...
             M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    g_grav = gravity(M(2),M(3),M(4),M(5),M(6),q(2),q(3),q(4),q(5),q(6));

    dis = diag(A_dis)*[...
        sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2));sin(omega_dis(3)*t+phi_dis(3));...
        sin(omega_dis(4)*t+phi_dis(4));sin(omega_dis(5)*t+phi_dis(5));sin(omega_dis(6)*t+phi_dis(6))];
    
    
    new_term = [q_dot(1)*q_dot; q_dot(2)*q_dot; q_dot(3)*q_dot; q_dot(4)*q_dot; q_dot(5)*q_dot; q_dot(6)*q_dot];    
   
    friction = fric_mat*new_term;
       
    %no-nn controller
    error = q-q_des;
    error_dot = q_dot - q_des_dot;        
    
    vd = q_des_dot - K_p*error;
    ev = q_dot - vd;
    ev_hat = zeros(6,1);
    if norm(ev) >=  10^(-8)
       ev_hat = ev/norm(ev);
    end    
   
    u =  - K_v*ev - d_1_hat*ev - d_2_hat*ev_hat;
    
    norm(ev)
    
    dynamics = inv(B_in)*( u - g_grav - C_cor*q_dot + dis + friction);   
    d_1_hat_dot = k_d_1*norm(ev)^2;   
    d_2_hat_dot = k_d_2*norm(ev);
    
    dydt = [q_dot;dynamics;d_1_hat_dot;d_2_hat_dot];
    

function [value,isterminal,direction] = EventFunction(t,state,tstart)
    
    global cur_traj K_p 
    q = state(1:6);
    q_dot = state(7:12);
    d_1_hat = state(13);
    d_2_hat = state(14);
    
      
    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(t);
        [q_des_dot(ii),q_des_ddot(ii) ] = differentiate(traj_q,t);        
    end       
    q_des = q_des';
    q_des_dot = q_des_dot';
    error = q-q_des;

    vd = q_des_dot - K_p*error;
    ev = q_dot - vd;
    value = [norm(ev) - 10^(-5);10*60-toc(tstart)];
    isterminal = [true;true];    
    direction = [0;0];    
  
