function get_data

clear
clear global
clc
close all

load('parameters.mat')
load('trajectories.mat')
global cur_traj I M u_max q_dot_max q_dot_sat u_sat ll u_real_max 
global  A_dis omega_dis phi_dis fric_param fric_mat   neural_net K_p K_v k_d_1 k_d_2 q_sat kk

K_p = 1*diag([1; 1; 1; 1; 1; 1]);
K_v = 10*diag([1; 1; 1; 1; 1; 1]);
k_d_1 = 10;
k_d_2 = 10;

neural_net = importONNXNetwork('NeuralNetworkUR5.onnx','OutputLayerType','regression');

%these are used to test maximum obtained values in a first run in order to
%normalize later
u_max = zeros(6,1);
q_dot_max = zeros(6,1);
u_real_max = zeros(6,1);
ll = 1;

%these are conservative upper bounds of the maximum values
u_sat =  [45;160;80;20;32;15];
q_dot_sat = [2;2;2;3;3;2];
q_sat = [3.6;3.6;3.5;3.6;3.7;3.7];



for kk = 1:50
    
    disp('new trajectory!');
    %take from test instances (>100)
    kk_idx = kk+200;
    
    M = mass_cell{kk_idx};
    I = inertia_cell{kk_idx};
    A_dis = A_dis_cell{kk_idx};
    omega_dis = omega_dis_cell{kk_idx};
    phi_dis = phi_dis_cell{kk_idx};  
    fric_param = fric_param_cell{kk_idx};
    fric_mat = fric_mat_cell{kk_idx};
    state_0 = state_0_cell{kk_idx};
    cur_traj = traj_vector{kk_idx};
    cur_t = time_vector{kk_idx};

    
    
    tstart = 0;
    tfinal = cur_t(end);
    size_data_points = 1000;
    tspan = linspace(0,tfinal,size_data_points);


    atol_ode = 1e-4;
    rtol_ode = 1e-4;
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);    
     [tout,qout] = ode45(@control_as,tspan,state_0,options);

    error = zeros(numel(tout),6);
    error_dot = zeros(numel(tout),6);
    ev = zeros(numel(tout),6);
    d_1_hat = zeros(numel(tout),1);
    d_2_hat = zeros(numel(tout),1);
    q_des = zeros(numel(tout),6);
    q_des_dot = zeros(numel(tout),6);
    u = zeros(numel(tout),6);
    u_NN = zeros(numel(tout),6);


    for ii = 1:numel(tout)
        [~,error(ii,:), error_dot(ii,:), u_NN(ii,:), q_des(ii,:), q_des_dot(ii,:)] = control_as(tout(ii),qout(ii,:));
    end
    
    error_cell{kk} = error;
    error_dot_cell{kk} = error_dot;    
    u_NN_cell{kk} = u_NN;
    t_cell{kk} = tout;
    q_des_cell{kk} = q_des;
    q_des_dot_cell{kk} = q_des_dot;


end
save('data_only_nn.mat','error_cell','error_dot_cell','t_cell','u_NN_cell','q_des_cell','q_des_dot_cell')



function [dydt error error_dot u_NN q_des q_des_dot]= control_as(t,state)
t
    global cur_traj I M u_sat q_dot_sat  q_sat 
    global A_dis omega_dis phi_dis fric_param fric_mat neural_net K_p K_v k_d_1 k_d_2 kk
    
    if size(state,1)==1
        state = state';
    end
    kk
    q = state(1:6);
    q_dot = state(7:12);


    for ii=1:6
        traj_q = cur_traj{ii};
        q_des(ii) = traj_q(t);
        [q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
    end       
    q_des = q_des';
    q_des_dot = q_des_dot';
    
    B_in = inertia(I(1),I(2),I(3),I(4),I(5),I(6),I(7),M(1),M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    C_cor = Coriolis(I(2),I(3),I(4),I(5),I(6),I(7),q_dot(1),q_dot(2),q_dot(3),q_dot(4),q_dot(5),q_dot(6),...
             M(2),M(3),M(4),M(5),M(6),M(7),0,q(1),q(2),q(3),q(4),q(5),q(6));
    g_grav = gravity(M(2),M(3),M(4),M(5),M(6),q(2),q(3),q(4),q(5),q(6));

    dis = diag(A_dis)*[...
        sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2));sin(omega_dis(3)*t+phi_dis(3));...
        sin(omega_dis(4)*t+phi_dis(4));sin(omega_dis(5)*t+phi_dis(5));sin(omega_dis(6)*t+phi_dis(6))];
    
    
    new_term = [q_dot(1)*q_dot; q_dot(2)*q_dot; q_dot(3)*q_dot; q_dot(4)*q_dot; q_dot(5)*q_dot; q_dot(6)*q_dot];    
   
    friction = fric_mat*new_term;
       
    q_dot_norm = zeros(6,1);
    q_norm = zeros(6,1);
     
    for ii=1:6
        q_norm(ii) = (q(ii) - (-q_sat(ii) ))/ (q_sat(ii)  - (-q_sat(ii) ));
        q_dot_norm(ii) = (q_dot(ii) - (-q_dot_sat(ii) ))/ (q_dot_sat(ii)  - (-q_dot_sat(ii) ));
    end        
    t_norm = t/28;
    nn_input = [q_norm;q_dot_norm];
    tau_NN =  predict(neural_net,nn_input);
    for ii=1:6
        u_NN(ii) = tau_NN(ii)*(u_sat(ii) - (-u_sat(ii))) + (-u_sat(ii));
    end

   
    
    error = q-q_des;
    error_dot = q_dot - q_des_dot    ; 
   
    norm(error)
    norm(error_dot)
    
    u_NN = u_NN' - K_p*error - K_v*error_dot;
    
    dynamics = inv(B_in)*( u_NN - g_grav - C_cor*q_dot);    %removed friction+dis bc they lead to instability!
     
    dydt = [q_dot;dynamics];
    
