function get_data_pendulum

clear
clear global
clc
close all

global M L u_max q_dot_max q_dot_sat u_sat 
global A_dis omega_dis phi_dis    

load('parameters.mat')

g = 9.81;

%these are used to test maximum obtained values in a first run in order to
%normalize later
u_max = 0;
q_dot_max = 0;


%saturation values for the neural network data
u_sat =  10;
q_dot_sat = 1.35;


tfinal = 20;
size_data_points = 500;
tspan = linspace(0,tfinal,size_data_points);
    
atol_ode = 1e-6;
rtol_ode = 1e-6;
options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);

for kk=1:100
    kk

    %take from training instances 
    M = mass_cell{kk};
    L = length_cell{kk};
    A_dis = A_dis_cell{kk};
    omega_dis = omega_dis_cell{kk};
    phi_dis = phi_dis_cell{kk};  
    state_0 = state_0_cell{kk};
    
    
    [tout,qout] = ode45(@inv_pend,tspan,state_0);
    state_norm = zeros(numel(tout),2);
    u_norm = zeros(numel(tout),1);
    error = zeros(numel(tout),1);
    for ii = 1:numel(tout)
         [~, state_norm(ii,:), u_norm(ii), error(ii)] = inv_pend(tout(ii),qout(ii,:));
    end

%      plot(tout,error)
%      hold on
    
    
    cur_train_data = [state_norm, tout/20, u_norm];

    file_name = sprintf('training_data_python/traj_%d.mat',kk);
    save(file_name,'cur_train_data');    
   
end

function [dydt state_norm u_norm error]= inv_pend(t,state)
%t
    global  L q_dot_max u_sat q_dot_sat u_max
    global A_dis omega_dis phi_dis  
    
    if size(state,1)==1
        state = state';
    end
    
    q = state(1);
    q_dot = state(2);   

    dis = A_dis*[sin(omega_dis*t+phi_dis)];       
   
    
    error = 1 - cos(q-pi);
    error_dot = sin(q-pi)*q_dot;
    s = error+error_dot;
  
    g= 9.81;


    K_p = 1;
    %nominal controller
    
    u = -dis - q_dot - q_dot^2*cos(q-pi) + g/L*sin(q) - K_p*s*sin(q-pi);    
   
    if abs(u) > u_max
            u_max = abs(u);
    end
    if abs(q_dot) > q_dot_max
        q_dot_max = abs(q_dot);
    end
    
    
    dynamics = u - g/L*sin(q) + dis ;  
  
  
    %normalize everything to (0,1)    
    u_norm = max(min(u,u_sat),-u_sat);
    q_dot_norm = max(min(q_dot,q_dot_sat),-q_dot_sat);
    sin_norm = max(min(sin(q),1),-1);
    
    u_norm = (u_norm + u_sat )/ (u_sat + u_sat );
	sin_norm = (sin_norm + 1)/2;
    q_dot_norm = (q_dot_norm + q_dot_sat)/(q_dot_sat + q_dot_sat);
    
    state_norm = [sin_norm;q_dot_norm];
    
   
    dydt = [q_dot;dynamics];
