clear
close all
clc

load('pendulum_reward_cost.mat');

t_vector = linspace(0,9.5,4800);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50
        cost_cur = cost_cell{kk};
        reward_cur = reward_cell{kk};
        t_cur = tall_cell{kk};      
        
        if time > t_cur(end)
            continue
        end
        [clos_val,clos_idx] = min(abs(t_cur - time));
        cost_all(jj) = cost_cur(clos_idx);
        reward_all(jj) = reward_cur(clos_idx);        
        jj = jj+1;        
    end   
    cost_avg(idx) = mean(cost_all);
    reward_avg(idx) = mean(reward_all);   
    cost_std(idx) = std(cost_all);
    reward_std(idx) = std(reward_all);     
end
figure(1)
subplot(2,1,1)
plot(t_vector,reward_avg,'linewidth',2)
hold on
plot(t_vector,reward_std,'linewidth',2)
grid on
box on
ax = gca;
ax.FontSize = 15; 
legend({'mean(reward$(t)$)','std(reward$(t)$)'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','south','orientation','vertical','fontsize',20)
xlim([0,9.5])

subplot(2,1,2)
plot(t_vector,cost_avg,'linewidth',2)
hold on
plot(t_vector,cost_std,'linewidth',2)
grid on
box on
ax = gca;
ax.FontSize = 15; 
legend({'mean(cost$(t)$)','std(cost$(t)$)'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','south','orientation','vertical','fontsize',20)
xlim([0,9.5])
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)

pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);
