clear
clc

nominal_mass = 28;
nominal_inertia_A = 0.1;
nominal_inertia_0 = 0.01;
nominal_r = 0.01;
nominal_b = 0.01;
nominal_d = 0.01;
load('trajectories.mat')


for kk=1:500
    mass_offset = nominal_mass/2;
    inertia_A_offset = nominal_inertia_A/2;  
    inertia_0_offset = nominal_inertia_0/2;
    r_offset = nominal_r/2;
    b_offset = nominal_b/2;
    d_offset = nominal_d/2;
    
    mass = nominal_mass - mass_offset*rand() + mass_offset;
    inertia_A = nominal_inertia_A - inertia_A_offset*rand() + inertia_A_offset;
    inertia_0 = nominal_inertia_0 - inertia_0_offset*rand() + inertia_0_offset;
    model_r = nominal_r - r_offset*rand() + r_offset;
    model_b = nominal_b - b_offset*rand() + b_offset;
    model_d = nominal_d - d_offset*rand() + d_offset;    

    A_dis = 2*rand(2,1);
    omega_dis = rand(2,1);
    phi_dis = 2*rand(2,1);  
    fric_param = (4*rand(2,1) - 2);
    fric_mat = randi([0,1],2,3);
    
    cur_traj = traj_vector{kk};
    cur_t = time_vector{kk};
    q0 = zeros(2,1);
    for ii=1:2
        traj_q = cur_traj{ii};
        p_des(ii) = traj_q(0);
        q0(ii) = traj_q(0) + (-1)*rand() - 2;
    end  
    
    e_x = q0(1) - p_des(1);
    e_y = q0(2) - p_des(2);
    e_d = norm([e_x;e_y]);
    theta = atan2(-e_y,-e_x) + 0.5*rand()-0.25;
    theta_deg = theta*180/pi;
    
    state_0 = [q0;theta;0.5*rand()-0.25;0.5*rand()-0.25];
    
    A_dis_cell{kk} = A_dis;
    omega_dis_cell{kk} = omega_dis;
    phi_dis_cell{kk} = phi_dis;
    fric_param_cell{kk} = fric_param;
    fric_mat_cell{kk} = fric_mat;
    mass_cell{kk} = mass;
    inertia_A_cell{kk} = inertia_A;
    inertia_0_cell{kk} = inertia_0;
    model_r_cell{kk} = model_r;
    model_b_cell{kk} = model_b;
    model_d_cell{kk} = model_d;
    state_0_cell{kk} = state_0;
end

save('parameters.mat','A_dis_cell','omega_dis_cell','phi_dis_cell','fric_param_cell','fric_mat_cell',...
    'mass_cell','inertia_A_cell','inertia_0_cell','model_r_cell','model_b_cell','model_d_cell','state_0_cell');
