close all
clear global
clear 
clc

%points to be visited
q1 = [0,0];
q2 = [0,2];
q3 = [2,0];
q4 = [2,2];

q = [q1;q2;q3;q4];

%initial condition of open-loop trajectory
x_min = -5;
x_max = 5;

N_traj = 1000;
N_points_per_seg = 100;

seg_time = 5;
total_N_seg = 10;
total_seg_time = seg_time * total_N_seg;
colors = ['k','r'];

disp('generating test trajectories...')

for kk=1:N_traj
    x0 = (x_max-x_min).*rand(2,1) + x_min;
    seg_time = 5 + 4*rand() - 2; %+- 2
    total_N_seg = 4;
    total_seg_time = seg_time * total_N_seg;
    
    rand_idx = randperm(length([1:4]));
    c_nom = [q(rand_idx(1),:); q(rand_idx(2),:); q(rand_idx(3),:); q(rand_idx(4),:)];
    
    c = c_nom + 0.6*rand(4,2) - 0.3; %+-0.3
    
    normal_seq = [1,2,3,4];
    sh_seq = normal_seq(randperm(4));
    idx_nom = 1;
    idx = sh_seq(idx_nom);
    
    q_0 = c(idx,:);
    seg_1 = [linspace(x0(1),q_0(1),N_points_per_seg); linspace(x0(2),q_0(2),N_points_per_seg)];
    all_seg = seg_1;
    
    q_next = c(idx,:);
    q_now = q_0;
    for jj=1:total_N_seg-1
        
        next_seg = [linspace(q_now(1),q_next(1),N_points_per_seg); linspace(q_now(2),q_next(2),N_points_per_seg)];        
        all_seg = [all_seg next_seg];
        q_now = q_next;
        
        idx_nom=idx_nom+1;   
        idx = sh_seq(idx_nom);
        q_next = c(idx,:);
        
    end
   
    t_(1) = 0;
    for tt=1:numel(all_seg)/2-1     
        t_(tt+1) = t_(tt) + total_seg_time/(numel(all_seg)/2);
    end
    
    disp('creating smooth line..')
    kk
    
    
    for iii = 1:2
        f{iii} = fit(t_',all_seg(iii,:)','smoothingspline','SmoothingParam',.9);
        %figure()
        %plotHandles(:,iii) = plot(f{iii},t_,all_seg(iii,:));
       
    end              
       
    traj_vector{kk} = f;    
    time_vector{kk} = t_;
       
end
save('trajectories.mat','traj_vector','time_vector');
