function get_data_unicycle

clear
clear global
clc
close all

load('trajectories.mat')
load('parameters.mat')
global mass inertia_A inertia_0 model_r model_b model_d u_max vel_max q_max cur_traj u_sat vel_sat q_sat
global A_dis omega_dis phi_dis fric_param fric_mat 

%updated to figure out saturation values
u_max = zeros(2,1);
vel_max = zeros(2,1);
q_max = zeros(3,1);

%saturation values for the data normalization in the neural network
u_sat = [250;250];
vel_sat = [4;2];
q_sat = [8;8];


for kk = 1:100   
    kk
    
    disp('new traj!')
    
    %take from parameters.mat
    mass = mass_cell{kk};
    inertia_A = inertia_A_cell{kk};
    inertia_0 = inertia_0_cell{kk};
    model_r = model_r_cell{kk};
    model_b = model_b_cell{kk};
    model_d = model_d_cell{kk};    

    A_dis = A_dis_cell{kk};
    omega_dis = omega_dis_cell{kk};
    phi_dis = phi_dis_cell{kk};  
    fric_param = fric_param_cell{kk};
    fric_mat = fric_mat_cell{kk};
    
    cur_traj = traj_vector{kk};
    cur_t = time_vector{kk};
    
    state_0 = state_0_cell{kk};
    tstart = 0;
    tfinal = cur_t(end);
    
    size_data_points = 500;
    tspan = linspace(0,tfinal,size_data_points);
    
    atol_ode = 1e-6;
    rtol_ode = 1e-6;
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);

    [tout,qout] = ode45(@unicycle_2nd,tspan,state_0,options);
    
    
     state_norm = zeros(numel(tout),5);
     u_norm = zeros(numel(tout),2);
     t_norm = zeros(numel(tout),1);
     e_d = zeros(numel(tout),1);
     beta = zeros(numel(tout),1);
     
     for ii = 1:numel(tout)
         [~,state_norm(ii,:) u_norm(ii,:) t_norm(ii) e_d(ii) beta(ii)] = unicycle_2nd(tout(ii),qout(ii,:));
     end
%      plot(tout,e_d)
%      hold on
%      plot(tout,beta)
     

    %save data for neural network training
    cur_train_data = [state_norm, tout/28, u_norm];
    file_name = sprintf('training_data_python/traj_%d.mat',kk);
    save(file_name,'cur_train_data');
end


function [dydt state_norm  u_norm t_norm e_d beta] = unicycle_2nd(t,state)

	global mass inertia_A inertia_0 model_r model_b model_d u_max vel_max q_max cur_traj u_sat vel_sat q_sat
	global A_dis omega_dis phi_dis fric_param fric_mat   

    
    if size(state,1)==1
        state = state';
    end
    
	x = state(1);
	y = state(2);
	theta  = state(3); 
	theta_R_dot = state(4);
	theta_L_dot = state(5);
	    
    %create inertia matrix
    
	A = mass*model_r^2/4 + (inertia_A + mass*model_d^2)*model_r^2/model_b^2 + inertia_0;
	B = mass*model_r^2/4 - (inertia_A + mass*model_d^2)*model_r^2/model_b^2;
	M = [A B;B A];

    A = mass*model_r^2/4 + (inertia_A + mass*model_d^2)*model_r^2/model_b^2 + inertia_0;
    B = mass*model_r^2/4 - (inertia_A + mass*model_d^2)*model_r^2/model_b^2;
    M = [A B;B A];
    v = model_r/2*(theta_R_dot + theta_L_dot);
    omega = model_r/model_b*(theta_R_dot - theta_L_dot);
    vel_gen = [v;omega];
    dis = diag(A_dis)*[sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2))];       
    friction = vel_gen.*fric_mat*diag(fric_param)*vel_gen;

    %desired traj
	for ii=1:2
		traj_q = cur_traj{ii};
		q_des(ii) = traj_q(t);
		[q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
   	end 
   	x_des = q_des(1);
   	y_des = q_des(2);
   	x_des_dot = q_des_dot(1);
   	y_des_dot = q_des_dot(2);
   	x_des_ddot = q_des_ddot(1);
   	y_des_ddot = q_des_ddot(2);  	
    
    %gains
    k_d = .1; 
    k_beta = 2;
    k_v = 2;
    k_omega = 2;
    k_S = 1;
    k_D = 1;
    
  
    %model-based control
	e_x = x-x_des;
    e_y = y-y_des;
	e_d = norm([e_x;e_y]);
	sin_beta = e_x/e_d*sin(theta) - e_y/e_d*cos(theta);
	beta = asin(sin_beta);

	e_d_dot = -v*cos(beta) + x_des_dot*cos(beta + theta) + y_des_dot*sin(beta+theta);
    beta_dot = -omega + v/e_d*sin(beta) + y_des_dot/e_d*cos(beta+theta) - x_des_dot/e_d*sin(beta+theta);

    G = [-cos(beta)*model_r/2, 0;sin(beta)*model_r/(2*e_d), -model_r/model_b];

    G_dot = [sin(beta)*beta_dot*model_r/2, 0;(2*cos(beta)*beta_dot*model_r*e_d - 2*sin(beta)*model_r*e_d_dot)/(4*e_d^2), 0];

    G_inv_dot = -G^(-1)*G_dot*G^(-1);
    sum_diff_des = G^(-1)*[ -x_des_dot*cos(beta + theta) - y_des_dot*sin(beta + theta) - k_d*e_d ; 
                            x_des_dot/e_d*sin(beta+theta) - y_des_dot/e_d*cos(beta+theta) - k_beta*beta ] ;
    v_S_des = sum_diff_des(1);
    v_D_des = sum_diff_des(2);

    sum_diff_des_dot = G_inv_dot*[ -x_des_dot*cos(beta + theta) - y_des_dot*sin(beta + theta) - k_d*e_d ; 
                            x_des_dot/e_d*sin(beta+theta) - y_des_dot/e_d*cos(beta+theta) - k_beta*beta] + ...
                        G^(-1)*[
        -x_des_ddot*cos(beta+theta)+x_des_dot*sin(beta+theta)*(beta_dot+omega) - y_des_ddot*sin(beta+theta) - y_des_dot*cos(beta+theta)*(beta_dot + omega) - k_d*e_d_dot;
        ((x_des_ddot*sin(beta+theta) + x_des_dot*cos(beta+theta)*(beta_dot+omega))*e_d - x_des_dot*sin(beta+theta)*e_d_dot)/e_d^2 ...
        - ((y_des_ddot*cos(beta+theta) - y_des_dot*sin(beta+theta)*(beta_dot+omega))*e_d - y_des_dot*cos(beta+theta)*e_d_dot)/e_d^2-k_beta*beta_dot
        ];

    v_S_des_dot = sum_diff_des_dot(1);
    v_D_des_dot = sum_diff_des_dot(2);

    v_S = theta_R_dot + theta_L_dot;
    v_D = theta_R_dot - theta_L_dot;
    e_S = v_S - v_S_des;
    e_D = v_D - v_D_des;

    M_1 = (A+B);
    M_2 = (A-B);


    u_S = M_1*v_S_des_dot - k_S*e_S - sin(beta)*model_r/2*e_d + cos(beta)*model_r/2*e_d;
    u_D = M_2*v_D_des_dot - k_D*e_D + model_r/model_b*beta;
    u_R = (u_S+u_D)/2;
    u_L = (u_S-u_D)/2;

    u = [u_R;u_L] - dis - friction;

    x_dot = v*cos(theta);
    y_dot = v*sin(theta);
    theta_dot = omega;

    theta_ddot = M^(-1)*(u + dis + friction);

    
    %update for max values
    for ii=1:2
        u_max(ii) = max(u_max(ii),abs(u(ii)));
        vel_max(ii) = max(vel_max(ii),abs(vel_gen(ii)));
        q_max(ii) = max(q_max(ii),abs(state(ii)));
    end
    
       

    %normalize everything to (0,1) for neural network   
    u_norm = max(min(u,u_sat),-u_sat);
    q_dot_norm = max(min(vel_gen,vel_sat),-vel_sat);
    q_norm = max(min(state(1:2),q_sat),-q_sat);
    for ii=1:2
        u_norm(ii) = (u(ii) - (-u_sat(ii) ))/ (u_sat(ii)  - (-u_sat(ii) ));
        q_norm(ii) = (state(ii) - (-q_sat(ii) ))/ (q_sat(ii)  - (-q_sat(ii) ));
        q_dot_norm(ii) = (vel_gen(ii) - (-vel_sat(ii) ))/ (vel_sat(ii)  - (-vel_sat(ii) ));
    end
    theta_norm = (theta + 2*pi)/(4*pi);
    
    state_norm = [q_norm;theta_norm;q_dot_norm;];
    %time doesn't exceed 28    
    t_norm = t/28;

    dydt = [x_dot;y_dot;theta_dot;theta_ddot];
 
