clear
close all
clc

load('data.mat');

t_vector = linspace(0,28,2500);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50
        e_d_cur = e_d_cell{kk};
        beta_cur = beta_cell{kk};
        q_cur = q_cell{kk};        
        d_v_hat_cur = q_cur(:,6);
        d_omega_hat_cur = q_cur(:,7);
        d_1_hat_cur = q_cur(:,8);
        d_2_hat_cur = q_cur(:,9);
        e_v_cur = e_v_cell{kk};
        e_omega_cur = e_omega_cell{kk};
        t_cur = t_cell{kk};
        u_cur = u_cell{kk};
        u_NN_cur = u_NN_cell{kk};
        if time > t_cur(end)
            continue
        end
        [clos_val,clos_idx] = min(abs(t_cur - time));
        e_d_all(jj) = e_d_cur(clos_idx);
        beta_all(jj) = beta_cur(clos_idx);
        e_v_all(jj) = e_v_cur(clos_idx);
        e_omega_all(jj) = e_omega_cur(clos_idx);
        
        for qq=1:2
            u_all(jj,qq) = u_cur(clos_idx,qq);
            u_NN_all(jj,qq) = u_NN_cur(clos_idx,qq);            
        end
        d_1_hat_all(jj) = d_1_hat_cur(clos_idx);
        d_2_hat_all(jj) = d_2_hat_cur(clos_idx);
        d_v_hat_all(jj) = d_v_hat_cur(clos_idx);
        d_omega_hat_all(jj) = d_omega_hat_cur(clos_idx);
        jj = jj+1;        
    end   
    e_d_avg(idx) = mean(e_d_all);
    beta_avg(idx) = mean(beta_all);
    e_d_std(idx) = std(e_d_all);
    beta_std(idx) = std(beta_all);
    e_v_avg(idx) = mean(e_v_all);
    e_omega_avg(idx) = mean(e_omega_all);
    e_v_std(idx) = std(e_v_all);
    e_omega_std(idx) = std(e_omega_all);
    
    for qq=1:2        
        u_avg(idx,qq) = mean(u_all(:,qq));
        u_std(idx,qq) = std(u_all(:,qq));        
        u_NN_avg(idx,qq) = mean(u_NN_all(:,qq));
        u_NN_std(idx,qq) = std(u_NN_all(:,qq));
            
    end
    d_1_hat_avg(idx) = mean(d_1_hat_all);
    d_1_hat_std(idx) = std(d_1_hat_all);
    d_2_hat_avg(idx) = mean(d_2_hat_all); 
    d_2_hat_std(idx) = std(d_2_hat_all);
    d_v_hat_avg(idx) = mean(d_v_hat_all); 
    d_v_hat_std(idx) = std(d_v_hat_all);  
    d_omega_hat_avg(idx) = mean(d_omega_hat_all); 
    d_omega_hat_std(idx) = std(d_omega_hat_all);  
end
%this plots errors.
figure(1)
subplot(2,2,1)
plot(t_vector,e_d_avg,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(e_d(t)) \ [m]$','Interpreter','latex','fontsize',25)
xlim([0,20])

subplot(2,2,3)
plot(t_vector,beta_avg,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(\beta(t)) \ [rad]$','Interpreter','latex','fontsize',25)
xlim([0,20])



subplot(2,2,2)
plot(t_vector,e_d_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(e_d(t)) \ [m]$','Interpreter','latex','fontsize',25)
xlim([0,20])


subplot(2,2,4)
plot(t_vector,beta_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(\beta(t)) \ [rad]$','Interpreter','latex','fontsize',25)
xlim([0,20])

%this plots velocity errors.
figure(2)
subplot(2,2,1)
plot(t_vector,e_v_avg,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(e_v(t)) \ [m/s]$','Interpreter','latex','fontsize',25)
xlim([0,20])

subplot(2,2,2)
plot(t_vector,e_omega_avg,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
ylabel('mean$(e_\omega(t)) \ [rad/s]$','Interpreter','latex','fontsize',25)
xlim([0,20])


subplot(2,2,3)
plot(t_vector,e_v_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(e_v(t)) \ [m/s]$','Interpreter','latex','fontsize',25)
xlim([0,20])


subplot(2,2,4)
plot(t_vector, e_omega_std,'linewidth',2)
hold on
grid on
box on
ax = gca;
ax.FontSize = 15; 
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(e_\omega(t)) \ [rad/s]$','Interpreter','latex','fontsize',25)
xlim([0,20])


%this plots control input
figure(4)
subplot(2,2,1)
plot(t_vector,u_avg,'linewidth',2)
box on
grid on
ylabel('mean$(u(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_R$','$u_L$'},'Interpreter','latex','numcolumns',2,...
    'location','north','orientation','horizontal','fontsize',20)

axes('position',[.2 .7 .2 .1])
plot(t_vector,u_avg,'linewidth',2)
grid on
box on
xlim([0,20])
ylim([-10,10])


subplot(2,2,2)
plot(t_vector,u_std,'linewidth',2)
box on
grid on
ylabel('std$(u(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_R$','$u_L$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','north','orientation','horizontal','fontsize',20)

axes('position',[.65 .7 .2 .1])
plot(t_vector,u_std,'linewidth',2)
grid on
box on
xlim([0,20])
ylim([-10,10])

subplot(2,2,3)
plot(t_vector,u_NN_avg,'linewidth',2)
box on
grid on
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('mean$(u_{nn}(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_{nn,R}$','$u_{nn,L}$'},'Interpreter','latex','fontsize',20,'numcolumns',2,...
    'location','north','orientation','horizontal')
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)

axes('position',[.2 .2 .2 .1])
plot(t_vector,u_NN_avg,'linewidth',2)
grid on
box on
xlim([0,20])
ylim([-10,10])

subplot(2,2,4)
plot(t_vector,u_NN_std,'linewidth',2)
box on
grid on
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
ylabel('std$(u_{nn}(t)) \ [kgm^2]$','Interpreter','latex','fontsize',25)
xlim([0,20])
legend({'$u_{nn,R}$','$u_{nn,L}$'},'Interpreter','latex','fontsize',20,'numcolumns',2,...
    'location','north','orientation','horizontal')
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
axes('position',[.65 .2 .2 .1])
plot(t_vector,u_NN_std,'linewidth',2)
grid on
box on
xlim([0,20])
ylim([-10,10])
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);



%this plots adaptation signals
figure(5)
subplot(2,1,1)
plot(t_vector,d_v_hat_avg,'linewidth',2)
hold on
plot(t_vector,d_omega_hat_avg,'linewidth',2)
plot(t_vector,d_1_hat_avg,'linewidth',2)
plot(t_vector,d_2_hat_avg,'linewidth',2)
box on
grid on
xlim([0,20])
legend({'mean($\hat{\ell}_v(t))$','mean($\hat{\ell}_\omega(t))$','mean($\hat{\ell}_1(t))$','mean($\hat{\ell}_2(t))$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','northeast','orientation','horizontal','fontsize',20)
subplot(2,1,2)
plot(t_vector,d_v_hat_std,'linewidth',2)
hold on
plot(t_vector,d_omega_hat_std,'linewidth',2)
plot(t_vector,d_1_hat_std,'linewidth',2)
plot(t_vector,d_2_hat_std,'linewidth',2)
box on
grid on
xlim([0,20])
legend({'std($\hat{\ell}_v(t))$','std($\hat{\ell}_\omega(t))$','std($\hat{\ell}_1(t))$','std($\hat{\ell}_2(t))$'},'Interpreter','latex','fontsize',15,'numcolumns',2,...
    'location','northeast','orientation','horizontal','fontsize',20)
xlabel('$t \ [sec]$', 'Interpreter','latex','fontsize',25)
pos=get(gcf,'Position');
pos(3) = 890; pos(4) = 693;
set(gcf,'Position',pos);


load('data_nn_only.mat');
t_vector = linspace(0,28,2500);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50
        e_d_cur = e_d_cell{kk};
        beta_cur = beta_cell{kk};       
        e_v_cur = e_v_cell{kk};
        e_omega_cur = e_omega_cell{kk};
        t_cur = t_cell{kk};
        u_cur = u_cell{kk};
        if time > t_cur(end)
            continue
        end        
        
        [clos_val,clos_idx] = min(abs(t_cur - time));
        e_d_all(jj) = e_d_cur(clos_idx);
        beta_all(jj) = beta_cur(clos_idx);
        e_v_all(jj) = e_v_cur(clos_idx);
        e_omega_all(jj) = e_omega_cur(clos_idx);
        
        for qq=1:2
            u_all(jj,qq) = u_cur(clos_idx,qq);
        end      
        jj = jj+1;        
    end   
    e_d_avg(idx) = mean(e_d_all);
    beta_avg(idx) = mean(beta_all);
    e_d_std(idx) = std(e_d_all);
    beta_std(idx) = std(beta_all);
    e_v_avg(idx) = mean(e_v_all);
    e_omega_avg(idx) = mean(e_omega_all);
    e_v_std(idx) = std(e_v_all);
    e_omega_std(idx) = std(e_omega_all);
end
figure(1)
subplot(2,2,1)
plot(t_vector,e_d_avg,'linewidth',2)
subplot(2,2,3)
plot(t_vector,beta_avg,'linewidth',2)
subplot(2,2,2)
plot(t_vector,e_d_std,'linewidth',2)
subplot(2,2,4)
plot(t_vector,beta_std,'linewidth',2)

%this plots velocity errors.
figure(2)
subplot(2,2,1)
plot(t_vector,e_v_avg,'linewidth',2)
subplot(2,2,2)
plot(t_vector,e_omega_avg,'linewidth',2)
subplot(2,2,3)
plot(t_vector,e_v_std,'linewidth',2)
subplot(2,2,4)
plot(t_vector, e_omega_std,'linewidth',2)



load('data_no_nn.mat');
t_vector = linspace(0,28,2500);

for idx = 1:numel(t_vector)
    time = t_vector(idx);
    jj = 1;
    for kk=1:50
        e_d_cur = e_d_cell{kk};
        beta_cur = beta_cell{kk};       
        e_v_cur = e_v_cell{kk};
        e_omega_cur = e_omega_cell{kk};
        t_cur = t_cell{kk};
        u_cur = u_cell{kk};
        if time > t_cur(end)
            continue
        end        
        
        [clos_val,clos_idx] = min(abs(t_cur - time));
        e_d_all(jj) = e_d_cur(clos_idx);
        beta_all(jj) = beta_cur(clos_idx);
        e_v_all(jj) = e_v_cur(clos_idx);
        e_omega_all(jj) = e_omega_cur(clos_idx);
        
        for qq=1:2
            u_all(jj,qq) = u_cur(clos_idx,qq);
        end      
        jj = jj+1;        
    end   
    e_d_avg(idx) = mean(e_d_all);
    beta_avg(idx) = mean(beta_all);
    e_d_std(idx) = std(e_d_all);
    beta_std(idx) = std(beta_all);
    e_v_avg(idx) = mean(e_v_all);
    e_omega_avg(idx) = mean(e_omega_all);
    e_v_std(idx) = std(e_v_all);
    e_omega_std(idx) = std(e_omega_all);
    
    for qq=1:2        
        u_avg(idx,qq) = mean(u_all(:,qq));
        u_std(idx,qq) = std(u_all(:,qq));        
    end
end
%this plots errors.
figure(1)
subplot(2,2,1)
plot(t_vector,e_d_avg,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,3)
plot(t_vector,beta_avg,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,2)
plot(t_vector,e_d_std,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,4)
plot(t_vector,beta_std,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)


%this plots velocity errors.
figure(2)
subplot(2,2,1)
plot(t_vector,e_v_avg,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,2)
plot(t_vector,e_omega_avg,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,3)
plot(t_vector,e_v_std,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)
subplot(2,2,4)
plot(t_vector, e_omega_std,'linewidth',2)
legend({'Proposed','Non-adaptive','No-nn'},'Interpreter','latex','fontsize',15,'numcolumns',1,...
    'location','northeast','orientation','vertical','fontsize',20)