#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Apr 15 17:19:34 2021

"""


import torch
import numpy as np
from tqdm import tqdm
import time
import pickle 
import scipy.io


Num_traj = 100
Num_data_per_traj = 500

#shuffle the data

shuffled_data_list = []
print('Reading data...')
for ii in tqdm(range(Num_traj)):    
    cur_file = scipy.io.loadmat('training_data_python/traj_'+str(ii+1)+'.mat')
    training_data = cur_file["cur_train_data"]            

    for jj in range(Num_data_per_traj):
        cur_data = training_data[jj]        
        shuffled_data_list.append(cur_data)
    np.random.shuffle(shuffled_data_list)


np.random.shuffle(shuffled_data_list)
with open('shuffled_data.pkl', 'wb') as f: 
    pickle.dump(shuffled_data_list, f)