function test_no_nn

clear
clear global
clc
close all

load('trajectories.mat')
load('parameters.mat')

global cur_traj mass inertia_A inertia_0 model_r model_b model_d u_sat   
global  A_dis omega_dis phi_dis fric_param fric_mat  k_d_1 k_d_2 q_sat vel_sat
global k_d k_beta k_S k_D k_dv k_domega    
global e_v_global e_omega_global  sliding_var

k_d = .2; 
k_beta = 1;
k_S = 1;
k_D = 1;
k_d_1 = 10;
k_d_2 = 10;
k_dv = 1;
k_domega =1;


u_sat = [250;250];
vel_sat = [4;2];
q_sat = [8;8];


for kk = 1:50
    
    
    disp('new trajectory!');
    %take from test instances (>100)
    kk_idx = kk+200;
    
    
    e_v_global = 100;
    e_omega_global = 100;
    sliding_var = [0;0];
    e_d_total = [];
    beta_total = [];
    e_v_total = [];
    e_omega_total = [];
    u_total = [];
    q_des_total = [];
    q_des_dot_total = [];
    t_total = [];
    q_total = [];
    
    
    mass = mass_cell{kk_idx};
    inertia_A = inertia_A_cell{kk_idx};
    inertia_0 = inertia_0_cell{kk_idx};
    model_r = model_r_cell{kk_idx};
    model_b = model_b_cell{kk_idx};
    model_d = model_d_cell{kk_idx};    

    A_dis = A_dis_cell{kk_idx};
    omega_dis = omega_dis_cell{kk_idx};
    phi_dis = phi_dis_cell{kk_idx};  
    fric_param = fric_param_cell{kk_idx};
    fric_mat = fric_mat_cell{kk_idx};
    
    cur_traj = traj_vector{kk_idx};
    cur_t = time_vector{kk_idx};
    
    state_0 = state_0_cell{kk_idx};
    state_0_c = state_0;
    state_0_c(4:5) = [model_r/2*(state_0(4)+state_0(5)); model_r/model_b*(state_0(4)-state_0(5))];
    
    state_0 = [state_0_c;0.01;0.01;0.01;0.01];
    
    tstart = 0;
    tfinal = cur_t(end);
    
    size_data_points = 1000;
    tspan = linspace(tstart,tfinal,size_data_points);

    atol_ode = 1e-9;
    rtol_ode = 1e-9;
    tstart = tic;
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode, 'Events', @(t,y) EventFunction(t,y,tstart));
    refine= 4;
    
    for mm=1:3
        %the for loop is for evolution on sliding surfance e_v = 0, e_omega = 0
        %due to discontinuity in the controller
        [tout,qout] = ode23(@unicycle_as,tspan,state_0,options);

        e_d = zeros(numel(tout),1);
        beta = zeros(numel(tout),1);
        e_v = zeros(numel(tout),1);
        e_omega = zeros(numel(tout),1);    
        q_des = zeros(numel(tout),2);
        q_des_dot = zeros(numel(tout),2);
        u = zeros(numel(tout),2);
        u_NN = zeros(numel(tout),2);

        for ii = 1:numel(tout)
            [~,e_d(ii), beta(ii), e_v(ii), e_omega(ii), u(ii,:), q_des(ii,:), q_des_dot(ii,:)] = unicycle_as(tout(ii),qout(ii,:));
        end

        if sliding_var(1) == 0
            if e_v_global < 1e-4
                sliding_var(1) = 1;
                fprintf('e_d stop!')
            end            
        end
        if sliding_var(2) == 0
            if e_omega_global < 1e-4
                sliding_var(2) = 1;
                fprintf('beta stop!')
            end            
        end
                
        state_0 = qout(end,:)' ;
        tNow = tout(end); 
        tspan = linspace(tNow,tfinal,size_data_points);        
        % A good guess of a valid first timestep is the length ofs the last valid
        % timestep, so use it for faster computation.  'refine' is 4 by default.
        nt = length(tout);
        if nt > refine 
            options = odeset(options,'InitialStep',tout(nt)-tout(nt-refine),...
        'MaxStep',tout(nt)-tout(1));
        end   
        
        e_d_total = [e_d_total;e_d];
        beta_total = [beta_total;beta];
        e_v_total = [e_v_total;e_v];
        e_omega_total = [e_omega_total;e_omega];
        q_des_total = [q_des_total;q_des];
        q_des_dot_total = [q_des_dot_total;q_des_dot];
        u_total = [u_total;u];
        q_total = [q_total;qout];
        t_total = [t_total;tout];
  
        if tout(end) == tfinal && mm < 3
            break;
        end
            
    end
        
    figure()
    plot(t_total,e_d_total)
    hold on
    plot(t_total,beta_total)

    e_d_cell{kk} = e_d_total;
    beta_cell{kk} = beta_total;
    e_v_cell{kk} = e_v_total;    
    e_omega_cell{kk} = e_omega_total;
    u_cell{kk} = u_total;
    t_cell{kk} = t_total;
    q_cell{kk} = q_total;
    q_des_cell{kk} = q_des_total;
    q_des_dot_cell{kk} = q_des_dot_total;

end
save('data_no_nn.mat','e_d_cell','beta_cell','e_v_cell','e_omega_cell','u_cell','t_cell','q_cell','q_des_cell','q_des_dot_cell')


function [dydt e_d, beta, e_v, e_omega, u, q_des, q_des_dot]= unicycle_as(t,state)
    t
    global mass inertia_A inertia_0 model_r model_b model_d cur_traj    
	global A_dis omega_dis phi_dis fric_param fric_mat k_d_1 k_d_2 
    global e_v_global e_omega_global sliding_var
    global k_d k_beta k_S k_D k_dv k_domega  

    if size(state,1)==1
        state = state';
    end
    
    x = state(1);
	y = state(2);
	theta  = state(3); 
    v = state(4);
    omega = state(5);
    d_v_hat = state(6);
    d_omega_hat = state(7);
    d_1_hat = state(8);
    d_2_hat = state(9);    
    
    theta_R_dot = (2*v + model_b*omega)/(2*model_r);
    theta_L_dot = (2*v - model_b*omega)/(2*model_r);
    
    A = mass*model_r^2/4 + (inertia_A + mass*model_d^2)*model_r^2/model_b^2 + inertia_0;
	B = mass*model_r^2/4 - (inertia_A + mass*model_d^2)*model_r^2/model_b^2;
	M = [A B;B A];

    A = mass*model_r^2/4 + (inertia_A + mass*model_d^2)*model_r^2/model_b^2 + inertia_0;
    B = mass*model_r^2/4 - (inertia_A + mass*model_d^2)*model_r^2/model_b^2;
    M = [A B;B A];
    vel_gen = [v;omega];
    dis = diag(A_dis)*[sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2))];       
  
    new_term = [v^2;omega^2;v*omega;];
    friction = fric_mat*new_term;

    for ii=1:2
		traj_q = cur_traj{ii};
		q_des(ii) = traj_q(t);
		[q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
   	end 
   	x_des = q_des(1);
   	y_des = q_des(2);
   	x_des_dot = q_des_dot(1);
   	y_des_dot = q_des_dot(2);
   	x_des_ddot = q_des_ddot(1);
   	y_des_ddot = q_des_ddot(2);  	
    
    e_x = x-x_des;
    e_y = y-y_des;
	e_d = norm([e_x;e_y]);
    
	sin_beta = e_x/e_d*sin(theta) - e_y/e_d*cos(theta);
	beta = asin(sin_beta);
    

	e_d_dot = -v*cos(beta) + x_des_dot*cos(beta + theta) + y_des_dot*sin(beta+theta);
    beta_dot = -omega + v/e_d*sin(beta) + y_des_dot/e_d*cos(beta+theta) - x_des_dot/e_d*sin(beta+theta);
       
    G = [-cos(beta), 0; sin(beta)/e_d, -1];
    G_dot = [sin(beta)*beta_dot, 0; (cos(beta)*beta_dot*e_d-sin(beta)*e_d_dot)/e_d^2, 0];    
    G_inv = G^(-1);
    G_inv_dot = -G_inv*G_dot*G_inv;
    
    vec_tmp = [-x_des_dot*cos(beta+theta) - y_des_dot*sin(beta+theta) - k_d*e_d;
              - y_des_dot/e_d*cos(beta+theta) + x_des_dot/e_d*sin(beta+theta) - k_beta*beta];
         
    vec_tmp_dot = [
        -x_des_ddot*cos(beta+theta)+x_des_dot*sin(beta+theta)*(beta_dot+omega) - y_des_ddot*sin(beta+theta) - y_des_dot*cos(beta+theta)*(beta_dot + omega) - k_d*e_d_dot;
        ((x_des_ddot*sin(beta+theta) + x_des_dot*cos(beta+theta)*(beta_dot+omega))*e_d - x_des_dot*sin(beta+theta)*e_d_dot)/e_d^2 ...
        - ((y_des_ddot*cos(beta+theta) - y_des_dot*sin(beta+theta)*(beta_dot+omega))*e_d - y_des_dot*cos(beta+theta)*e_d_dot)/e_d^2-k_beta*beta_dot
        ];
    v_gen_des = G_inv*vec_tmp;
    v_gen_des_dot = G_inv*vec_tmp_dot + G_inv_dot*vec_tmp;   
        
    v_des = v_gen_des(1);
    omega_des = v_gen_des(2);
    v_des_dot = v_gen_des_dot(1);
    omega_des_dot = v_gen_des_dot(2);       
    
    e_v = v - v_des;
    e_omega = omega - omega_des;
   
    
    e_v_global = abs(e_v);
    e_omega_global = abs(e_omega);
    
     
    e_v_hat = 0;
    if norm(e_v) >=  10^(-8)
       e_v_hat = e_v/norm(e_v);
    end    
    e_omega_hat = 0;
    if norm(e_omega) >=  10^(-8)
       e_omega_hat = e_omega/norm(e_omega);
    end    
    
    u_S = d_v_hat*v_des_dot - (k_S + d_1_hat)*e_v - d_2_hat*e_v_hat + e_d*cos(beta) - beta*sin(beta)/e_d;
    u_D = d_omega_hat*omega_des_dot - (k_D + d_2_hat)*e_omega - d_2_hat*e_omega_hat + beta;
    
    u_R = (u_S + u_D)/2;
    u_L = (u_S - u_D)/2;
    u = [u_R;u_L];       
       
       
    e_d
    beta
    e_v_norm = norm(e_v)
    e_omega_norm  = norm(e_omega)

    x_dot = v*cos(theta);
    y_dot = v*sin(theta);
    theta_dot = omega;
    theta_ddot = M^(-1)*(u + dis + friction);  
    
    theta_ddot_sum = theta_ddot(1) + theta_ddot(2);
    theta_ddot_diff = theta_ddot(1) - theta_ddot(2);
    
    v_dot = model_r/2*theta_ddot_sum;
    omega_dot = model_r/model_b*theta_ddot_diff;
    
    d_v_hat_dot = - k_dv*e_v*v_des_dot;
    d_omega_hat_dot = - k_domega*e_omega*omega_des_dot;
    d_1_hat_dot = k_d_1*(e_v^2 + e_omega^2);   
    d_2_hat_dot = k_d_2*(abs(e_v) + abs(e_omega));
    
    %sliding variables define the sliding surfaces from the discontinuity
    if sliding_var(1) == 1 %e_d=0
        v_dot = v_des_dot;
    end
    if sliding_var(2) == 1  %beta = 0
        omega_dot = omega_des_dot;
    end
  
     dydt = [x_dot;y_dot;theta_dot;v_dot;omega_dot;d_v_hat_dot;d_omega_hat_dot;d_1_hat_dot;d_2_hat_dot];
    

function [value,isterminal,direction] = EventFunction(t,state,tstart)
    
    global k_d k_beta cur_traj
    global beta_global e_d_global sliding_var
    
    x = state(1);
	y = state(2);
	theta  = state(3); 
    v = state(4);
    omega = state(5);
    d_v_hat = state(6);
    d_omega_hat = state(7);
    d_1_hat = state(8);
    d_2_hat = state(9);    
    
    for ii=1:2
		traj_q = cur_traj{ii};
		q_des(ii) = traj_q(t);
		[q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
   	end 
   	x_des = q_des(1);
   	y_des = q_des(2);
   	x_des_dot = q_des_dot(1);
   	y_des_dot = q_des_dot(2);
   	x_des_ddot = q_des_ddot(1);
   	y_des_ddot = q_des_ddot(2);  	
    
    e_x = x-x_des;
    e_y = y-y_des;
	e_d = norm([e_x;e_y]);
    e_d_global = e_d;
	sin_beta = e_x/e_d*sin(theta) - e_y/e_d*cos(theta);
	beta = asin(sin_beta);
    beta_global = beta;
    
    G = [-cos(beta), 0; sin(beta)/e_d, -1];
    G_inv = G^(-1);    
    vec_tmp = [-x_des_dot*cos(beta+theta) - y_des_dot*sin(beta+theta) - k_d*e_d;
              - y_des_dot/e_d*cos(beta+theta) + x_des_dot/e_d*sin(beta+theta) - k_beta*beta];            
          
    v_gen_des = G_inv*vec_tmp;
        
    v_des = v_gen_des(1);
    omega_des = v_gen_des(2);

    
    e_v = v - v_des;
    e_omega = omega - omega_des;
   
    value = [-10;-10;toc(tstart) - 60*10];
    if sliding_var(1) == 0
        value(1)= norm(e_v) - 10^(-5);
    end
    if sliding_var(2) == 0
        value(2) = norm(e_omega) - 10^(-5);
    end
    
    isterminal = true*[1;1;1];    
    direction = [0;0;0];    
    
