function test_only_nn

clear
clear global
clc
close all

load('trajectories.mat')
load('parameters.mat')

global cur_traj mass inertia_A inertia_0 model_r model_b model_d u_sat 
global  A_dis omega_dis phi_dis fric_param fric_mat  neural_net q_sat vel_sat
global k_d k_beta k_S k_D k_d_1 k_d_2 k_dv k_domega 

k_d = .25; 
k_beta = 1;
k_S = 10;
k_D = 10;
k_d_1 = 10;
k_d_2 = 10;
k_dv = 1;
k_domega =1;

neural_net = importONNXNetwork('NeuralNetworkUnicycle.onnx','OutputLayerType','regression');

u_sat = [250;250];
vel_sat = [4;2];
q_sat = [8;8];


for kk = 1:50
    
    disp('new trajectory!');  
    %choose from test instances (>100)
    kk_idx = kk+200;
    
    mass = mass_cell{kk_idx};
    inertia_A = inertia_A_cell{kk_idx};
    inertia_0 = inertia_0_cell{kk_idx};
    model_r = model_r_cell{kk_idx};
    model_b = model_b_cell{kk_idx};
    model_d = model_d_cell{kk_idx};    

    A_dis = A_dis_cell{kk_idx};
    omega_dis = omega_dis_cell{kk_idx};
    phi_dis = phi_dis_cell{kk_idx};  
    fric_param = fric_param_cell{kk_idx};
    fric_mat = fric_mat_cell{kk_idx};
    
    cur_traj = traj_vector{kk_idx};
    cur_t = time_vector{kk_idx};
    
    state_0 = state_0_cell{kk_idx};
    state_0_c = state_0;
    state_0_c(4:5) = [model_r/2*(state_0(4)+state_0(5)); model_r/model_b*(state_0(4)-state_0(5))];
    
    state_0 = [state_0_c];
    
    tstart = 0;
    tfinal = cur_t(end);
    
    size_data_points = 5000;
    tspan = linspace(tstart,tfinal,size_data_points);

    atol_ode = 1e-9;
    rtol_ode = 1e-9;
    options = odeset('AbsTol', atol_ode, 'RelTol', rtol_ode);    
    [tout,qout] = ode45(@unicycle_as,tspan,state_0,options);

    e_d = zeros(numel(tout),1);
    beta = zeros(numel(tout),1);
    e_v = zeros(numel(tout),1);
    e_omega = zeros(numel(tout),1);    
    q_des = zeros(numel(tout),2);
    q_des_dot = zeros(numel(tout),2);
    u = zeros(numel(tout),2);
    u_NN = zeros(numel(tout),2);

    for ii = 1:numel(tout)
        [~,e_d(ii), beta(ii), e_v(ii), e_omega(ii), u(ii,:), u_NN(ii,:), q_des(ii,:), q_des_dot(ii,:)] = unicycle_as(tout(ii),qout(ii,:));
    end
    
  
%     figure()
%     plot(tout,e_d)
%     hold on
%     plot(tout,beta)

    e_d_cell{kk} = e_d;
    beta_cell{kk} = beta;
    e_v_cell{kk} = e_v;    
    e_omega_cell{kk} = e_omega;
    u_NN_cell{kk} = u_NN;
    u_cell{kk} = u;
    t_cell{kk} = tout;
    q_des_cell{kk} = q_des;
    q_des_dot_cell{kk} = q_des_dot;

end
save('data_nn_only.mat','e_d_cell','beta_cell','e_v_cell','e_omega_cell','u_cell','u_NN_cell','t_cell','q_des_cell','q_des_dot_cell')

function [dydt e_d, beta, e_v, e_omega, u, u_NN, q_des, q_des_dot]= unicycle_as(t,state)
t
    global mass inertia_A inertia_0 model_r model_b model_d cur_traj u_sat vel_sat q_sat 
	global A_dis omega_dis phi_dis fric_param fric_mat neural_net 
    global k_d k_beta k_S k_D  

    if size(state,1)==1
        state = state';
    end
    
    x = state(1);
	y = state(2);
	theta  = state(3); 
    v = state(4);
    omega = state(5);

   
    A = mass*model_r^2/4 + (inertia_A + mass*model_d^2)*model_r^2/model_b^2 + inertia_0;
	B = mass*model_r^2/4 - (inertia_A + mass*model_d^2)*model_r^2/model_b^2;
	M = [A B;B A];
	
    vel_gen = [v;omega];
    dis = diag(A_dis)*[sin(omega_dis(1)*t+phi_dis(1));sin(omega_dis(2)*t+phi_dis(2))];       
  
    new_term = [v^2;omega^2;v*omega;];
    friction = fric_mat*new_term;

    for ii=1:2
		traj_q = cur_traj{ii};
		q_des(ii) = traj_q(t);
		[q_des_dot(ii),q_des_ddot(ii)] = differentiate(traj_q,t);        
   	end 
   	x_des = q_des(1);
   	y_des = q_des(2);
   	x_des_dot = q_des_dot(1);
   	y_des_dot = q_des_dot(2);
   	x_des_ddot = q_des_ddot(1);
   	y_des_ddot = q_des_ddot(2);  	
    
    e_x = x-x_des;
    e_y = y-y_des;
	e_d = norm([e_x;e_y]);
	sin_beta = e_x/e_d*sin(theta) - e_y/e_d*cos(theta);
	beta = asin(sin_beta);

	e_d_dot = -v*cos(beta) + x_des_dot*cos(beta + theta) + y_des_dot*sin(beta+theta);
    beta_dot = -omega + v/e_d*sin(beta) + y_des_dot/e_d*cos(beta+theta) - x_des_dot/e_d*sin(beta+theta);
       
    G = [-cos(beta), 0; sin(beta)/e_d, -1];
    G_dot = [sin(beta)*beta_dot, 0; (cos(beta)*beta_dot*e_d-sin(beta)*e_d_dot)/e_d^2, 0];    
    G_inv = G^(-1);
    G_inv_dot = -G_inv*G_dot*G_inv;
    
    vec_tmp = [-x_des_dot*cos(beta+theta) - y_des_dot*sin(beta+theta) - k_d*e_d;
              - y_des_dot/e_d*cos(beta+theta) + x_des_dot/e_d*sin(beta+theta) - k_beta*beta];
         
    vec_tmp_dot = [
        -x_des_ddot*cos(beta+theta)+x_des_dot*sin(beta+theta)*(beta_dot+omega) - y_des_ddot*sin(beta+theta) - y_des_dot*cos(beta+theta)*(beta_dot + omega) - k_d*e_d_dot;
        ((x_des_ddot*sin(beta+theta) + x_des_dot*cos(beta+theta)*(beta_dot+omega))*e_d - x_des_dot*sin(beta+theta)*e_d_dot)/e_d^2 ...
        - ((y_des_ddot*cos(beta+theta) - y_des_dot*sin(beta+theta)*(beta_dot+omega))*e_d - y_des_dot*cos(beta+theta)*e_d_dot)/e_d^2-k_beta*beta_dot
        ];
    v_gen_des = G_inv*vec_tmp;
    v_gen_des_dot = G_inv*vec_tmp_dot + G_inv_dot*vec_tmp;   
        
    v_des = v_gen_des(1);
    omega_des = v_gen_des(2);
    v_des_dot = v_gen_des_dot(1);
    omega_des_dot = v_gen_des_dot(2);       
    
    e_v = v - v_des;
    e_omega = omega - omega_des;   
    
    for ii=1:2        
        q_norm(ii) = (state(ii) - (-q_sat(ii) ))/ (q_sat(ii)  - (-q_sat(ii) ));
        q_dot_norm(ii) = (vel_gen(ii) - (-vel_sat(ii) ))/ (vel_sat(ii)  - (-vel_sat(ii) ));
    end
    theta_norm = (theta + 2*pi)/(4*pi);
    
    state_norm = [q_norm';theta_norm;q_dot_norm'];
    %time doesn't exceed 28    
    t_norm = t/28;
    nn_input = [state_norm];
    tau_NN =  predict(neural_net,nn_input);
    for ii=1:2
        u_NN(ii) = tau_NN(ii)*(u_sat(ii) - (-u_sat(ii))) + (-u_sat(ii));
    end
    u_NN = u_NN';
    
    e_v_hat = 0;
    if norm(e_v) >=  10^(-8)
       e_v_hat = e_v/norm(e_v);
    end    
    e_omega_hat = 0;
    if norm(e_omega) >=  10^(-8)
       e_omega_hat = e_omega/norm(e_omega);
    end    
    
    %variations in the inertia matrix to be used in the control
    
    A_es = (mass*0.25)*(model_r*0.25)^2/4 + (inertia_A*0.25 + mass*0.25*(model_d*0.25)^2)*(model_r*0.25)^2/(model_b*0.25)^2 + inertia_0*.25;
	B_es = (mass*0.25)*(model_r*0.25)^2/4 - (inertia_A*0.25 + mass*0.25*(model_d*0.25)^2)*(model_r*0.25)^2/(model_b*0.25)^2;
	M_es = [A_es B_es;B_es A_es];
    
    M_1es = (A_es+B_es)/(model_r*0.25);
    M_2es = model_b*0.25/2*(A_es-B_es)/(model_r*0.25);
    
    u_S = M_1es*v_des_dot - k_S*e_v + e_d*cos(beta) - beta*sin(beta)/e_d;
    u_D = M_2es*omega_des_dot - k_D*e_omega  + beta;
    
    u_R = (u_S + u_D)/2;
    u_L = (u_S - u_D)/2;
    u = [u_R;u_L] + u_NN;            
       
    e_d
    beta
    
    x_dot = v*cos(theta);
    y_dot = v*sin(theta);
    theta_dot = omega;
    theta_ddot = M^(-1)*(u + dis + friction);    
    
    theta_ddot_sum = theta_ddot(1) + theta_ddot(2);
    theta_ddot_diff = theta_ddot(1) - theta_ddot(2);
    
    v_dot = model_r/2*theta_ddot_sum;
    omega_dot = model_r/model_b*theta_ddot_diff;
        
    

    dydt = [x_dot;y_dot;theta_dot;v_dot;omega_dot];
    
