# Universal Mini-Batch Consistency for Set Encoding Functions

This is a code repository and demo of the paper "Universal Mini-Batch Consistency for Set Encoding Functions."

## Run MBC Tests

```make test```

## Downloading Datasets

### ModelNet40-2048 and ModelNet40-2048-C

ModelNet40-2048 and ModelNet40-2048-C can be downloaded from the following links which were acquired from the original
work which proposed the ModelNet40-C dataset
[Benchmarking and Analyzing Point Cloud Classification under Corruptions](https://github.com/jiawei-ren/ModelNet-C)

[ModelNet 2048](https://shapenet.cs.stanford.edu/media/modelnet40_ply_hdf5_2048.zip)

[ModelNet40-2048-C](https://zenodo.org/record/6017834#.Yoxry3VBzzM)

### ImageNet1k

ImageNet data can be acquired from [image-net.org](https://image-net.org/download.php)

## Training Models

```
cd [mvn,imgnet,modelnet]
PYTHONPATH=/path/to/umbc python runner.py
```

## Original Baseline Model Code

The base models we consider are all built from one of: [Deep Sets](https://github.com/manzilzaheer/DeepSets),
[Set Transformer](https://github.com/juho-lee/set_transformer), or
[Diff. EM (supplementary material)](https://openreview.net/forum?id=MXdFBmHT4C). Our code builds on the original
published code at the respective links.
