# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['femio',
 'femio.__main__',
 'femio.formats',
 'femio.formats.ansys',
 'femio.formats.fistr',
 'femio.formats.obj',
 'femio.formats.stl',
 'femio.formats.timon',
 'femio.formats.ucd',
 'femio.util']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.1,<4.0',
 'meshio>=3.3,<4.0',
 'networkx>=2.4,<3.0',
 'numpy-stl>=2.10,<3.0',
 'numpy>=1.17,<2.0',
 'pandas>=1.0,<2.0',
 'scikit-learn>=0.22.0,<0.23.0',
 'scipy>=1.4,<2.0']

extras_require = \
{'PyQt5': ['PyQt5>=5.14.0,<6.0.0']}

entry_points = \
{'console_scripts': ['ansys2inp = femio.__main__.ansys2inp:main',
                     'compare_disp = femio.__main__.compare_disp:main',
                     'convert_fistr2stl = '
                     'femio.__main__.convert_fistr2stl:main',
                     'convert_fistr_order1 = '
                     'femio.__main__.convert_fistr_order1:main',
                     'femconvert = femio.__main__.femconvert:main',
                     'fistr2fistr = femio.__main__.fistr2fistr:main',
                     'fistr2ucd = femio.__main__.fistr2ucd:main',
                     'surface_extraction = '
                     'femio.__main__.surface_extraction:main',
                     'timon2ucd = femio.__main__.timon2ucd:main',
                     'ucd2ucd = femio.__main__.ucd2ucd:main']}

setup_kwargs = {
    'name': 'femio',
    'version': '0.2.1',
    'description': 'FEM I/O Tool',
    'long_description': None,
    'author': None,
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
