//------------------------------------------------------------------------------
// Copyright (c) 2020 FrontISTR Commons
// This software is released under the MIT License, see LICENSE.txt
//------------------------------------------------------------------------------
//> This module provides linear equation solver interface for monolish

#include <iostream>
#ifdef HECMW_WITH_MONOLISH
#include <monolish_equation.hpp>
#endif // HECMW_WITH_MONOLISH

extern "C"
{
  int monolish_sparse_solver(const int N, const int NNZ, const int * const row, const int * const col, const double * const val, double * const xp, const double * const bp, const double tol, const int maxiter) {

#ifdef HECMW_WITH_MONOLISH
    monolish::matrix::COO<double> COO(N, NNZ, row, col, val, 1);
    monolish::matrix::CRS<double> A(COO);

    // Logger setting
    // monolish::util::set_log_level(3);
    // monolish::util::set_log_filename("./monolish.log");

    // CG
    // monolish::equation::CG solver;
    // solver.set_print_rhistory(true);
    // solver.set_tol(tol);
    // solver.set_maxiter(maxiter);

    // Cholesky
    monolish::equation::Cholesky<double> solver;
    //solver.set_reorder(3); // monolish default; METIS_NodeND

    monolish::vector<double> x(xp, xp+N);
    monolish::vector<double> b(bp, bp+N);

    monolish::util::send(A, x, b);
    solver.solve(A, x, b);
    x.recv();
    for (int i = 0; i < N; i++) {
      xp[i] = x[i];
    }

#endif // HECMW_WITH_MONOLISH
    return 0;
  }
}
