# IsoGCN
Implementation of "Isometric Transformation Invariant and Equivariant Graph Convolutional Networks."


# Preparation
If some of the following steps not working, please modify `User settings` section in the `Makefile` to fit with your environment.

## Docker image
Please download the docker image via https://drive.google.com/file/d/1WDbdGdzlgo_vuaqo6Cj4kNju38HQyWCT/view?usp=sharing , then place the image in the `images` directory.

## Dataset (anisotropic nonlinear heat dataset)
Please download the preprocessed dataset via:
- Train dataset (splitted due to its large data size):
  - https://drive.google.com/file/d/1yBKWMTYjdbOEWLf-MAvcIKeuyY9riPtB/view?usp=sharing (5.0 GB)
  - https://drive.google.com/file/d/1p8TJkhSkGE02Yve8Ub35f8irKzB7TPrZ/view?usp=sharing (5.0 GB)
  - https://drive.google.com/file/d/1lYt02gGAxAoclIGE_SGf6EnspOF_5-fu/view?usp=sharing (5.0 GB)
  - https://drive.google.com/file/d/1VQaUagwpbbsY4qT_QUHM3Uv03k-GZ8lY/view?usp=sharing (5.0 GB)
  - https://drive.google.com/file/d/1vUFGrWsu0X7R8WK3n_7btn92WJbgxoRa/view?usp=sharing (5.0 GB)
- Validation dataset:
  - https://drive.google.com/file/d/1yhOQ8x3O02xU18ZtS74uRIfOybjvzs0J/view?usp=sharing (6.6 GB)
- Test dataset:
  - https://drive.google.com/file/d/1F7kPoUqxGmlkg9ROW65AQTrTgp8vGupr/view?usp=sharing (8.4 GB)

After download finished, please merge the training dataset archive with:
```
cat train_50.tar.gz.parta* > train.tar.gz
```
, extract them with `tar xvf *.tar.gz`, then place them in the `data/heat_nl_tensor/preprocessed` directory.

## Local install (opional)
We are using poetry, thus first install it following the instruction on https://python-poetry.org/docs/ ,
and please set PYTHON variable in the Makefile accordingly, e.g. `PYTHON = "poetry run python3"`

For GPU environment,
```
make install_pyg_gpu
make requirements
```

For CPU environment,
```
make install_pyg_gpu
make requirements
```
, and set `GPU_ID = -1` in the `Makefile`.


# Differential operator dataset
Plsease `make in` to login the docker befor perfroming all the following processes.

## Data generation
```
make differential_data
```

## Training IsoGCN
```
make scalar2grad  # Scalar to gradient task
make scalar2grad  ADJ=5  # Scalar to gradient task with # hops = 5
make scalar2hessian  # Scalar to Hessian task
make grad2laplacian  # Gradient to Laplacian task
make grad2hessian  # Gradient to Hessian task
```

## Training baseline models
```
make scalar2grad_baseline BASELINE_NAME=gcn  # BASELINE_NAME=[cluster_gcn, gcn, gcnii, gin, sgcn]

```
Similarly, one can perform baseline model trainings for other tasks.


# Anisotropic nonlinear heat equation dataset
## Run whole process with small data to check the process
```
make small_heat_nl_tensor_pipeline
```

## Training IsoGCN
```
make heat_nl_tensor
```

## Training baseline models
```
make heat_nl_tensor_baseline BASELINE_NAME=gcn  # BASELINE_NAME=[cluster_gcn, gcn, gcnii, gin, sgcn]
```

# Implimentation code
The core implementation of the IsoGCN layer can be found in: lib/siml/siml/networks/iso_gcn.py
