# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['siml', 'siml.__main__', 'siml.networks', 'siml.networks.geo']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.2,<6.0',
 'einops>=0.2,<0.3',
 'femio>=0.2.0',
 'joblib>=0.14.1,<0.15.0',
 'llvmlite>=0.34.0,<0.35.0',
 'matplotlib>=3.1,<4.0',
 'networkx>=2.4,<3.0',
 'numpy-stl>=2.10,<3.0',
 'numpy>=1.17,<2.0',
 'optuna>=1.3,<2.0',
 'pandas>=1.0,<2.0',
 'pydot>=1.4.1,<2.0.0',
 'pytorch-ignite>=0.3,<0.4',
 'scikit-learn>=0.22.0,<0.23.0',
 'scipy>=1.4,<2.0',
 'sqlalchemy==1.3.13',
 'torch-cluster>=1.5.7,<2.0.0',
 'torch-geometric>=1.6.1',
 'torch-scatter>=2.0.5,<3.0.0',
 'torch-sparse>=0.6.7,<0.7.0',
 'torch-spline-conv>=1.2.0,<2.0.0',
 'torch>=1.3.1,<2.0.0']

extras_require = \
{'PyQt5': ['PyQt5>=5.14.0,<6.0.0']}

entry_points = \
{'console_scripts': ['convert_interim_data = '
                     'siml.__main__.convert_interim_data:main',
                     'optimize = siml.__main__.optimize:main',
                     'plot_losses = siml.__main__.plot_losses:main',
                     'prepare_preprocess_converters = '
                     'siml.__main__.prepare_preprocess_converters:main',
                     'preprocess_interim_data = '
                     'siml.__main__.preprocess_interim_data:main',
                     'train = siml.__main__.train:main',
                     'visualize_graph = siml.__main__.visualize_graph:main']}

setup_kwargs = {
    'name': 'siml',
    'version': '0.2.4',
    'description': 'SiML - a Simulation ML library',
    'long_description': None,
    'author': None,
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
