###############################################################################
# Copyright (c) 2020 FrontISTR Commons
# This software is released under the MIT License, see License.txt
###############################################################################

# Variables:
#
# MONOLISH_FOUND         TRUE if monolish solver is found
# MONOLISH_INCLUDE_PATH  Include path of monolish
# MONOLISH_GPU_LIBRARY   monolish GPU libraries
# MONOLISH_CPU_LIBRARY   monolish CPU libraries
#
# env MONOLISH_ROOT      Set MONOLISH_ROOT environment variable,
#                        where monolish are.
#    ex. export MONOLISH_ROOT=/home/someone/somewhere/monolish
#

if($ENV{MONOLISH_ROOT})
  set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} $ENV{MONOLISH_ROOT}/lib)
endif($ENV{MONOLISH_ROOT})

set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} ${CMAKE_SOURCE_DIR}/../monolish/lib)
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} /opt/ricos/monolish/0.1/lib)
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} $ENV{HOME}/local/lib)
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} $ENV{HOME}/.local/lib)
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} ${CMAKE_LIBRARY_PATH})
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} /usr/local/lib)
set(LIB_SEARCH_PATH ${LIB_SEARCH_PATH} /usr/lib)

find_library(MONOLISH_GPU_LIB
  NAMES monolish_gpu
  HINTS ${LIB_SEARCH_PATH}
  )
if (MONOLISH_GPU_LIB)
  set(MONOLISH_GPU_LIBRARY ${MONOLISH_GPU_LIB})
  set(MONOLISH_GPU_FOUND ON)
endif(MONOLISH_GPU_LIB)


find_library(MONOLISH_CPU_LIB
  NAMES monolish_cpu
  HINTS ${LIB_SEARCH_PATH}
  )
if (MONOLISH_CPU_LIB)
  set(MONOLISH_CPU_LIBRARY ${MONOLISH_CPU_LIB})
  set(MONOLISH_CPU_FOUND ON)
endif(MONOLISH_CPU_LIB)

find_path(MONOLISH_INCLUDE_PATH
  NAMES monolish_equation.hpp
  HINTS $ENV{MONOLISH_ROOT}/include
  ${CMAKE_SOURCE_DIR}/../monolish/include
  /opt/ricos/monolish/0.1/include
  $ENV{HOME}/local/include
  $ENV{HOME}/.local/include
  ${CMAKE_INCLUDE_PATH}
  /usr/local/include
  /usr/include
  )

mark_as_advanced(MONOLISH_INCLUDE_PATH MONOLISH_GPU_LIBRARY MONOLISH_CPU_LIBRARY MONOLISH_GPU_LIB MONOLISH_CPU_LIB)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MONOLISH
  DEFAULT_MSG
    MONOLISH_CPU_LIBRARY
    MONOLISH_GPU_LIBRARY
    MONOLISH_INCLUDE_PATH
)
