###############################################################################
# Copyright (c) 2019 FrontISTR Commons
# This software is released under the MIT License, see License.txt
###############################################################################

#
# Variables:
#
# SCALAPACK_FOUND      TRUE if FindScalapack found scalapack
# SCALAPACK_MKL        TRUE if FindScalapack found Intel MKL scalapack
# SCALAPACK_LIBRARIES  scalapack libraries
#
# env SCALAPACK_ROOT   Set SCALAPACK_ROOT environment variable,
#                      where scalapack are.
#    ex. export SCALAPACK_ROOT=/home/someone/somewhere/scalapack-2.0.2
#
if(SCALAPACK_LIBRARIES)
  set(SCALAPACK_FOUND TRUE)
  RETURN()
endif()

if(MKL_SCALAPACK_INCLUDE_PATH AND MKL_SCALAPACK_LP64)
  set(SCALAPACK_MKL TRUE)
  set(SCALAPACK_LIBRARIES ${MKL_LIBRARIES})
else()
  set(SCALAPACK_MKL FALSE)
  find_library(SCALAPACK_LIBRARIES
    NAMES
      scalapack
      scalapack-openmpi
    HINTS
      $ENV{SCALAPACK_ROOT}/build/lib
      ${CMAKE_SOURCE_DIR}/../scalapack-2.0.2/build/lib
      $ENV{HOME}/scalapack-2.0.2/build/lib
      $ENV{HOME}/local/lib
      $ENV{HOME}/.local/lib
      ${CMAKE_LIBRARY_PATH}
      /usr/local/scalapack/lib
      /usr/local/lib
      /usr/lib
      /usr/lib/x86_64-linux-gnu
  )
endif()

if(SCALAPACK_LIBRARIES)
  set(SCALAPACK_FOUND TRUE)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
  Scalapack
  DEFAULT_MSG
    SCALAPACK_LIBRARIES
)
