#!/bin/bash

# SBATCH parameters here

conda activate radt

### Evaluate on FetchReachObstacle

python3 train.py \
        --evaluation \
        --exp-name eval-radt-fetch \
        --instance_prefix exp1 \
        --env reach_obstacle \
        --dataset_path 'INSERT/TRAINING/DATA/RELATIVE/PATH/HERE' \
        --load-path "INSERT/MODEL/PATH/HERE" \
        --n_head 4 \
        --n_layer 4 \
        --embed_dim 256 \
        --n_positions 1024 \
        --K 50 \
        --max_ep_len 50 \
        --avoid_prompt \
        --max_avoid_prompt_len 10 \
        --adelta 2 \
        --alpha1 1.0 \
        --num_eval_episodes 60 \
        --n_test_env 1 \
        --device 'cpu' \
        --bsa_box_size 0.08 \

### Evaluate on PointMazeObstacle
python3 train.py \
        --evaluation \
        --exp-name eval-radt-mazeobstacle \
        --instance_prefix exp1 \
        --env pointmaze_obstacle \
        --dataset_path 'INSERT/TRAINING/DATA/RELATIVE/PATH/HERE' \
        --load-path "INSERT/MODEL/PATH/HERE" \
        --n_head 6 \
        --n_layer 6 \
        --embed_dim 384 \
        --n_positions 2048 \
        --K 300 \
        --max_ep_len 300 \
        --avoid_prompt \
        --max_avoid_prompt_len 10 \
        --adelta 1 \
        --alpha1 1.0 \
        --buffer_size 0.2 \
        --num_eval_episodes 200 \
        --n_test_env 1 \
        --device 'cuda' \
        --maze "U_MAZE" \
        --num_avoid 3