﻿#ifndef RENDER_DEFS_H
#define RENDER_DEFS_H

/* ---------------------------------------- */
// render parameters

// 1 for single sample, 2 for 2x2 supersampling, etc.
#define AA 1
// #define AA 2
// #define AA 3

/* ---------------------------------------- */
// CTSS parameters

// #define NO_CTSS // disables CTSS

#define CTSS_NUM_SAMPLES 8 // maximum number of CTSS samples per pixel

#define USE_CTSS_WEIGHTED // toggle for using visibility-based weights; uncomment for uniform sample weights
// #define USE_CTSS_R // use CTSS Relaxed, faster approximation with sphere tracing termination at hard hit (not full hit)

// small value epsilon, precision for cone tracing intersections.
// Note: cone tracing eps=0.01 is similar to sphere tracing eps=0.0001
// min ~0.0005, else may have visual artifacts
#define OCCLUSION_EPS 0.01

#define OCCLUSION_SOFT (0. - OCCLUSION_EPS) // cone occlusion for soft hit detection
#define OCCLUSION_HARD (0.5 - OCCLUSION_EPS) // cone occlusion for hard hit detection

#ifdef USE_CTSS_R
#define OCCLUSION_STOP OCCLUSION_HARD // relaxed CTSS (faster, worse AA quality)
#else
#define OCCLUSION_STOP (1.0 - OCCLUSION_EPS) // full CTSS (slower, better AA quality)
#endif

#define MIN_SAMPLE_WEIGHT 0.01 // minimum allowed value for a soft hit group weight

#define SPHERE_TRACE_STEPSIZE_MULT 1.0 // controls step size as a multiple of SDF value, useful for non-ideal SDFs
#define CONE_RAD_STEP_MULT 0.5 // upper bound for the step size as a multiple of local cone Radius

// #define DEBUG_NUM_SAMPLES
// #define DEBUG_DEPTH
// #define DEBUG_NORMAL

/* ---------------------------------------- */
// Sphere tracing parameters

#define TMIN 0.01
#define TMAX 30.

#define MAX_RAYMARCH_STEPS 2048  // max SDF marching steps

// cone radius expansion factor in units of pixel size
#define PIXEL_SIZE_MULT_INSCRIBED (1. / 2.) // cone is inscribed in the pixel (inside the pixel)
#define PIXEL_SIZE_MULT_CIRCUMSCRIBED (1. / sqrt(2.)) // cone is circumscribed in the pixel (intersects pixel corners)
#define PIXEL_SIZE_MULT_BALANCED (1. / ((2. + sqrt(2.)) / 2.)) // half way between inscribed and circumscribed
#define PIXEL_SIZE_MULT PIXEL_SIZE_MULT_BALANCED

/* ---------------------------------------- */

// CONE_BACKTRACE more correctly estimates the entry point of a cone hit as sphere tracing detects a delayed hit.
// With sphere tracing, the true cone intersection entry point is somewhere between iterations i-1 and i,
// but cone intersection is only detected at iteration i. This can lead to visual artifacts shading inside a surface.
// CONE_BACKTRACE gives a safe position between iterations i-1 and i, where no hit is guaranteed.
#define CONE_BACKTRACE(t, tanT) (t * (1. - tanT / (1. + tanT)))

/* ---------------------------------------- */

// boundary box parameters
// #define BBOX_FLOOR // toggle for using bbox
#define BBOX_FLOOR_Y -0.25 // y level of floor bbox

/* ---------------------------------------- */

#define CAMERA_STATIC // disables camera panning

/* ---------------------------------------- */
#endif
