﻿#ifndef SDF_GRID_BOX_H
#define SDF_GRID_BOX_H

#include "primitives.cginc"

#define GRID float3(0.32,100.,0.32)
#define GRID_TRACE

float rand(in float2 p2d)
{
    return frac(sin((p2d.x + p2d.y * 100.0)));
}

float2 mapOffsetGridRoundBoxR(in float3 p, in float3 offset, in float3 grid)
{
    float3 pr = opRep(p - offset, grid);
    float3 pi = opRepInd(p - offset, grid);
    float r = 0.2*rand(pi.xz);
    return float2(sdRoundBox(pr+float3(r,r,r), float3(r,10*r*r,r), 0.025), 100 * rand(pi.xz));
}

float2 mapOffsetGridBoxR(in float3 p, in float3 offset, in float3 grid)
{
    float3 pr = opRep(p - offset, grid);
    float3 pi = opRepInd(p - offset, grid);
    float r = 0.02*rand(pi.xz);
    return float2(sdBox(pr+float3(r,r,r), float3(r,10*r*r,r)), 100 * rand(pi.xz));
}

float2 mapOffsetGridBox(in float3 p, in float3 offset, in float3 grid, in float3 bsize)
{
    float3 pr = opRep(p - offset, grid);
    float3 pi = opRepInd(p - offset, grid);
    float h = 5*rand(pi.xz);
    return float2(sdRoundBox(pr, float3(bsize.x, bsize.y * h, bsize.z), 0.025), 100 * rand(pi.xz));
}

float2 mapOffsetSphere(in float3 p, in float3 offset, in float3 grid, in float rad)
{
    float3 pr = opRep(p - offset, grid);
    float3 pi = opRepInd(p - offset, grid);
    return float2(sdSphere(pr, rad), 100 * rand(pi.xz));
}

float2 sdf(in float3 p)
{
    float2 res = float2(1e10, 0.0);

    res = opU(res, float2(sdPlane(p, 0.), 0.));

    // bounding box
    if (sdBox(p, float3(10., 1.0, 10.)) < res.x)
    {
        res = opU(res, mapOffsetGridBox(p, float3(0.,0.,0.), GRID, float3(0.1, 0.145, 0.1)));
        // res = opU(res, mapOffsetGridBox(p, float3(-0.21, 0.245, -.09), float3(1.61,100.,1.853), float3(0.093, 0.245, 0.0783)));
        // res = opU(res, mapOffsetGridBox(p, float3(-1.093, 0.01, -2.09), float3(0.2,100.,0.2), float3(0.01, 0.01, 0.01)));

        // res = opU(res, mapOffsetGridRoundBoxR(p, float3(0.51, 0.145, .525), float3(1.2,100.,1.123)));
        // res = opU(res, mapOffsetGridRoundBoxR(p, float3(-1.093, 0.01, -0.1239), float3(0.2,100.,0.2)));
        // res = opU(res, mapOffsetGridBoxR(p, float3(-1.21, 0.245, -.59), float3(0.61,100.,1.853)));
        // res = opU(res, mapOffsetGridBoxR(p, float3(-0.893, 0.01, -1.09), float3(0.2,100.,0.2)));

        // res = opU(res, mapOffsetGridSphere(p, float3(-1.093, 0.01, -2.09), float3(0.2,100.,0.2), float3(0.01, 0.01, 0.01)));
        // res = opU(res, mapOffsetGrid(p));
        // res = opU(res, mapOffsetGrid(p));
        // res = opU(res, mapOffsetGrid(p));

    }

    return res;
}
#endif
