# Knowledge Graph Completion

This is a implementation of DLP to solve the Knowledge Graph Completion tasks.

The codes are written in C++ to implement the algorithm discribed in the appendix: Discussion of Time Complexity. We are sorry that this is not the complete implementation of the algorithm, as there are some features (batch training for acceleration, variants of update functions for inference) excluded. The complete codes are still under adjustment and we'll release them as soon as possible.

The codes in this repository is able to produce the UMLS and Kinship results. To do so, one need to first compile the cpp files:

g++ main.cpp kg.cpp predictor.cpp rule.cpp ruletrainer.cpp utils.cpp -pthread -o main -O3

Then, use the following commands to reproduce the results:

./main ./data/umls Y Y 1.0 16

./main ./data/kinship N N 2.0 16

The first argument refers to the data folder. The second argument (Y/N) specifies whether reweight data during training. The third argument specifies type of update function (Y: Restrict $\psi$ to be in [0,1]; N: No restriction of $\psi$). The 4th argument specifies $\alpha$. The 5th argument specifies the number of threads to be created by the program to speed up training.