import sys
from dotenv import load_dotenv
from eval.game import Game, Player1, Player2
from loguru import logger
import argparse
logger.remove()
logger.add(sys.stdout, level="INFO")
# logger.add("debug.log", level="DEBUG", rotation="100 MB", encoding="utf-8")

load_dotenv()




# Starting with vision tournamennt
def main():
    parser = argparse.ArgumentParser(description="Evaluate AQuA Tasks")
    parser.add_argument("--delay", type=float, default=0.0, help="")
    parser.add_argument("--vision", action="store_true", help="",default=False)
    parser.add_argument("--filepath", type=str, default="debug.log", help="Path to the log file")
    parser.add_argument("--host", type=str, default="localhost", help="Server hostname or IP")
    parser.add_argument("--ports", type=str, default="38001,38002", help="Comma-separated ports, e.g. 38001,38002")
    args = parser.parse_args()
    logger.add(args.filepath, level="INFO", rotation="100 MB", encoding="utf-8")
    
    # Environment Settings
    if args.vision is True:
        game = Game(

           render=True,
            player_1=Player1(
                nickname="Daddy",
                model="openai:gpt-4o-mini",
                robot_type="vision",  # "vision" or "text"
                temperature=0.7,
            ),
            player_2=Player2(
                nickname="Baby",
                model="openai:gpt-4o-mini",
                robot_type="vision",
                temperature=0.7,

            ),
        )
    else:
        port1 = int(args.ports.split(",")[0])
        port2 = int(args.ports.split(",")[1])
        game = Game(
            render=True,
            player_1=Player1(
                nickname="Agent1",
                model="remote",
                # model = "deepseek:deepseek-reasoner",
                robot_type="remote",  # "vision" or "text"
                temperature=0.7,
                host=args.host,
                port=port1,
                serving_method="remote"
            ),
            player_2=Player2(
                nickname="Agent2",
                model="remote",
                # model = "deepseek:deepseek-reasoner",
                robot_type="remote",
                temperature=0.7,
                host=args.host,
                port=port2,
                serving_method="remote"
            ),
        )
    return game.run(args.delay)


if __name__ == "__main__":
    main()
    
