import glob
import networkx as nx
import pickle
import json
import os
from networkx.readwrite import json_graph
import tiktoken

device = "cuda"


class CodeGenTokenizer:
    def __init__(self, tokenizer_raw):
        self.tokenizer = tokenizer_raw

    def tokenize(self, text):
        return self.tokenizer(text, return_tensors="pt")['input_ids'][0].to(device)

    def decode(self, token_ids):
        return self.tokenizer.decode(token_ids, clean_up_tokenization_spaces=True, skip_special_tokens=True)


class StarCoderTokenizer:
    def __init__(self, tokenizer_raw):
        self.tokenizer = tokenizer_raw

    def tokenize(self, text):
        return self.tokenizer.encode(text, return_tensors="pt")[0].to(device)

    def decode(self, token_ids):
        return self.tokenizer.decode(token_ids, skip_special_tokens=True)

class DeepseekCoderTokenizer:
    def __init__(self, tokenizer_raw):
        self.tokenizer = tokenizer_raw

    def tokenize(self, text):
        return self.tokenizer.encode(text, return_tensors="pt")[0].to(device)

    def decode(self, token_ids):
        return self.tokenizer.decode(token_ids, skip_special_tokens=True)

class CONSTANTS:
    max_hop = 5
    max_search_top_k = 10
    max_statement = 20
    repo_base_dir = f"./repositories"
    graph_database_save_dir = f"./context_database"
    query_graph_save_dir = "./graph_based_query"
    dataset_dir = "./RepoEval-Updated"
    repos = [
        "devchat",
        "nemo_aligner",
        "awslabs_fortuna",
        "task_weaver",
        "huggingface_diffusers",
        "opendilab_ACE",
        "metagpt",
        "apple_axlearn",
        "QingruZhang_AdaLoRA",
        "nerfstudio-project_nerfstudio",

        "turboderp-exllama-a544085",
        "bswck-configzen-42ed40f",
        "diohabara-pychd-b1d0a38",
        "hynnsk-HP-cd48934",
        "appsignal-appsignal-python-5a0cfa9",
        "filipporomani-whatsapp-b2c7ba4",
        "Jason-Qiu-MultiSum_model-c4c58dd",
        "yarrow-id-diagrams-9cbd653",
        "traas-stack-holoinsight-ai-b235643",
        "Spawning-Inc-datadiligence-9e949d2",
        "kabeer11000-autollm-53e7404",
        "philtabor-ProtoRL-31f81e7",
        "Quantomatic-zxlive-c7b5c28",
        "reko-beep-hsr-data-c73208a",
        "beidongjiedeguang-openai-forward-c2c2757",
        "ddPn08-rvc-webui-c4a12a8",
        "OUIsolutions-CWebStudio-633d7c6",
        "jiangjiechen-uncommongen-7d1c76e",
        "amazon-science-random-tma-43df305",
        "ini-multigrid-01ee811",
        "rmihaylov-falcontune-6bd029e",
        "peach-db-peachdb-0fb089b",
        "davidmaamoaix-singleline-311d35f",
        "pnkraemer-matfree-9b88279",
        "geoffwhittington-meshtastic-matrix-relay-ffe969f",
        "probcomp-LLaMPPL-56ef219",
        "jtext-103-jddb-077b729",
        "smpanaro-more-ane-transformers-d5aec6f",
        "SilicalNZ-TapTitans2py-0d5409d",
        "EmbedInAI-EmbedInDB-b2d7852",
        "microsoft-deep-language-networks-e7accd0",
        "vsiegel-thoughttree-84b1498",
        "taptorestart-forms-40b1a91",
        "BrianPugh-tamp-85634f4",
        "xrcyz-dpg-swisscontrols-9412ad4",
        "shijiuchen-Nodens-5589567",
        "gitguesser-gitguesser-297d633",
        "nobu-g-JGLUE-evaluation-scripts-2a39b31",
        "gorarakelyan-langchain-chatbot-72a8678",
        "diptanu-indexify-216ecf2",
        "babylm-baseline-pretraining-43acf2a",
        "Open-Swarm-Net-GPT-Swarm-edfddce",
        "Zhang-Zhiyuan-zzy-hotpot-3a13089",
        "FrancescoSaverioZuppichini-LinkedInGPT-e0c1552",
        "zmzhang2000-HybRank-b68bd2f",
        "techonomydev-django-crispy-tableselect-e2e7016",
        "isayahc-Semi-Automated-Youtube-Channel-80b0201",
        "thb1314-maskrcnn-tensorrt-1bafff6",
        "jfamestad-TexasHoldemAgents-a171a13",
        "virtualzx-nad-easy_llm_agents-8a29505",
        "open-mmlab-Multimodal-GPT-9c73e47",
        "manoskary-vocsep_ijcai2023-ae7bef9",
        "finopsfoundation-focus-spec-validator-7efbac5",
        "prophecy-io-spark-ai-fd52ad1",
        "microsoft-DPSDA-79f0868",
        "lskyset-priconne-asset-extractor-3d54812",
        "sshh12-llm_oracle-79c8b59",
        "OpenGVLab-VideoMAEv2-9492db0",
        "OHDSI-Apollo-57fa612",
        "hyperliquid-dex-hyperliquid-python-sdk-6ddfbfb",
        "Kubenew-ChaosGPT-2c40353",
        "irgolic-AutoPR-10e2891",
        "aws-samples-amazon-codewhisperer-immersion-day-7b3dc66",
        "netorc-community-netorc-324512e",
        "last-war-photoshare-fastapi-67888ff",
        "xbpeng-rl_assignments-cdb92a8",
        "heng840-All_pipeline_Information_Extraction-e94dd96",
        "david-a-jetter-pydantic-dynamo-ff0aa6d",
        "fbdp1202-tts_data_engine-02353ab",
        "neo4j-NaLLM-ca04662",
        "continuum-llms-acad-gpt-9513178",
        "quarkslab-tritondse-9805288",
        "obahamonde-aiofauna-67993d2",
        "ml-research-SLASH-8d0f42d",
        "maybelinot-yamx-5e304a5",
        "HelsinkiUniCollab-WeatherBasedRecommender-cfd21fd",
        "camenduru-minigpt4-439e050",
        "EdwardLeeLPZ-PowerBEV-7ead4ce",
        "PatrickKalkman-python-di-2230ea4",
        "KyGao-ABGNN-1832ca7",
        "3dlg-hcvc-M3DRef-CLIP-420419e",
        "log10-io-log10-d605f37",
        "BlueBrain-Currentscape-29753e8",
        "amazon-science-ope-learn-action-embeddings-4ff26bf",
        "imaginationtech-constrainedrandom-db5b49a",
        "iryna-kondr-scikit-llm-38ad5e9",
        "alex-zaikman-fastapi-postgres-tmpl-cc200aa",
        "K024-chatglm-q-eab6472",
        "swan-utokyo-deir-385d351",
        "Panzer-Jack-ChatGLM_VITS_For_QQ-Rob-5b11f0a",
        "oriyor-reasoning-on-cots-9ae01ce",
        "minyoungg-vqtorch-d0022ea",
        "opensean-kedro-graphql-75c7dae",
        "GenBench-genbench_cbt-caa63fb",
        "Josh-XT-AGiXT-828a01d",
        "griffinbholt-decisionmaking-code-py-e08645e",
        "JerryYLi-svitt-c8806b3",
        "jiggy-ai-jiggybase-068b82b",
        "krishnaik06-Chicken-Disease-Classification-Projects-d0f5e13",
        "doccano-doccano-mini-0ef6c33",
        "Cybereason-eztw-94a0ae9",
        "heshuting555-PAP-FZS3D-e3fc6cb",
        "OvO1111-EfficientSubclassLearning-afdd90e",
        "chainstacklabs-chainbench-177c49e",
        "Donkie-Spoolman-2fcfc38",
        "dSupertramp-PubGPT-253ec52",
        "Fsoft-AIC-Class-Based-Influence-Functions-b957b78",
        "FabienRoger-concistency-lenses-6500b44",
        "aiplan4eu-UP4ROS-59c1358",
        "flatironinstitute-mountainsort5-3e85076",
        "crypto-jobs-fyi-crawler-b0596e6",
        "UKPLab-nlpeer-f81f4bb",
        "ingra14m-mipnerf360-pytorch-bfc1e77",
        "willleeney-ugle-7cfe1b3",
        "memew1se-OpenRSS-f7b766b",
        "IBM-auto-contrastive-generation-4874a25",
        "freddyaboulton-gradio-tools-f0297df",
        "OpenAccess-AI-Collective-axolotl-2c37bf6",
        "mobarski-aidapter-48fd7a8",
        "deepmatterltd-rdfreader-a811645",
        "adobe-aepp-0e23c55",
        "ZhengPeng7-CoSOD_fps_collection-bee3764",
        "colindecourt-darod-ab4878e",
        "dropreg-ChatMLM-273477a",
        "UMEssen-matrix-scala-bd97a56",
        "usecakework-async-backend-c288d0b",
        "NVIDIA-ISAAC-ROS-ros2_benchmark-d7725da",
        "salesforce-AuditNLG-c473044",
        "theneonwhale-frt-photo-share-6659afb",
        "pro470-Live-Save-for-Blender-3b5c1c2",
        "tarsil-databasez-01b23b0",
        "Materials-Data-Science-and-Informatics-somesy-a47ca93",
        "JunbongJang-contour-tracking-1219b66",
        "GoogleCloudPlatform-alloydb-python-connector-a397ea7",
        "Typing-Monkeys-complex-network-link-prediction-cf69190",
        "awslabs-decode-answer-logical-form-08d5790",
        "algorand-conduit-bcb54fd",
        "eimenhmdt-autoresearcher-5235ee7",
        "deep-diver-TFX-WandB-05c63c4",
        "knexer-ai-storyteller-86da1d3",
        "husisy-arxiv-gpt-ef98efb",
        "SindiLab-scANNA-b65b3d8",
        "leandl-wvalidate-8cb9603",
        "yangbang18-ZeroNLG-bbd3f33",
        "build-aau-lcabyg_web_api_doc-b001c5d",
        "ortursucceeh-Project-PhotoShare-1942d61",
        "bharatsubedi-PARseq_torch-8ffcb95",
        "ieasybooks-tafrigh-4aece79",
        "ZhangJD-ong-MoSID-Breast-Tumor-Segmentation-from-Multi-parametric-MRI-e826e12",
        "bazingagin-npc_gzip-928659e",
        "viper-framework-viper2-bd8aa34",
        "omron-sinicx-action-constrained-RL-benchmark-47b85fb",
        "ml-opt-lab-sdmgrad-86963c6",
        "yuyujunjun-RSMT-Realtime-Stylized-Motion-Transition-67c65b7",
        "Adeon18-Mori-Bazius-Backend-f33b8ba",
        "Ying1123-llm-caching-multiplexing-2dc7e69",
        "vectara-vectara-ingest-0a867f1",
        "ChuloAI-BrainChulo-cacf3ac",
        "Textualize-frogmouth-965b92e",
        "roboflow-cvevals-4d29537",
        "pycob-pyvibe-1c1c138",
        "metalbobinou-python-ListComparator-00b6794",
        "Stardust-hyx-Instruction_Tuning-62e36d0",
        "marcpage-pylavi-90a3e81",
        "CPJKU-paow-c8ead3d",
        "fuzzylabs-matcha-examples-c780c2e",
        "HiPer0-HiPer-48a2f6e",
        "kabachuha-sd-webui-text2video-20ead10",
        "facebookresearch-AudioDec-9b49838",
        "tigrisdata-tigris-client-python-667d484",
        "Stevenic-promptrix-py-6ed7059",
        "StigLidu-AutoTruss-ffb5707",
        "fivexl-terraform-aws-sso-elevator-fd46f09",
        "tungduongbk-airflow-custom-plugins-f0f571d",
        "rgbkrk-chatlab-c126c9f",
        "ezhang7423-language-control-diffusion-63cdafb",
        "krishnaik06-Text-Summarization-NLP-Project-3308112",
        "graphcore-PopTransformer-1314598",
        "kraemer-lab-GRAPEVNE-1d241a8",
        "nvidia-holoscan-holoscan-test-suite-e7a809d",
        "AdaptChat-adapt.py-9e079c0",
        "brown-ivl-Cafi-Net-6171499",
        "eloimoliner-BABE-777b624",
        "lhenault-simpleAI-1ac4954",
        "Srameo-DNF-974080a",
        "s41m0n-enid-227634a",
        "CERT-EDF-generaptor-e71eb4c",
        "jdum-asciinema-scene-82f586d",
        "sauljabin-kayak-9fc4a65",
        "0xDebabrata-citrus-3621143",
        "Co1Li1La1-yoshino-bot-5fe202f",
        "ch3njust1n-generative-api-a2ac928",
        "bxdoan-venom-auto-da0fcfa",
        "bytedance-uss-0c15a08",
        "stac-utils-stac-asset-a83c660",
        "vetka925-llms-lora-8bit-4bit-finetuning-lit-eb1b149",
        "v-mikhaylov-tfold-release-e2bae1f",
        "livekit-client-sdk-python-b14fa6c",
        "Herta-villa-Herta-villa-SDK-c862c3b",
        "langchain-ai-kork-3ff7137",
        "Thetacz-nautobot-plugin-device-resources-4caef01",
        "cupidbow20000-cosmos20000-049e193",
        "radar-research-lab-MFGLib-7f12f9d",
        "f-inc-dynamic-e4036a7",
        "pygfx-gfxmorph-0a3a9d9",
        "nyaarium-blender-nyaatools-4fc69af",
        "SuperpoweredAI-task-tree-agent-45b0a49",
        "celyes-checkr-dabd705",
        "vladkens-twscrape-4f2ee7f",
        "hcmlab-GANonymization-a917aba",
        "Donnype-xtdb-py-fc89588",
        "Innocentsax-AirBnB_clone-a48e44b",
        "Zhendong-Wang-Patch-Diffusion-929b0c0",
        "line-Meta-AI-Video-Similarity-Challenge-3rd-Place-Solution-b8cf098",
        "pitaya1001-hta-c83dc5c",
        "fritzsedlazeck-Spectre-01b8ed5",
        "TheStageAI-TorchIntegral-baf578b",
        "twopointone-stripe-integrations-ec992eb",
        "jamescalam-ask-lex-plugin-3769174",
        "wheretrue-biobear-5be051c",
        "weaweawe01-luajit_decompile-2b32d4b",
        "CircuitSacul-io-775ac7c",
        "gabrielmbmb-kaflow-1c5ec86",
        "iqmo-org-magic_duckdb-62e6fcc",
        "ZX-Yin-ms-nerf-9009137",
        "RangiLyu-llama.mmengine-1887d56",
        "huanranchen-EnergyBasedGenerativeModel-ad5989a",
        "YangXiaocui1215-GMP-d3cb04f",
        "evalplus-evalplus-8b713cd",
        "danilonumeroso-dar-64e8631",
        "thismlguy-code-genie-58f789c",
        "Cerlancism-faster-whisper-webui-884f5fd",
        "snu-mllab-Efficient-CNN-Depth-Compression-2828ae8",
        "leggedrobotics-rayen-2ac7086",
        "chrisdewa-ardilla-312a373",
        "blurgyy-jaxngp-adbe49e",
        "gabacode-chatGPDP-4701532",
        "dpasse-extr-f695d3c",
        "continue-revolution-sd-webui-segment-anything-5df716b",
        "BioMag-mtbi_meeg-b757aa8",
        "lucmos-powermanim-1bcf62a",
        "bufbuild-protovalidate-python-2eee9ba",

        "jborean93-dpapi-ng-57143c3",
        "ZikangXiong-STL-Mobile-Robot-eecd396",
        "gdsfactory-gf180-3407e7a",
        "happen2me-subgraph-retrieval-toolkit-5655cb3",
        "KTH-FlowAI-DeepReinforcementLearning_RayleighBenard2D_Control-d1a8dd6",
        "operand-agency-07b1076",
        "KimmiShi-TorchDistPackage-cc385cc",
        "opticore-netbox-nornir-3cd275e",
        "ironwoodcall-TagTracker-bb1e3d9",
        "google-research-precondition-861d2da",
        "pp-mo-ncdata-555ff35",
        "Tlntin-ChatGLM2-6B-TensorRT-bd55117",
        "canpool-QxRibbon-4bbd7f5",
        "penvm-penvm-1846b0f",
        "Jackory-RPBT-dbf3696",
        "RobinSchfr-Lightning-control-for-Nanoleaf-dedf122",
        "francoismdj-netbox-kea-dhcp-f53d9df",
        "phac-nml-rebar-aef5b97",
        "edarchimbaud-systematic-trading-a9fec02",
        "yanqingmen-ask-api-69926aa",
        "lxjmaster-ja3requests-90a33e6",
        "dishb-hive-f0bf4b5",
        "inWeb3ai-chatWeb3-cf1c933",
        "kadirnar-segment-anything-video-039392c",
        "voneiden-ocp-freecad-cam-4813dc9",
        "orsinium-labs-pytypest-80c40ed",
        "devchat-ai-devchat-a8c53d2",
        "ppoitier-sign-language-tools-46eadf9",
        "hugofloresgarcia-vampnet-6de4eeb",
        "Lightning-AI-lit-llama-da71ade",
        "hq0709-Depth-NeuS-49d93d4",
        "profcomff-social-api-d0b645b",
        "dmlc-tl2cgen-9d135f4",
        "chunbolang-R2Net-856e1cc",
        "patio-python-patio-f65bd65",
        "chrisli-kw-AutoTradingPlatform-e59fcfe",
        "hbqjzx-wxxiaozhi-dfc4a65",
        "RTIInternational-teehr-2bd727d",
        "tongyuantongyu-cycmunet-3c34dbe",
        "kaiko-ai-typedspark-cf5bc65",
        "microsoft-gpt-review-b0b9842",
        "Arbol-Project-gridded-etl-tools-320efc1",
        "maxvanspengler-hyperbolic_learning_library-f6cfca3",
        "N00Bception-AI-Powered-5G-OpenRAN-Optimizer-a0eac7b",
        "EleutherAI-concept-erasure-0d4dbcb",
        "yairl-r1xbot-5323f61",
        "odtuyzt-chrono-kit-923b505",
        "OpenGSL-OpenGSL-b40738c",
        "entbappy-cnnClassifier-acadb8a",
        "Gage-Technologies-embedding-server-6b66d47",
        "nccgroup-libslub-7732a54",
        "SAIC-iSmart-API-saic-python-client-29b99ad",
        "jannerm-ddpo-f0b6ca7",
        "continuum-llms-chatgpt-memory-ee08ccc",
        "gdsfactory-kplugins-7a5f7b4",
        "wm-pxel-langchain-testbench-53701f9",
        "ergodicio-adept-2c7eee5",
        "DAMO-NLP-SG-MT-LLaMA-c72f7db",
        "brdav-cma-fdae11a",
        "tricktreat-DiffusionNER-cb095cd",
        "drubinstein-python-compose-f3ab44c",
        "Mikanwolfe-Kuro-55d0744",
        "light1726-BetaVAE_VC-08902f2",
        "NoFish-528-encodec-pytorch-9c2f4a0",
        "opticore-netbox-celery-553cbe6",
        "entangled-entangled.py-4dcbb63",
        "clear-nus-NCDSSM-7212bba",
        "Adam-Vandervorst-PyBHV-ff5dcca",
        "melMass-comfy_mtb-3b07984",
        "decodableco-dbt-decodable-8ef941c",
        "mp3guy-SymE3-445731e",
        "deadblue-py115-ecdcb93",
        "liuzuxin-OSRL-6ede2c2",
        "34j-boost-loss-ff08630",
        "OSIPI-TF2.4_IVIM-MRI_CodeCollection-686d23e",
        "edsaav-nail-64acdc6",
        "AlphaDinosaur89-glang-de75a3e",
        "congtuong-docile-44e4fce",
        "david-stan-dagfed-chain-0a60a23",
        "AlexGidiotis-gpt-light-ae75a5e",
        "dichem-django-excel-report-686e1da",
        "paulpanwang-Cas6D-245489d",
        "sprite-neu-SPREAD-API-a2ee03a",
        "apple-ml-tract-ad25296",
        "cibere-kick.py-03541c0",
        "CMU-MultiComp-Lab-CMU-MultimodalSDK-3e27d37",
        "NKI-AI-STAPLER-bf072e9",
        "chrisrude-oobabot-fa234d6",
        "adrienbrignon-mkdocs-exporter-bdbd7b5",
        "leonelhs-face-shine-8f21b90",
        "tconbeer-textual-textarea-24fab5a",
        "uezo-aiavatarkit-37d28f7",
        "knrdl-acme-ca-server-53598ad",
        "IntelLabs-GraVi-T-08d95be",
        "AntonOsika-gpt-engineer-fc80507",
        "doublewinter0-auto-dns-d9e3a40",
        "yangalan123-Amortized-Interpretability-13e3500",
        "google-lineax-4e8a44a",
        "graphcore-research-unit-scaling-demo-9d9daed",
        "IntelligenzaArtificiale-Free-Auto-GPT-095e991",
        "iuiaoin-wechat-gptbot-b379085",
        "JuniusLuo-VecLucene-8a47c91",
        "eurobios-scb-acrocord-94aeb5e",
        "piercefreeman-vectordb-orm-0b7fe7d",
        "mlfoundations-dataset2metadata-a673a83",
        "egrinstein-gnn_ssl-74c7b5a",
        "bytewax-rt-embed-7069fc6",
        "remixer-dec-botality-ii-f8402d5",
        "somaonishi-MTR-33b87b3",
        "pomponchik-instld-1df14ba",
        "sweetice-PEER-CVPR23-142442f",
        "janghyuk-choi-slot-attention-lightning-2993443",
        "kyegomez-Blockwise-Parallel-Transformer-f849b04",
        "blurry-dev-blurry-1d20aad",
        "dmemsys-SMART-dc4de6f",
        "stn-tap-jquants-336373c",
        "Sygil-Dev-muse-maskgit-pytorch-7d7c00c",
        "steklyashka33-Minecraft-Mod-Translator-92de64d",
        "IBM-domain-adaptive-attribution-robustness-b4c2bee",
        "questdb-questdb-connect-459ecb6",
        "medley56-space_packet_parser-d94290c",
        "dbt-labs-dbt-meshify-a11e507",
        "ZJUM3-LLMEval_RCC-a731888",
        "microsoft-seqrecord-55c8d91",
        "uripeled2-llm-client-sdk-66af541",
        "shug2k-content-review-tool-93305bb",
        "SKbarbon-swoopyui-a4fb25d",
        "Significant-Gravitas-Auto-GPT-Plugins-3975893",
        "slewie-HypONIC-5b95063",
        "Priesemann-Group-nninfo-8289154",
        "crowdgames-sturgeon-pub-a235e6d",
        "ches-001-metatune-278c315",
        "wolfhoundgelert-xman-1da4d2d",
        "deep-diver-PingPong-7ace26b",
        "solo-spice-sospice-64c941b",
        "scottjiao-SlotGAT_ICML23-4aa4583",
        "MatteoSalvatori-INCE-23e589c",
        "SolarisNeko-suger-python-67383eb",
        "amd-Open-Field-Health-Check-415e8a6",
        "lambrou-SemTerm-b57ef90",
        "libsql-libsql-client-py-484c7d3",
        "callowayproject-bump-my-version-0cf1cb5",
        "ansys-pyaedt-toolkit-template-73b2fc9",
        "JohnnyIrvin-shell-craft-26a7af7",
        "eugenos-programos-Own-language-with-LLVM-lite-c8b9e08",
        "utiasDSL-fmpc_socp-de13764",
        "epfml-landmark-attention-111ee30",
        "yuvalkirstain-PickScore-5fa69e8",
        "xsfa-pointstorm-ede28ec",
        "elementsinteractive-twyn-4517d87",
        "kit-cel-mokka-8a555d9",
        "hyp3rd-telegram-discord-bridge-24fa2fb",
        "danyi1212-celery-insights-a742653",
        "llmapi-io-llmapi-server-cdae9ca",
        "satyapravin-Deribit-Option-Arb-c6fead7",
        "anarchy-ai-LLM-VM-83da960",
        "DFilyushin-habr-project-inn-0465f4f",
        "Genentech-walk-jump-3cfaa37",
        "teelinsan-parallel-decoding-b16a009",
        "chatnoir-eu-web-content-extraction-benchmark-221b650",
        "czczup-GPTrans-1f6f651",
        "mihirh19-todo_web_app-fed9043",
        "airdot-io-airdot-deployer-4897777",
        "ycc140-fastapi_messaging-bed8c86",
        "celluloseai-sdk-9bb71fb",
        "lwb2099-stable_diffusion_pytorch-dbdb663",
        "SEIAROTg-autobean-format-2a51179",
        "ryongithub-GatedPromptTuning-1de14b5",
        "20171130-llmux-249dcdb",
        "run-llama-llama-lab-3364c9e",
        "quarkslab-pastis-d790def",
        "valentingol-cliconfig-c772180",
        "davisyoshida-qax-34f0905",
        "chunmeifeng-FedPR-f5c3e67",
        "Mattie-chatsnack-94305b2",
        "ycyy-faster-whisper-webui-fe432f8",
        "mraniki-dxsp-71b0c1e",
        "argus-hdps-rico-426daa0",
        "FizzleDorf-AIT-ad34668",
        "sebastienrousseau-pain001-86a271f",
        "mecene-studio-debugGpt-20e9b61",
        "nicolasebastianelli-speech-ai-323473b",
        "kumitterer-matrix-gptbot-d2c6682",
        "Facico-Chinese-Vicuna-1c4cbfc",
        "wxian3-NeuroLens-380d68c",
        "pimoroni-badger2040-24d6eb6",
        "tmori-generative-agents-81cabfd",
        "GChristensen-deepfloyd_if_lab-4644b93",
        "esnya-lm-talkbot-f072b85",
        "dory111111-Pengenuity-297d9ee",
        "CassioML-cassio-7953897",
        "thuliu-yt16-dualvector-e5ae56e",
        "havenhq-haven-fa692f2",
        "kaiokendev-superbig-be5500b",
        "bond-anton-BDPotentiometer-872a7e2",
        "gnbonney-SymLogos-08a26af",
        "caniko-pydantic-numpy-abcfd59",
        "jfc43-stratified-adv-rej-bfdc043",
        "slonogram-slonogram-9f86552",
        "AICPS-RS2G-b4e985f",
        "LLukas22-llm-rs-python-90e5e70",
        "DMSintalor-OJ-Be-f04ae6e",
        "speedb-io-log-parser-d600b0e",
        "axelmunch-laser-tag-38f6fc0",
        "pawelkn-xapi-python-788a721",
        "paulromano-endf-python-745bbb5",
        "motherofcoconuts-async-dramatiq-b9512a1",
        "LineIndent-material_design_flet-bca5bd8",
        "slawekradzyminski-personal-ai-assistant-2736d10",
        "janvarev-OneRingTranslator-e4dab8d",
        "briandelmsft-STAT-Function-f91d421",
        "tricktreat-PromptNER-3857235",
        "PatrickKalkman-python-eda-e98886c",
        "rosemary666-chatgpt-3adfb2d",
        "mboot-github-WhoisDomain-0b5dbb3",
        "Hxyou-IdealGPT-54f5acf",
        "NREL-BuildingsBench-cc4b03d",
        "kiran94-prfiesta-c37e012",
        "meh9-game-of-life-8767f07",
        "Kamilfo-Developer-alice-sleepy-helper-skill-febf9f7",
        "javiber-scrat-748926a",
        "datasig-ac-uk-RoughPy-fbd9016",
        "alteryx-locust-grasshopper-632db06",
        "yotakayama-STLCCP-edcfad4",

        "AADevelops-JaGame-fc2ae51",
        "aaron-ai-rocketmq-opentelemetry-f943317",
        "achousa-telegram-gpt-bot-ff31db1",
        "1754048656-FATJS-4b1e065",
        "acikek-hazard-diamond-faf1ee8",
        "20231-ifba-saj-ads-poo-blog-material-aula-7ef4df7",
        "adryd325-sneaky-df32bca",
        "akang943578-java-bard-api-7352c25",
        "akshayp7-playwright-java-cucumber-f722d27",
        "aliyun-alibabacloud-package-deployment-plugin-af7d0f8",
        "aliyun-alibabacloud-push-reactnative-plugin-bf5b821",
        "adorabled4-springboot-template-c06b07d",
        "aliturgutbozkurt-city-application-23ee1fb",
        "admin4j-admin4j-json-dedd7eb",
        "AntChainOpenLab-AntChainBridgePluginServer-c6acccc",
        "AOSPA-android_device_xiaomi_sm6225-common-0a9c912",
        "aress31-burpgpt-79ea6b9",
        "ArcanePlugins-PAPISigns-7a07a38",
        "applejuiceyy-FiguraStockfish-9530a39",
        "aserto-dev-aserto-java-8042222",
        "apache-incubator-paimon-shade-bfc2f24",
        "Big-billed-shark-fineely-config-6069a36",
        "blessedmusicalturkeys-project-release-notes-d9120d6",
        "aws-personalize-kafka-connector-cb28efc",
        "Blamer-io-hub-33ef413",
        "Big-billed-shark-fineely-log-a1bbea7",
        "bouchraakl-LotMaster-Backend-eae3cc8",
        "BNYMellon-graphql-kata-48706d4",
        "burningtnt-SimpleWEBP-0bdd60c",
        "brokiem-BedrockReplay-adc9701",
        "ckmu32-Bot-Checker-c582a74",
        "camunda-community-hub-camunda-modeler-template-generator-155826e",
        "Col-E-TreeMapFX-226ef8c",
        "conena-therlock-0000c84",
        "coralblocks-CoralME-ec2b736",
        "carlrobertoh-openai-client-7a73e99",
        "CHRISL7-android_device_xiaomi_sm6225-common-ed8a1e0",
        "Cosium-hypermedia-irl-presentation-0269869",
        "CounterpointConsulting-agency-5891951",
        "CrackedPolishedBlackstoneBricksMC-minivan-4e8aa7f",
        "Cristike-AquaInput-c8e8cb9",
        "criccomini-twister-4e63c85",
        "Dalaranian-GodLifeDiary-4811d09",
        "czqclm-aicq-open-ai-api-a7b76bc",
        "DaPutzy-intellij-sops-plugin-d164a55",
        "dannegm-BlockEntities-7256b11",
        "danielsobrado-edgar-cik-cusip-ticker-sector-service-745194d",
        "darkevilmac-FedUp-d741f7d",
        "DarrenTianYe-android_dynamic_load_so-7a70027",
        "decodableco-decodable-pipeline-sdk-af78b8a",
        "dd8023dd-chatgpt-web-server-7bd2f76",
        "deeround-jdbc-plus-a0dcdfd",
        "DennisRippinger-cru-6558fde",
        "dataplatform-lab-deltastore-017c850",
        "digitalinnovationone-spring-boot-3-rest-api-template-55aab88",
        "DJ-Raven-swing-toast-notifications-4c7978a",
        "dmitriyvolk-redrover-draw-b9b5e7d",
        "deshaw-pjrmi-4212d0a",
        "EASYHOME-DOORVERSE-easyhome-springcloud-gray-faee63a",
        "EMCProtocol-dev-emc_java_sdk-82e4b0e",
        "Dzen-Platform-kafka-connect-ytsaurus-518a6b8",
        "enzogebauer-duckling_animes-a00d26d",
        "ericblue-ChatGPT-Twilio-Java-e88e8a0",
        "enzulode-networking-library-dfda932",
        "dudu-Dev0-WearGPT-2a5428e",
        "EricTra-University_Admission-18ace1f",
        "EricTra-University-Admission-Final-Version-944c929",
        "Estructura-de-Datos-2223-3-S2-Ejercicios-en-clase-c874295",
        "felldo-JEmoji-a3e9bdb",
        "EvilMindDevs-HMS-UnrealEngine-Plugin-9783dfb",
        "filipe-oliv95-TrabalhoBancoPOO_Grupo7-e86048d",
        "FlorianMichael-CheckHost4J-b580631",
        "FlorianMichael-Classic4J-6e0a2ff",
        "FitzHastings-DownfallEAM-f1a06ef",
        "florianpirchner-java-gpt-commands-8f92fe9",
        "FlyJingFish-TitleBar-24dc5b6",
        "Francisco-Jean-API-BRINQUEDOMANIA-0013ce2",
        "flytegg-ls-projects-d0e70ee",
        "frazik-main-AmplifyGPT-ac49c2a",
        "frank89722-Staaaaaaaaaaaack-65a0402",
        "froobynooby-SeeMore-8347860",
        "george-java-native-obfuscation-study-76ae062",
        "germanosin-kafka-leader-election-bfac281",
        "gerasiovM-ParticleAPI-376987e",
        "Fyustorm-mInetiface-6a598f5",
        "GoogleCloudPlatform-app-large-data-sharing-java-fd21141",
        "google-cql-on-beam-82f1c68",
        "grcreutzberg-dice-api-d58bb3d",
        "GeyserMC-Hydraulic-80cb8ab",
        "heartalborada-del-newbingAPI-1102bfb",
        "gtomitsuka-rn-phone-number-input-2f2e43b",
        "GrapheneOS-Archive-platform_packages_apps_Traceur-2e6c52a",
        "HiWord9-RPRenames-fabric-046f2f8",
        "HO-Artisan-RecipeInProgramming-09cc072",
        "hiparker-lint-rpc-framework-e64aac0",
        "Hypsster-hUtils-d265b4f",
        "iAldrich23xX-libasynWebhook-52a1773",
        "Jan222333444-EasyContactForms-a2cf723",
        "jaredlll08-searchables-2cb19ff",
        "jcsirot-dagger-java-sdk-366c947",
        "JesseTzh-stable-diffusion-java-20f5a07",
        "iamr0s-Dhizuku-API-009d517",
        "k0hlii-reservationsystem-cf95137",
        "ka0un-DiscordLeaderboards-ffaaf38",
        "jaketracey-opax-44a71f1",
        "keith2018-SharedTexture-1995d41",
        "Khajiitos-ServerCountryFlags-e056c80",
        "Konloch-HTTPdLib-b7a1e2e",
        "kingschan1204-easycrawl-a5aade8",
        "klepto-unreflect-a818c39",
        "Kyant0-m3color-eaa1e34",
        "making-webhook-verifier-edb251a",
        "limebrew-org-xpense-service-54b5f64",
        "l3r8yJ-milan-9813ad6",
        "lihangfu-copilot-server-41b259b",
        "matheusgmello-dslist-backend-4347223",
        "landonjw-GooeyUI-e1b3d47",
        "lvoegl-chatters-api-da3fa86",
        "matheusgmello-workshop-springboot3-jpa-16e84f3",
        "MERVECETIN1929-Turkcell-Homework1-bdf94f0",
        "MCTeamPotato-MineGPT-00b1415",
        "mexicanminion-DND_Minecraft-5e7753b",
        "MichaelsPlayground-NfcHceNdefEmulator-fa2ca23",
        "mineblock11-SimpleBroadcast-47157bd",
        "Mikhail2048-properties-maven-plugin-2ab2e8e",
        "microsoft-lst-bench-96ac3ca",
        "minivv-gpt-copilot-b16ad12",
        "ministryofjustice-laa-dces-report-service-ac8db88",
        "MuhammetTahaDemiryol-Turkcell-Homework-39026c6",
        "NBXXF-XXFi18nPlugin-065127d",
        "nando-cezar-design-patterns-music-19ebdb3",
        "MrMystery10-del-Slirik-b1c532b",
        "mitrofmep-JBimer-fd7a0ba",
        "MyWorldLLC-Buoy-c7d77a1",
        "NeoProtect-NeoPlugin-a71f673",
        "Neural-Enigma-Art-sales-Spring-Boot-57a8036",
        "Neural-Enigma-Ecommerce-Sales-Dashboard-Spring-0130f60",
        "newhoo-RestfulBox-Solon-8533971",
        "Neural-Enigma-RestaurantManagement-Spring-Boot-Java-086881a",
        "nielsbasjes-conventional-commits-maven-release-151e36d",
        "noQ-sweden-noq-7f5b8d1",
        "objectionary-flatty-688a3da",
        "open-dingtalk-dingtalk-stream-sdk-java-quick-start-bb889b2",
        "onebeastchris-visitors-abf022e",
        "Nova-Committee-Flotage-Fabric-6478e2a",
        "OrangoMango-Chess-c4bd8f5",
        "nsce9806q-k-spring-security-8e88d3d",
        "No-Country-c11-19-m-javareact-cf62efa",
        "openquartz-spring-cloud-feign-plugin-bdc8753",
        "opendatadiscovery-oddrn-specification-0d29a61",
        "OseiasYC-SpringBook-76f673d",
        "Ozeitis-Enhancing-7c0fc20",
        "OSUSecLab-QtRE-e0bcde6",
        "OpenQuickJS-quickjs-android-0319d76",
        "paulgutv-currency-converter-d95cf08",
        "OseiasYC-SpringBook-v3-dcc7eb1",
        "pannous-jini-plugin-0b2b57a",
        "platzi-curso-java-spring-data-jpa-ab96de0",
        "PlaytikaOSS-maven-plugins-1781693",
        "PEC-CSS-acm-website-backend-b92d4e4",
        "platzi-curso-java-spring-security-c81e819",
        "piiano-vault-java-8a95eec",
        "PixelExperience-Devices-device_xiaomi_sm6225-common-ac5a1ea",
        "PolyRocketMatt-Reflow-8aee734",
        "PortingLab-ForgedLoaderAPI-610f27f",
        "polesmih-BuisnessDocumentForms_bot-6fa1315",
        "pxpy-jump-to-controller-927384c",
        "PyAlaie-spotify-408f7ba",
        "powercasgamer-libby-c9b0491",
        "rdelfino-simple-api-gateway-client-27b5fb2",
        "RealAlphaUA-Skript-a61d959",
        "Rabby033-Online-Course-Management-System-4258105",
        "qjc1024join-midjourney-bot-api-deac0e7",
        "quarkiverse-quarkus-bucket4j-a9c07c9",
        "Riicarus-SaggioTask-5f8b53a",
        "samokat-oss-performance-mockserver-3b28165",
        "sammwyy-MCDeploy-e30a9a5",
        "rodrigolmacedo-app-consumo-eletro-682f95a",
        "SadGhostYT-Espresso-f09023a",
        "Silence1017-EtherWatchdog_Server-a419615",
        "RHEcosystemAppEng-exhort-747acb8",
        "SHsuperCM-Stonecutter-937eca5",
        "RebieKong-file-bridge-c3b4855",
        "skku-daniilkim-skku_swe300242_team1-7b9f8fc",
        "SocketC0nnection-JVA-83eab43",
        "skfl-andersen-task-ccf50ec",
        "souslesens-jowl-0fd545e",
        "soujava-pom-editor-maven-plugin-0caa82a",
        "solodroidx-multi-ads-sdk-4f23cdf",
        "storycraft-serde-mc-757a9e4",
        "sssdgithub-ddns4j-eadfbee",
        "strimzi-strimzi-mqtt-bridge-cb0a4b8",
        "stupdit1t-jackson-expand-boot-starter-b492b74",
        "tati2002med-dashboarder-spring-mvc-api-61d5a07",
        "tballison-commoncrawl-fetcher-lite-2c106d1",
        "suimz-chatgpt-web-java-37a4c63",
        "TechnicallyCoded-FoliaLib-8f9f24f",
        "telekom-phonenumber-normalizer-9a1b7ad",
        "TheHamester-HitIndicator-261bcb9",
        "Sparks-and-Rotation-woodencog-bb3d3ef",
        "terrarium-earth-Hermes-00fce0f",
        "tcheeric-nostr-bot-18de389",
        "TheKaVu-GameAPI-acf2cb4",
        "TosoxDev-Tosox-Jr-362c6b5",
        "tomridder-ImitateTikTokPlayer-d6d79c5",
        "TrumanDu-the-force-ae8d6ed",
        "Tripli33-airlines-2e5df64",
        "ThomasMiz-springmvc-guide-d59137b",
        "unnamed-creative-faces-21686d7",
        "unblu-ucascade-fa85c39",
        "upe-garanhuns-psw-2023.1-f069bf0",
        "vikastripathi707-BookStoreApp-8551fcb",
        "tylix-group-app-ca2c661",
        "wesleyfsousa01-workshop-spring-boot-mongoDB-2ed3895",
        "vudangngoc-janus-java-client-b9f0b37",
        "volodya-lombrozo-oop-statistics-filter-c298155",
        "wandererex-wormhole-a724af4",
        "vsantos1-java-microframework-web-a4674ab",
        "wenqiglantz-rds-hybrid-multitenancy-ad04a23",
        "Western-parotia-BookViewProject-1727e80",
        "Western-parotia-Net-accd348",
        "WHyxrs-DesignMode-5af30b7",
        "XenyriaNET-xeem-b635ea0",
        "wisp-forest-lavender-md-87862e2",
        "xTracr-RealCamera-7675633",
        "xizixuejie-canal-spring-849e5c4",
        "xuanwenchao-Metaphor-0176f35",
        "yonetmen-ExceptionAI-287a40d",
        "yakampe-TDDPredict-d2aa06b",
        "yeliheng-EventBus-50cbec9",
        "yhzdys-litchi-71b57c8",
        "Western-parotia-EaseLint-a9e3988",
        "YunaBraska-github-workflow-plugin-a13028a",
        "zqzq3-chatgpt-botforQQ-c64fc49",
        "zymzrr-hand2number-fe6fd4b",
        "zero-hua-geekhub-server-3919d7b",
        "zhongjinggz-geekdemo-4cec99e",
        "zhouwentong1993-jimu-bae2d48",
        "ZhongFuCheng3y-hades-dfd5ea1",

        "FloatingPoint-MC_MIN",
        "itlemon_chatgpt4j",
        "mybatis-flex_mybatis-flex",
        "Guiqu1aixi_rocketmq",
        "SimonHalvdansson_Harmonic-HN",
        "Open-DBT_open-dbt",
        "QuasiStellar_custom-pixel-dungeon",
        "gentics_cms-oss",


        ]

    repos_language = {
         "devchat": "python",
         "nemo_aligner": "python",
         "awslabs_fortuna": "python",
         "task_weaver": "python",
         "huggingface_diffusers": "python",
         "opendilab_ACE": "python",
         "metagpt": "python",
         "apple_axlearn": "python",
         "QingruZhang_AdaLoRA": "python",
         "nerfstudio-project_nerfstudio": "python",
        "turboderp-exllama-a544085": "python",
        "bswck-configzen-42ed40f": "python",
        "diohabara-pychd-b1d0a38": "python",
        "hynnsk-HP-cd48934": "python",
        "appsignal-appsignal-python-5a0cfa9": "python",
        "filipporomani-whatsapp-b2c7ba4": "python",
        "Jason-Qiu-MultiSum_model-c4c58dd": "python",
        "yarrow-id-diagrams-9cbd653": "python",
        "traas-stack-holoinsight-ai-b235643": "python",
        "Spawning-Inc-datadiligence-9e949d2": "python",
        "kabeer11000-autollm-53e7404": "python",
        "philtabor-ProtoRL-31f81e7": "python",
        "Quantomatic-zxlive-c7b5c28": "python",
        "reko-beep-hsr-data-c73208a": "python",
        "beidongjiedeguang-openai-forward-c2c2757": "python",
        "ddPn08-rvc-webui-c4a12a8": "python",
        "OUIsolutions-CWebStudio-633d7c6": "python",
        "jiangjiechen-uncommongen-7d1c76e": "python",
        "amazon-science-random-tma-43df305": "python",
        "ashi-ta-speechGLUE-724cf40": "python",
        "ini-multigrid-01ee811": "python",
        "rmihaylov-falcontune-6bd029e": "python",
        "peach-db-peachdb-0fb089b": "python",
        "davidmaamoaix-singleline-311d35f": "python",
        "pnkraemer-matfree-9b88279": "python",
        "geoffwhittington-meshtastic-matrix-relay-ffe969f": "python",
        "probcomp-LLaMPPL-56ef219": "python",
        "jtext-103-jddb-077b729": "python",
        "smpanaro-more-ane-transformers-d5aec6f": "python",
        "SilicalNZ-TapTitans2py-0d5409d": "python",
        "EmbedInAI-EmbedInDB-b2d7852": "python",
        "microsoft-deep-language-networks-e7accd0": "python",
        "vsiegel-thoughttree-84b1498": "python",
        "taptorestart-forms-40b1a91": "python",
        "BrianPugh-tamp-85634f4": "python",
        "xrcyz-dpg-swisscontrols-9412ad4": "python",
        "shijiuchen-Nodens-5589567": "python",
        "gitguesser-gitguesser-297d633": "python",
        "nobu-g-JGLUE-evaluation-scripts-2a39b31": "python",
        "gorarakelyan-langchain-chatbot-72a8678": "python",
        "diptanu-indexify-216ecf2": "python",
        "babylm-baseline-pretraining-43acf2a": "python",
        "Open-Swarm-Net-GPT-Swarm-edfddce": "python",
        "Zhang-Zhiyuan-zzy-hotpot-3a13089": "python",
        "FrancescoSaverioZuppichini-LinkedInGPT-e0c1552": "python",
        "zmzhang2000-HybRank-b68bd2f": "python",
        "techonomydev-django-crispy-tableselect-e2e7016": "python",
        "isayahc-Semi-Automated-Youtube-Channel-80b0201": "python",
        "thb1314-maskrcnn-tensorrt-1bafff6": "python",
        "jfamestad-TexasHoldemAgents-a171a13": "python",
        "virtualzx-nad-easy_llm_agents-8a29505": "python",
        "open-mmlab-Multimodal-GPT-9c73e47": "python",
        "manoskary-vocsep_ijcai2023-ae7bef9": "python",
        "finopsfoundation-focus-spec-validator-7efbac5": "python",
        "prophecy-io-spark-ai-fd52ad1": "python",
        "microsoft-DPSDA-79f0868": "python",
        "lskyset-priconne-asset-extractor-3d54812": "python",
        "sshh12-llm_oracle-79c8b59": "python",
        "OpenGVLab-VideoMAEv2-9492db0": "python",
        "OHDSI-Apollo-57fa612": "python",
        "hyperliquid-dex-hyperliquid-python-sdk-6ddfbfb": "python",
        "Kubenew-ChaosGPT-2c40353": "python",
        "irgolic-AutoPR-10e2891": "python",
        "aws-samples-amazon-codewhisperer-immersion-day-7b3dc66": "python",
        "netorc-community-netorc-324512e": "python",
        "last-war-photoshare-fastapi-67888ff": "python",
        "xbpeng-rl_assignments-cdb92a8": "python",
        "heng840-All_pipeline_Information_Extraction-e94dd96": "python",
        "david-a-jetter-pydantic-dynamo-ff0aa6d": "python",
        "fbdp1202-tts_data_engine-02353ab": "python",
        "neo4j-NaLLM-ca04662": "python",
        "continuum-llms-acad-gpt-9513178": "python",
        "quarkslab-tritondse-9805288": "python",
        "obahamonde-aiofauna-67993d2": "python",
        "ml-research-SLASH-8d0f42d": "python",
        "maybelinot-yamx-5e304a5": "python",
        "HelsinkiUniCollab-WeatherBasedRecommender-cfd21fd": "python",
        "camenduru-minigpt4-439e050": "python",
        "EdwardLeeLPZ-PowerBEV-7ead4ce": "python",
        "PatrickKalkman-python-di-2230ea4": "python",
        "KyGao-ABGNN-1832ca7": "python",
        "3dlg-hcvc-M3DRef-CLIP-420419e": "python",
        "log10-io-log10-d605f37": "python",
        "BlueBrain-Currentscape-29753e8": "python",
        "amazon-science-ope-learn-action-embeddings-4ff26bf": "python",
        "imaginationtech-constrainedrandom-db5b49a": "python",
        "iryna-kondr-scikit-llm-38ad5e9": "python",
        "alex-zaikman-fastapi-postgres-tmpl-cc200aa": "python",
        "K024-chatglm-q-eab6472": "python",
        "swan-utokyo-deir-385d351": "python",
        "Panzer-Jack-ChatGLM_VITS_For_QQ-Rob-5b11f0a": "python",
        "oriyor-reasoning-on-cots-9ae01ce": "python",
        "minyoungg-vqtorch-d0022ea": "python",
        "opensean-kedro-graphql-75c7dae": "python",
        "GenBench-genbench_cbt-caa63fb": "python",
        "Josh-XT-AGiXT-828a01d": "python",
        "griffinbholt-decisionmaking-code-py-e08645e": "python",
        "JerryYLi-svitt-c8806b3": "python",
        "jiggy-ai-jiggybase-068b82b": "python",
        "krishnaik06-Chicken-Disease-Classification-Projects-d0f5e13": "python",
        "doccano-doccano-mini-0ef6c33": "python",
        "Cybereason-eztw-94a0ae9": "python",
        "heshuting555-PAP-FZS3D-e3fc6cb": "python",
        "OvO1111-EfficientSubclassLearning-afdd90e": "python",
        "chainstacklabs-chainbench-177c49e": "python",
        "Donkie-Spoolman-2fcfc38": "python",
        "dSupertramp-PubGPT-253ec52": "python",
        "Fsoft-AIC-Class-Based-Influence-Functions-b957b78": "python",
        "FabienRoger-concistency-lenses-6500b44": "python",
        "aiplan4eu-UP4ROS-59c1358": "python",
        "flatironinstitute-mountainsort5-3e85076": "python",
        "crypto-jobs-fyi-crawler-b0596e6": "python",
        "UKPLab-nlpeer-f81f4bb": "python",
        "ingra14m-mipnerf360-pytorch-bfc1e77": "python",
        "willleeney-ugle-7cfe1b3": "python",
        "memew1se-OpenRSS-f7b766b": "python",
        "IBM-auto-contrastive-generation-4874a25": "python",
        "freddyaboulton-gradio-tools-f0297df": "python",
        "OpenAccess-AI-Collective-axolotl-2c37bf6": "python",
        "mobarski-aidapter-48fd7a8": "python",
        "deepmatterltd-rdfreader-a811645": "python",
        "adobe-aepp-0e23c55": "python",
        "ZhengPeng7-CoSOD_fps_collection-bee3764": "python",
        "colindecourt-darod-ab4878e": "python",
        "dropreg-ChatMLM-273477a": "python",
        "UMEssen-matrix-scala-bd97a56": "python",
        "usecakework-async-backend-c288d0b": "python",
        "NVIDIA-ISAAC-ROS-ros2_benchmark-d7725da": "python",
        "salesforce-AuditNLG-c473044": "python",
        "theneonwhale-frt-photo-share-6659afb": "python",
        "pro470-Live-Save-for-Blender-3b5c1c2": "python",
        "tarsil-databasez-01b23b0": "python",
        "Materials-Data-Science-and-Informatics-somesy-a47ca93": "python",
        "JunbongJang-contour-tracking-1219b66": "python",
        "GoogleCloudPlatform-alloydb-python-connector-a397ea7": "python",
        "Typing-Monkeys-complex-network-link-prediction-cf69190": "python",
        "awslabs-decode-answer-logical-form-08d5790": "python",
        "algorand-conduit-bcb54fd": "python",
        "eimenhmdt-autoresearcher-5235ee7": "python",
        "deep-diver-TFX-WandB-05c63c4": "python",
        "knexer-ai-storyteller-86da1d3": "python",
        "husisy-arxiv-gpt-ef98efb": "python",
        "SindiLab-scANNA-b65b3d8": "python",
        "leandl-wvalidate-8cb9603": "python",
        "yangbang18-ZeroNLG-bbd3f33": "python",
        "build-aau-lcabyg_web_api_doc-b001c5d": "python",
        "ortursucceeh-Project-PhotoShare-1942d61": "python",
        "bharatsubedi-PARseq_torch-8ffcb95": "python",
        "ieasybooks-tafrigh-4aece79": "python",
        "ZhangJD-ong-MoSID-Breast-Tumor-Segmentation-from-Multi-parametric-MRI-e826e12": "python",
        "bazingagin-npc_gzip-928659e": "python",
        "viper-framework-viper2-bd8aa34": "python",
        "omron-sinicx-action-constrained-RL-benchmark-47b85fb": "python",
        "ml-opt-lab-sdmgrad-86963c6": "python",
        "yuyujunjun-RSMT-Realtime-Stylized-Motion-Transition-67c65b7": "python",
        "Adeon18-Mori-Bazius-Backend-f33b8ba": "python",
        "Ying1123-llm-caching-multiplexing-2dc7e69": "python",
        "vectara-vectara-ingest-0a867f1": "python",
        "ChuloAI-BrainChulo-cacf3ac": "python",
        "Textualize-frogmouth-965b92e": "python",
        "roboflow-cvevals-4d29537": "python",
        "pycob-pyvibe-1c1c138": "python",
        "metalbobinou-python-ListComparator-00b6794": "python",
        "Stardust-hyx-Instruction_Tuning-62e36d0": "python",
        "marcpage-pylavi-90a3e81": "python",
        "CPJKU-paow-c8ead3d": "python",
        "fuzzylabs-matcha-examples-c780c2e": "python",
        "HiPer0-HiPer-48a2f6e": "python",
        "kabachuha-sd-webui-text2video-20ead10": "python",
        "facebookresearch-AudioDec-9b49838": "python",
        "tigrisdata-tigris-client-python-667d484": "python",
        "Stevenic-promptrix-py-6ed7059": "python",
        "StigLidu-AutoTruss-ffb5707": "python",
        "fivexl-terraform-aws-sso-elevator-fd46f09": "python",
        "tungduongbk-airflow-custom-plugins-f0f571d": "python",
        "rgbkrk-chatlab-c126c9f": "python",
        "ezhang7423-language-control-diffusion-63cdafb": "python",
        "krishnaik06-Text-Summarization-NLP-Project-3308112": "python",
        "graphcore-PopTransformer-1314598": "python",
        "kraemer-lab-GRAPEVNE-1d241a8": "python",
        "nvidia-holoscan-holoscan-test-suite-e7a809d": "python",
        "AdaptChat-adapt.py-9e079c0": "python",
        "brown-ivl-Cafi-Net-6171499": "python",
        "eloimoliner-BABE-777b624": "python",
        "lhenault-simpleAI-1ac4954": "python",
        "Srameo-DNF-974080a": "python",
        "s41m0n-enid-227634a": "python",
        "CERT-EDF-generaptor-e71eb4c": "python",
        "jdum-asciinema-scene-82f586d": "python",
        "sauljabin-kayak-9fc4a65": "python",
        "0xDebabrata-citrus-3621143": "python",
        "Co1Li1La1-yoshino-bot-5fe202f": "python",
        "ch3njust1n-generative-api-a2ac928": "python",
        "bxdoan-venom-auto-da0fcfa": "python",
        "bytedance-uss-0c15a08": "python",
        "stac-utils-stac-asset-a83c660": "python",
        "vetka925-llms-lora-8bit-4bit-finetuning-lit-eb1b149": "python",
        "v-mikhaylov-tfold-release-e2bae1f": "python",
        "livekit-client-sdk-python-b14fa6c": "python",
        "Herta-villa-Herta-villa-SDK-c862c3b": "python",
        "langchain-ai-kork-3ff7137": "python",
        "Thetacz-nautobot-plugin-device-resources-4caef01": "python",
        "cupidbow20000-cosmos20000-049e193": "python",
        "radar-research-lab-MFGLib-7f12f9d": "python",
        "f-inc-dynamic-e4036a7": "python",
        "pygfx-gfxmorph-0a3a9d9": "python",
        "nyaarium-blender-nyaatools-4fc69af": "python",
        "SuperpoweredAI-task-tree-agent-45b0a49": "python",
        "celyes-checkr-dabd705": "python",
        "vladkens-twscrape-4f2ee7f": "python",
        "hcmlab-GANonymization-a917aba": "python",
        "Donnype-xtdb-py-fc89588": "python",
        "Innocentsax-AirBnB_clone-a48e44b": "python",
        "Zhendong-Wang-Patch-Diffusion-929b0c0": "python",
        "line-Meta-AI-Video-Similarity-Challenge-3rd-Place-Solution-b8cf098": "python",
        "pitaya1001-hta-c83dc5c": "python",
        "fritzsedlazeck-Spectre-01b8ed5": "python",
        "TheStageAI-TorchIntegral-baf578b": "python",
        "twopointone-stripe-integrations-ec992eb": "python",
        "jamescalam-ask-lex-plugin-3769174": "python",
        "wheretrue-biobear-5be051c": "python",
        "weaweawe01-luajit_decompile-2b32d4b": "python",
        "CircuitSacul-io-775ac7c": "python",
        "gabrielmbmb-kaflow-1c5ec86": "python",
        "iqmo-org-magic_duckdb-62e6fcc": "python",
        "ZX-Yin-ms-nerf-9009137": "python",
        "RangiLyu-llama.mmengine-1887d56": "python",
        "huanranchen-EnergyBasedGenerativeModel-ad5989a": "python",
        "YangXiaocui1215-GMP-d3cb04f": "python",
        "evalplus-evalplus-8b713cd": "python",
        "danilonumeroso-dar-64e8631": "python",
        "thismlguy-code-genie-58f789c": "python",
        "Cerlancism-faster-whisper-webui-884f5fd": "python",
        "snu-mllab-Efficient-CNN-Depth-Compression-2828ae8": "python",
        "leggedrobotics-rayen-2ac7086": "python",
        "chrisdewa-ardilla-312a373": "python",
        "blurgyy-jaxngp-adbe49e": "python",
        "gabacode-chatGPDP-4701532": "python",
        "dpasse-extr-f695d3c": "python",
        "continue-revolution-sd-webui-segment-anything-5df716b": "python",
        "BioMag-mtbi_meeg-b757aa8": "python",
        "lucmos-powermanim-1bcf62a": "python",
        "bufbuild-protovalidate-python-2eee9ba": "python",
        "sonic-net-sonic-platform-vpp-e8483f4": "python",
        "jborean93-dpapi-ng-57143c3": "python",
        "ZikangXiong-STL-Mobile-Robot-eecd396": "python",
        "gdsfactory-gf180-3407e7a": "python",
        "happen2me-subgraph-retrieval-toolkit-5655cb3": "python",
        "KTH-FlowAI-DeepReinforcementLearning_RayleighBenard2D_Control-d1a8dd6": "python",
        "operand-agency-07b1076": "python",
        "KimmiShi-TorchDistPackage-cc385cc": "python",
        "opticore-netbox-nornir-3cd275e": "python",
        "ironwoodcall-TagTracker-bb1e3d9": "python",
        "google-research-precondition-861d2da": "python",
        "pp-mo-ncdata-555ff35": "python",
        "Tlntin-ChatGLM2-6B-TensorRT-bd55117": "python",
        "canpool-QxRibbon-4bbd7f5": "python",
        "penvm-penvm-1846b0f": "python",
        "Jackory-RPBT-dbf3696": "python",
        "RobinSchfr-Lightning-control-for-Nanoleaf-dedf122": "python",
        "francoismdj-netbox-kea-dhcp-f53d9df": "python",
        "phac-nml-rebar-aef5b97": "python",
        "edarchimbaud-systematic-trading-a9fec02": "python",
        "yanqingmen-ask-api-69926aa": "python",
        "lxjmaster-ja3requests-90a33e6": "python",
        "dishb-hive-f0bf4b5": "python",
        "inWeb3ai-chatWeb3-cf1c933": "python",
        "kadirnar-segment-anything-video-039392c": "python",
        "voneiden-ocp-freecad-cam-4813dc9": "python",
        "LeoMo-27-FastAPI-template-f19c7aa": "python",
        "orsinium-labs-pytypest-80c40ed": "python",
        "devchat-ai-devchat-a8c53d2": "python",
        "ppoitier-sign-language-tools-46eadf9": "python",
        "hugofloresgarcia-vampnet-6de4eeb": "python",
        "Lightning-AI-lit-llama-da71ade": "python",
        "hq0709-Depth-NeuS-49d93d4": "python",
        "profcomff-social-api-d0b645b": "python",
        "dmlc-tl2cgen-9d135f4": "python",
        "chunbolang-R2Net-856e1cc": "python",
        "patio-python-patio-f65bd65": "python",
        "chrisli-kw-AutoTradingPlatform-e59fcfe": "python",
        "hbqjzx-wxxiaozhi-dfc4a65": "python",
        "RTIInternational-teehr-2bd727d": "python",
        "tongyuantongyu-cycmunet-3c34dbe": "python",
        "kaiko-ai-typedspark-cf5bc65": "python",
        "microsoft-gpt-review-b0b9842": "python",
        "Arbol-Project-gridded-etl-tools-320efc1": "python",
        "maxvanspengler-hyperbolic_learning_library-f6cfca3": "python",
        "N00Bception-AI-Powered-5G-OpenRAN-Optimizer-a0eac7b": "python",
        "EleutherAI-concept-erasure-0d4dbcb": "python",
        "yairl-r1xbot-5323f61": "python",
        "odtuyzt-chrono-kit-923b505": "python",
        "OpenGSL-OpenGSL-b40738c": "python",
        "entbappy-cnnClassifier-acadb8a": "python",
        "yoheinakajima-babyagi-d10b08c": "python",
        "Gage-Technologies-embedding-server-6b66d47": "python",
        "nccgroup-libslub-7732a54": "python",
        "SAIC-iSmart-API-saic-python-client-29b99ad": "python",
        "jannerm-ddpo-f0b6ca7": "python",
        "continuum-llms-chatgpt-memory-ee08ccc": "python",
        "gdsfactory-kplugins-7a5f7b4": "python",
        "wm-pxel-langchain-testbench-53701f9": "python",
        "ergodicio-adept-2c7eee5": "python",
        "DAMO-NLP-SG-MT-LLaMA-c72f7db": "python",
        "brdav-cma-fdae11a": "python",
        "tricktreat-DiffusionNER-cb095cd": "python",
        "drubinstein-python-compose-f3ab44c": "python",
        "Mikanwolfe-Kuro-55d0744": "python",
        "light1726-BetaVAE_VC-08902f2": "python",
        "NoFish-528-encodec-pytorch-9c2f4a0": "python",
        "opticore-netbox-celery-553cbe6": "python",
        "entangled-entangled.py-4dcbb63": "python",
        "clear-nus-NCDSSM-7212bba": "python",
        "Adam-Vandervorst-PyBHV-ff5dcca": "python",
        "melMass-comfy_mtb-3b07984": "python",
        "decodableco-dbt-decodable-8ef941c": "python",
        "mp3guy-SymE3-445731e": "python",
        "deadblue-py115-ecdcb93": "python",
        "liuzuxin-OSRL-6ede2c2": "python",
        "34j-boost-loss-ff08630": "python",
        "OSIPI-TF2.4_IVIM-MRI_CodeCollection-686d23e": "python",
        "edsaav-nail-64acdc6": "python",
        "AlphaDinosaur89-glang-de75a3e": "python",
        "congtuong-docile-44e4fce": "python",
        "david-stan-dagfed-chain-0a60a23": "python",
        "AlexGidiotis-gpt-light-ae75a5e": "python",
        "RobertoCorti-gptravel-bcf49dd": "python",
        "dichem-django-excel-report-686e1da": "python",
        "paulpanwang-Cas6D-245489d": "python",
        "sprite-neu-SPREAD-API-a2ee03a": "python",
        "apple-ml-tract-ad25296": "python",
        "cibere-kick.py-03541c0": "python",
        "CMU-MultiComp-Lab-CMU-MultimodalSDK-3e27d37": "python",
        "NKI-AI-STAPLER-bf072e9": "python",
        "chrisrude-oobabot-fa234d6": "python",
        "adrienbrignon-mkdocs-exporter-bdbd7b5": "python",
        "leonelhs-face-shine-8f21b90": "python",
        "tconbeer-textual-textarea-24fab5a": "python",
        "uezo-aiavatarkit-37d28f7": "python",
        "knrdl-acme-ca-server-53598ad": "python",
        "IntelLabs-GraVi-T-08d95be": "python",
        "AntonOsika-gpt-engineer-fc80507": "python",
        "doublewinter0-auto-dns-d9e3a40": "python",
        "yangalan123-Amortized-Interpretability-13e3500": "python",
        "google-lineax-4e8a44a": "python",
        "graphcore-research-unit-scaling-demo-9d9daed": "python",
        "IntelligenzaArtificiale-Free-Auto-GPT-095e991": "python",
        "iuiaoin-wechat-gptbot-b379085": "python",
        "JuniusLuo-VecLucene-8a47c91": "python",
        "eurobios-scb-acrocord-94aeb5e": "python",
        "piercefreeman-vectordb-orm-0b7fe7d": "python",
        "mlfoundations-dataset2metadata-a673a83": "python",
        "egrinstein-gnn_ssl-74c7b5a": "python",
        "bytewax-rt-embed-7069fc6": "python",
        "remixer-dec-botality-ii-f8402d5": "python",
        "somaonishi-MTR-33b87b3": "python",
        "pomponchik-instld-1df14ba": "python",
        "sweetice-PEER-CVPR23-142442f": "python",
        "janghyuk-choi-slot-attention-lightning-2993443": "python",
        "kyegomez-Blockwise-Parallel-Transformer-f849b04": "python",
        "blurry-dev-blurry-1d20aad": "python",
        "dmemsys-SMART-dc4de6f": "python",
        "stn-tap-jquants-336373c": "python",
        "Sygil-Dev-muse-maskgit-pytorch-7d7c00c": "python",
        "steklyashka33-Minecraft-Mod-Translator-92de64d": "python",
        "IBM-domain-adaptive-attribution-robustness-b4c2bee": "python",
        "questdb-questdb-connect-459ecb6": "python",
        "medley56-space_packet_parser-d94290c": "python",
        "dbt-labs-dbt-meshify-a11e507": "python",
        "ZJUM3-LLMEval_RCC-a731888": "python",
        "microsoft-seqrecord-55c8d91": "python",
        "uripeled2-llm-client-sdk-66af541": "python",
        "shug2k-content-review-tool-93305bb": "python",
        "SKbarbon-swoopyui-a4fb25d": "python",
        "Significant-Gravitas-Auto-GPT-Plugins-3975893": "python",
        "slewie-HypONIC-5b95063": "python",
        "Priesemann-Group-nninfo-8289154": "python",
        "crowdgames-sturgeon-pub-a235e6d": "python",
        "ches-001-metatune-278c315": "python",
        "wolfhoundgelert-xman-1da4d2d": "python",
        "deep-diver-PingPong-7ace26b": "python",
        "solo-spice-sospice-64c941b": "python",
        "scottjiao-SlotGAT_ICML23-4aa4583": "python",
        "MatteoSalvatori-INCE-23e589c": "python",
        "SolarisNeko-suger-python-67383eb": "python",
        "amd-Open-Field-Health-Check-415e8a6": "python",
        "lambrou-SemTerm-b57ef90": "python",
        "libsql-libsql-client-py-484c7d3": "python",
        "callowayproject-bump-my-version-0cf1cb5": "python",
        "ansys-pyaedt-toolkit-template-73b2fc9": "python",
        "JohnnyIrvin-shell-craft-26a7af7": "python",
        "eugenos-programos-Own-language-with-LLVM-lite-c8b9e08": "python",
        "utiasDSL-fmpc_socp-de13764": "python",
        "epfml-landmark-attention-111ee30": "python",
        "yuvalkirstain-PickScore-5fa69e8": "python",
        "xsfa-pointstorm-ede28ec": "python",
        "elementsinteractive-twyn-4517d87": "python",
        "kit-cel-mokka-8a555d9": "python",
        "hyp3rd-telegram-discord-bridge-24fa2fb": "python",
        "danyi1212-celery-insights-a742653": "python",
        "llmapi-io-llmapi-server-cdae9ca": "python",
        "satyapravin-Deribit-Option-Arb-c6fead7": "python",
        "anarchy-ai-LLM-VM-83da960": "python",
        "DFilyushin-habr-project-inn-0465f4f": "python",
        "Genentech-walk-jump-3cfaa37": "python",
        "teelinsan-parallel-decoding-b16a009": "python",
        "chatnoir-eu-web-content-extraction-benchmark-221b650": "python",
        "czczup-GPTrans-1f6f651": "python",
        "mihirh19-todo_web_app-fed9043": "python",
        "airdot-io-airdot-deployer-4897777": "python",
        "ycc140-fastapi_messaging-bed8c86": "python",
        "celluloseai-sdk-9bb71fb": "python",
        "lwb2099-stable_diffusion_pytorch-dbdb663": "python",
        "SEIAROTg-autobean-format-2a51179": "python",
        "ryongithub-GatedPromptTuning-1de14b5": "python",
        "20171130-llmux-249dcdb": "python",
        "run-llama-llama-lab-3364c9e": "python",
        "quarkslab-pastis-d790def": "python",
        "valentingol-cliconfig-c772180": "python",
        "davisyoshida-qax-34f0905": "python",
        "chunmeifeng-FedPR-f5c3e67": "python",
        "Mattie-chatsnack-94305b2": "python",
        "ycyy-faster-whisper-webui-fe432f8": "python",
        "mraniki-dxsp-71b0c1e": "python",
        "argus-hdps-rico-426daa0": "python",
        "FizzleDorf-AIT-ad34668": "python",
        "sebastienrousseau-pain001-86a271f": "python",
        "mecene-studio-debugGpt-20e9b61": "python",
        "nicolasebastianelli-speech-ai-323473b": "python",
        "kumitterer-matrix-gptbot-d2c6682": "python",
        "Facico-Chinese-Vicuna-1c4cbfc": "python",
        "wxian3-NeuroLens-380d68c": "python",
        "pimoroni-badger2040-24d6eb6": "python",
        "tmori-generative-agents-81cabfd": "python",
        "GChristensen-deepfloyd_if_lab-4644b93": "python",
        "esnya-lm-talkbot-f072b85": "python",
        "dory111111-Pengenuity-297d9ee": "python",
        "CassioML-cassio-7953897": "python",
        "thuliu-yt16-dualvector-e5ae56e": "python",
        "havenhq-haven-fa692f2": "python",
        "kaiokendev-superbig-be5500b": "python",
        "bond-anton-BDPotentiometer-872a7e2": "python",
        "gnbonney-SymLogos-08a26af": "python",
        "caniko-pydantic-numpy-abcfd59": "python",
        "jfc43-stratified-adv-rej-bfdc043": "python",
        "slonogram-slonogram-9f86552": "python",
        "AICPS-RS2G-b4e985f": "python",
        "LLukas22-llm-rs-python-90e5e70": "python",
        "DMSintalor-OJ-Be-f04ae6e": "python",
        "speedb-io-log-parser-d600b0e": "python",
        "axelmunch-laser-tag-38f6fc0": "python",
        "pawelkn-xapi-python-788a721": "python",
        "paulromano-endf-python-745bbb5": "python",
        "motherofcoconuts-async-dramatiq-b9512a1": "python",
        "LineIndent-material_design_flet-bca5bd8": "python",
        "slawekradzyminski-personal-ai-assistant-2736d10": "python",
        "janvarev-OneRingTranslator-e4dab8d": "python",
        "briandelmsft-STAT-Function-f91d421": "python",
        "tricktreat-PromptNER-3857235": "python",
        "PatrickKalkman-python-eda-e98886c": "python",
        "rosemary666-chatgpt-3adfb2d": "python",
        "mboot-github-WhoisDomain-0b5dbb3": "python",
        "Hxyou-IdealGPT-54f5acf": "python",
        "NREL-BuildingsBench-cc4b03d": "python",
        "kiran94-prfiesta-c37e012": "python",
        "yotakayama-STLCCP-edcfad4": "python",
        "meh9-game-of-life-8767f07": "python",
        "Kamilfo-Developer-alice-sleepy-helper-skill-febf9f7": "python",
        "javiber-scrat-748926a": "python",
        "datasig-ac-uk-RoughPy-fbd9016": "python",
        "alteryx-locust-grasshopper-632db06": "python",

        "AADevelops-JaGame-fc2ae51":"java",
         "aaron-ai-rocketmq-opentelemetry-f943317":"java",
         "achousa-telegram-gpt-bot-ff31db1":"java",
         "1754048656-FATJS-4b1e065":"java",
         "acikek-hazard-diamond-faf1ee8":"java",
         "20231-ifba-saj-ads-poo-blog-material-aula-7ef4df7":"java",
         "adryd325-sneaky-df32bca":"java",
         "akang943578-java-bard-api-7352c25":"java",
         "akshayp7-playwright-java-cucumber-f722d27":"java",
         "aliyun-alibabacloud-package-deployment-plugin-af7d0f8":"java",
        "aliyun-alibabacloud-push-reactnative-plugin-bf5b821": "java",
        "adorabled4-springboot-template-c06b07d": "java",
        "aliturgutbozkurt-city-application-23ee1fb": "java",
        "admin4j-admin4j-json-dedd7eb": "java",
        "AntChainOpenLab-AntChainBridgePluginServer-c6acccc": "java",
        "AOSPA-android_device_xiaomi_sm6225-common-0a9c912": "java",
        "aress31-burpgpt-79ea6b9": "java",
        "ArcanePlugins-PAPISigns-7a07a38": "java",
        "applejuiceyy-FiguraStockfish-9530a39": "java",
        "aserto-dev-aserto-java-8042222": "java",
        "apache-incubator-paimon-shade-bfc2f24": "java",
        "Big-billed-shark-fineely-config-6069a36": "java",
        "blessedmusicalturkeys-project-release-notes-d9120d6": "java",
        "aws-personalize-kafka-connector-cb28efc": "java",
        "Blamer-io-hub-33ef413": "java",
        "Big-billed-shark-fineely-log-a1bbea7": "java",
        "bouchraakl-LotMaster-Backend-eae3cc8": "java",
        "BNYMellon-graphql-kata-48706d4": "java",
        "burningtnt-SimpleWEBP-0bdd60c": "java",
        "brokiem-BedrockReplay-adc9701": "java",
        "ckmu32-Bot-Checker-c582a74": "java",
        "camunda-community-hub-camunda-modeler-template-generator-155826e": "java",
        "Col-E-TreeMapFX-226ef8c": "java",
        "conena-therlock-0000c84": "java",
        "coralblocks-CoralME-ec2b736": "java",
        "carlrobertoh-openai-client-7a73e99": "java",
        "CHRISL7-android_device_xiaomi_sm6225-common-ed8a1e0": "java",
        "Cosium-hypermedia-irl-presentation-0269869": "java",
        "CounterpointConsulting-agency-5891951": "java",
        "CrackedPolishedBlackstoneBricksMC-minivan-4e8aa7f": "java",
        "Cristike-AquaInput-c8e8cb9": "java",
        "criccomini-twister-4e63c85": "java",
        "Dalaranian-GodLifeDiary-4811d09": "java",
        "czqclm-aicq-open-ai-api-a7b76bc": "java",
        "DaPutzy-intellij-sops-plugin-d164a55": "java",
        "dannegm-BlockEntities-7256b11": "java",
        "danielsobrado-edgar-cik-cusip-ticker-sector-service-745194d": "java",
        "darkevilmac-FedUp-d741f7d": "java",
        "DarrenTianYe-android_dynamic_load_so-7a70027": "java",
        "decodableco-decodable-pipeline-sdk-af78b8a": "java",
        "dd8023dd-chatgpt-web-server-7bd2f76": "java",
        "deeround-jdbc-plus-a0dcdfd": "java",
        "DennisRippinger-cru-6558fde": "java",
        "dataplatform-lab-deltastore-017c850": "java",
        "digitalinnovationone-spring-boot-3-rest-api-template-55aab88": "java",
        "DJ-Raven-swing-toast-notifications-4c7978a": "java",
        "dmitriyvolk-redrover-draw-b9b5e7d": "java",
        "deshaw-pjrmi-4212d0a": "java",
        "EASYHOME-DOORVERSE-easyhome-springcloud-gray-faee63a": "java",
        "EMCProtocol-dev-emc_java_sdk-82e4b0e": "java",
        "Dzen-Platform-kafka-connect-ytsaurus-518a6b8": "java",
        "enzogebauer-duckling_animes-a00d26d": "java",
        "ericblue-ChatGPT-Twilio-Java-e88e8a0": "java",
        "enzulode-networking-library-dfda932": "java",
        "dudu-Dev0-WearGPT-2a5428e": "java",
        "EricTra-University_Admission-18ace1f": "java",
        "EricTra-University-Admission-Final-Version-944c929": "java",
        "Estructura-de-Datos-2223-3-S2-Ejercicios-en-clase-c874295": "java",
        "felldo-JEmoji-a3e9bdb": "java",
        "EvilMindDevs-HMS-UnrealEngine-Plugin-9783dfb": "java",
        "filipe-oliv95-TrabalhoBancoPOO_Grupo7-e86048d": "java",
        "FlorianMichael-CheckHost4J-b580631": "java",
        "FlorianMichael-Classic4J-6e0a2ff": "java",
        "FitzHastings-DownfallEAM-f1a06ef": "java",
        "florianpirchner-java-gpt-commands-8f92fe9": "java",
        "FlyJingFish-TitleBar-24dc5b6": "java",
        "Francisco-Jean-API-BRINQUEDOMANIA-0013ce2": "java",
        "flytegg-ls-projects-d0e70ee": "java",
        "frazik-main-AmplifyGPT-ac49c2a": "java",
        "frank89722-Staaaaaaaaaaaack-65a0402": "java",
        "froobynooby-SeeMore-8347860": "java",
        "george-java-native-obfuscation-study-76ae062": "java",
        "germanosin-kafka-leader-election-bfac281": "java",
        "gerasiovM-ParticleAPI-376987e": "java",
        "Fyustorm-mInetiface-6a598f5": "java",
        "GoogleCloudPlatform-app-large-data-sharing-java-fd21141": "java",
        "google-cql-on-beam-82f1c68": "java",
        "grcreutzberg-dice-api-d58bb3d": "java",
        "GeyserMC-Hydraulic-80cb8ab": "java",
        "heartalborada-del-newbingAPI-1102bfb": "java",
        "gtomitsuka-rn-phone-number-input-2f2e43b": "java",
        "GrapheneOS-Archive-platform_packages_apps_Traceur-2e6c52a": "java",
        "HiWord9-RPRenames-fabric-046f2f8": "java",
        "HO-Artisan-RecipeInProgramming-09cc072": "java",
        "hiparker-lint-rpc-framework-e64aac0": "java",
        "Hypsster-hUtils-d265b4f": "java",
        "iAldrich23xX-libasynWebhook-52a1773": "java",
        "Jan222333444-EasyContactForms-a2cf723": "java",
        "jaredlll08-searchables-2cb19ff": "java",
        "jcsirot-dagger-java-sdk-366c947": "java",
        "JesseTzh-stable-diffusion-java-20f5a07": "java",
        "iamr0s-Dhizuku-API-009d517": "java",
        "k0hlii-reservationsystem-cf95137": "java",
        "ka0un-DiscordLeaderboards-ffaaf38": "java",
        "jaketracey-opax-44a71f1": "java",
        "keith2018-SharedTexture-1995d41": "java",
        "Khajiitos-ServerCountryFlags-e056c80": "java",
        "Konloch-HTTPdLib-b7a1e2e": "java",
        "kingschan1204-easycrawl-a5aade8": "java",
        "klepto-unreflect-a818c39": "java",
        "Kyant0-m3color-eaa1e34": "java",
        "making-webhook-verifier-edb251a": "java",
        "limebrew-org-xpense-service-54b5f64": "java",
        "l3r8yJ-milan-9813ad6": "java",
        "lihangfu-copilot-server-41b259b": "java",
        "matheusgmello-dslist-backend-4347223": "java",
        "landonjw-GooeyUI-e1b3d47": "java",
        "lvoegl-chatters-api-da3fa86": "java",
        "matheusgmello-workshop-springboot3-jpa-16e84f3": "java",
        "MERVECETIN1929-Turkcell-Homework1-bdf94f0": "java",
        "MCTeamPotato-MineGPT-00b1415": "java",
        "mexicanminion-DND_Minecraft-5e7753b": "java",
        "MichaelsPlayground-NfcHceNdefEmulator-fa2ca23": "java",
        "mineblock11-SimpleBroadcast-47157bd": "java",
        "Mikhail2048-properties-maven-plugin-2ab2e8e": "java",
        "microsoft-lst-bench-96ac3ca": "java",
        "minivv-gpt-copilot-b16ad12": "java",
        "ministryofjustice-laa-dces-report-service-ac8db88": "java",
        "MuhammetTahaDemiryol-Turkcell-Homework-39026c6": "java",
        "NBXXF-XXFi18nPlugin-065127d": "java",
        "nando-cezar-design-patterns-music-19ebdb3": "java",
        "MrMystery10-del-Slirik-b1c532b": "java",
        "mitrofmep-JBimer-fd7a0ba": "java",
        "MyWorldLLC-Buoy-c7d77a1": "java",
        "NeoProtect-NeoPlugin-a71f673": "java",
        "Neural-Enigma-Art-sales-Spring-Boot-57a8036": "java",
        "Neural-Enigma-Ecommerce-Sales-Dashboard-Spring-0130f60": "java",
        "newhoo-RestfulBox-Solon-8533971": "java",
        "Neural-Enigma-RestaurantManagement-Spring-Boot-Java-086881a": "java",
        "nielsbasjes-conventional-commits-maven-release-151e36d": "java",
        "noQ-sweden-noq-7f5b8d1": "java",
        "objectionary-flatty-688a3da": "java",
        "open-dingtalk-dingtalk-stream-sdk-java-quick-start-bb889b2": "java",
        "onebeastchris-visitors-abf022e": "java",
        "Nova-Committee-Flotage-Fabric-6478e2a": "java",
        "OrangoMango-Chess-c4bd8f5": "java",
        "nsce9806q-k-spring-security-8e88d3d": "java",
        "No-Country-c11-19-m-javareact-cf62efa": "java",
        "openquartz-spring-cloud-feign-plugin-bdc8753": "java",
        "opendatadiscovery-oddrn-specification-0d29a61": "java",
        "OseiasYC-SpringBook-76f673d": "java",
        "Ozeitis-Enhancing-7c0fc20": "java",
        "OSUSecLab-QtRE-e0bcde6": "java",
        "OpenQuickJS-quickjs-android-0319d76": "java",
        "paulgutv-currency-converter-d95cf08": "java",
        "OseiasYC-SpringBook-v3-dcc7eb1": "java",
        "pannous-jini-plugin-0b2b57a": "java",
        "platzi-curso-java-spring-data-jpa-ab96de0": "java",
        "PlaytikaOSS-maven-plugins-1781693": "java",
        "PEC-CSS-acm-website-backend-b92d4e4": "java",
        "platzi-curso-java-spring-security-c81e819": "java",
        "piiano-vault-java-8a95eec": "java",
        "PixelExperience-Devices-device_xiaomi_sm6225-common-ac5a1ea": "java",
        "PolyRocketMatt-Reflow-8aee734": "java",
        "PortingLab-ForgedLoaderAPI-610f27f": "java",
        "polesmih-BuisnessDocumentForms_bot-6fa1315": "java",
        "pxpy-jump-to-controller-927384c": "java",
        "PyAlaie-spotify-408f7ba": "java",
        "powercasgamer-libby-c9b0491": "java",
        "rdelfino-simple-api-gateway-client-27b5fb2": "java",
        "RealAlphaUA-Skript-a61d959": "java",
        "Rabby033-Online-Course-Management-System-4258105": "java",
        "qjc1024join-midjourney-bot-api-deac0e7": "java",
        "quarkiverse-quarkus-bucket4j-a9c07c9": "java",
        "Riicarus-SaggioTask-5f8b53a": "java",
        "samokat-oss-performance-mockserver-3b28165": "java",
        "sammwyy-MCDeploy-e30a9a5": "java",
        "rodrigolmacedo-app-consumo-eletro-682f95a": "java",
        "SadGhostYT-Espresso-f09023a": "java",
        "Silence1017-EtherWatchdog_Server-a419615": "java",
        "RHEcosystemAppEng-exhort-747acb8": "java",
        "SHsuperCM-Stonecutter-937eca5": "java",
        "RebieKong-file-bridge-c3b4855": "java",
        "skku-daniilkim-skku_swe300242_team1-7b9f8fc": "java",
        "SocketC0nnection-JVA-83eab43": "java",
        "skfl-andersen-task-ccf50ec": "java",
        "souslesens-jowl-0fd545e": "java",
        "soujava-pom-editor-maven-plugin-0caa82a": "java",
        "solodroidx-multi-ads-sdk-4f23cdf": "java",
        "storycraft-serde-mc-757a9e4": "java",
        "sssdgithub-ddns4j-eadfbee": "java",
        "strimzi-strimzi-mqtt-bridge-cb0a4b8": "java",
        "stupdit1t-jackson-expand-boot-starter-b492b74": "java",
        "tati2002med-dashboarder-spring-mvc-api-61d5a07": "java",
        "tballison-commoncrawl-fetcher-lite-2c106d1": "java",
        "suimz-chatgpt-web-java-37a4c63": "java",
        "TechnicallyCoded-FoliaLib-8f9f24f": "java",
        "telekom-phonenumber-normalizer-9a1b7ad": "java",
        "TheHamester-HitIndicator-261bcb9": "java",
        "Sparks-and-Rotation-woodencog-bb3d3ef": "java",
        "terrarium-earth-Hermes-00fce0f": "java",
        "tcheeric-nostr-bot-18de389": "java",
        "TheKaVu-GameAPI-acf2cb4": "java",
        "TosoxDev-Tosox-Jr-362c6b5": "java",
        "tomridder-ImitateTikTokPlayer-d6d79c5": "java",
        "TrumanDu-the-force-ae8d6ed": "java",
        "Tripli33-airlines-2e5df64": "java",
        "ThomasMiz-springmvc-guide-d59137b": "java",
        "unnamed-creative-faces-21686d7": "java",
        "unblu-ucascade-fa85c39": "java",
        "upe-garanhuns-psw-2023.1-f069bf0": "java",
        "vikastripathi707-BookStoreApp-8551fcb": "java",
        "tylix-group-app-ca2c661": "java",
        "wesleyfsousa01-workshop-spring-boot-mongoDB-2ed3895": "java",
        "vudangngoc-janus-java-client-b9f0b37": "java",
        "volodya-lombrozo-oop-statistics-filter-c298155": "java",
        "wandererex-wormhole-a724af4": "java",
        "vsantos1-java-microframework-web-a4674ab": "java",
        "wenqiglantz-rds-hybrid-multitenancy-ad04a23": "java",
        "Western-parotia-BookViewProject-1727e80": "java",
        "Western-parotia-Net-accd348": "java",
        "WHyxrs-DesignMode-5af30b7": "java",
        "XenyriaNET-xeem-b635ea0": "java",
        "wisp-forest-lavender-md-87862e2": "java",
        "xTracr-RealCamera-7675633": "java",
        "xizixuejie-canal-spring-849e5c4": "java",
        "xuanwenchao-Metaphor-0176f35": "java",
        "yonetmen-ExceptionAI-287a40d": "java",
        "yakampe-TDDPredict-d2aa06b": "java",
        "yeliheng-EventBus-50cbec9": "java",
        "yhzdys-litchi-71b57c8": "java",
        "Western-parotia-EaseLint-a9e3988": "java",
        "YunaBraska-github-workflow-plugin-a13028a": "java",
        "zqzq3-chatgpt-botforQQ-c64fc49": "java",
        "zymzrr-hand2number-fe6fd4b": "java",
        "zero-hua-geekhub-server-3919d7b": "java",
        "zhongjinggz-geekdemo-4cec99e": "java",
        "zhouwentong1993-jimu-bae2d48": "java",
        "ZhongFuCheng3y-hades-dfd5ea1": "java",

        "itlemon_chatgpt4j": "java",
         "Aelysium-Group_rusty-connector": "java",
         "neoforged_NeoGradle": "java",
         "mybatis-flex_mybatis-flex": "java",
         "Guiqu1aixi_rocketmq": "java",
         "SimonHalvdansson_Harmonic-HN": "java",
         "Open-DBT_open-dbt": "java",
         "QuasiStellar_custom-pixel-dungeon": "java",
         "gentics_cms-oss": "java",
         "FloatingPoint-MC_MIN": "java",
    }


class CodexTokenizer:
    def __init__(self):
        self.tokenizer = tiktoken.encoding_for_model("gpt-3.5-turbo-instruct")
        # self.tokenizer = tiktoken.get_encoding("p50k_base")

    def tokenize(self, text):
        # return self.tokenizer.encode(text)
        return self.tokenizer.encode(text, allowed_special={'<|endoftext|>'})

    def decode(self, token_ids):
        return self.tokenizer.decode(token_ids)


class CodeGenTokenizer:
    def __init__(self, tokenizer):
        self.tokenizer = tokenizer

    def tokenize(self, text):
        return self.tokenizer.encode(text)

    def decode(self, token_ids):
        return self.tokenizer.decode(token_ids)


def iterate_repository_file(base_dir, repo):
    if CONSTANTS.repos_language[repo] == "python":
        pattern = os.path.join(f'{base_dir}/{repo}', "**", f"*.py")
    elif CONSTANTS.repos_language[repo] == "java":
        pattern = os.path.join(f'{base_dir}/{repo}', "**", f"*.java")
    else:
        raise NotImplementedError
    files = glob.glob(pattern, recursive=True)
    return files


def iterate_repository_json_file(base_dir, repo):
    pattern = os.path.join(f'{base_dir}/{repo}', "**", "*.json")
    files = glob.glob(pattern, recursive=True)
    return files


def make_needed_dir(file_path):
    dir_path = os.path.dirname(file_path)
    if not os.path.exists(dir_path):
        os.makedirs(dir_path)
    return


def load_pickle(fname):
    with open(fname, 'rb') as f:
        return pickle.load(f)


def set_default(obj):
    if isinstance(obj, set):
        return list(obj)
    raise TypeError


def dump_jsonl(obj, fname):
    with open(fname, 'w', encoding='utf8') as f:
        for item in obj:
            f.write(json.dumps(item, default=set_default) + '\n')


def load_jsonl(fname):
    with open(fname, 'r', encoding='utf8') as f:
        lines = []
        for line in f:
            try:
                lines.append(json.loads(line))
            except Exception as e:
                line = line.strip()
                lines.append(json.loads(line))
        return lines


def graph_to_json(obj: nx.MultiDiGraph):
    return json.dumps(json_graph.node_link_data(obj), default=set_default)


def json_to_graph(json_format):
    graph_js = json.loads(json_format)
    graph = json_graph.node_link_graph(graph_js)
    return graph


def tokenize(code):
    tokenizer = CodexTokenizer()
    return tokenizer.tokenize(code)
