
# https://github.com/xinyandai/gradient-quantization

import torch

class NoCompressor(object):
    def __init__(self, size, shape, args):
        self.cuda = not args.no_cuda
        self.size = size
        self.shape = shape
        self.users = 1


    def compress(self, vec):
        vec = vec.view(self.users, -1)
        ind1 = torch.ones_like(vec)
        return vec*ind1

    def decompress(self, signature):
        return signature.view(self.shape)