#!/bin/bash
dataset='cifar10'
pr=0.4 # 0.0/0.4/0.6/-1.0
nr=0.0 # 0.0
ir=0.0 # 0.0/0.01/0.02
tau=0.6 # 0.2 0.4 0.6
k=150 # 5 50 150

model_name='blip2' # blip2/clip/ablef/resnet18_c/resnet18_i/resne18_s
model_type='pretrain' # blip2 pretrain; albef base; clip ViT-B-32
seed=7438

exp_name='test'

time=$(date +%F)
file_path="./output_log/${dataset}/${time}_pr=${pr}_nr=${nr}_ir=${ir}_tau=${tau}_k=${k}_model=${model_name}_seed=${seed}_${exp_name}.log"


CUDA_VISIBLE_DEVICES=$1 nohup python -u clp.py --dataset ${dataset} --partial_rate ${pr} --noise_rate ${nr} --imb_rate ${ir} --epochs 1 --k ${k} --tau ${tau} --model_name ${model_name} --model_type ${model_type} --seed ${seed} --gpu 0 --save > ${file_path} 2>&1 &

