# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""RNA Constants."""
import ml_collections

RESD_NAMES = ['A', 'G', 'U', 'C']
ATOM_NUM_MAX = 23
N_ANGLS_PER_RESD_MAX = 6
ATOM_NAMES_PER_RESD = {
    'A': ["C4'", "C1'", 'N9', "C2'", "C3'", "C5'", "O2'", "O3'", "O4'", 'N1', 'C2', 'N3', 'C4', 'C5', 'C6', 'N6', 'N7', 'C8', "O5'", 'P', 'OP1', 'OP2'],
    'G': ["C4'", "C1'", 'N9', "C2'", "C3'", "C5'", "O2'", "O3'", "O4'", 'N1', 'N2', 'N3', 'C2', 'C4', 'C5', 'C6', 'N7', 'C8', 'O6', "O5'", 'P', 'OP1', 'OP2'],
    'U': ["C4'", "C1'", 'N1', "C2'", "C3'", "C5'", "O2'", "O3'", "O4'", 'C2', 'O2', 'N3', 'C4', 'O4', 'C5', 'C6', "O5'", 'P', 'OP1', 'OP2'],
    'C': ["C4'", "C1'", 'N1', "C2'", "C3'", "C5'", "O2'", "O3'", "O4'", 'C2', 'O2', 'N3', 'C4', 'N4', 'C5', 'C6', "O5'", 'P', 'OP1', 'OP2'],
}
# atom coordinate information
ATOM_INFOS_PER_RESD = {
    'A': [
        ["C4'", 0, (-1.276165, 1.959880, -0.000000)],
        ["C1'", 0, (0.000000, 0.000000, 0.000000)],
        ["N9", 0, (1.475205, -0.000001, -0.000000)],
        ["C4", 3, (0.807920, 1.111760, 0.000005)],
        ["N1", 3, (2.758503, 2.897898, 0.001554)],
        ["C2", 3, (1.460024, 3.206003, -0.011345)],
        ["N3", 3, (0.411131, 2.394717, -0.011532)],
        ["C5", 3, (2.096065, 0.639899, 0.008968)],
        ["C6", 3, (3.118781, 1.602769, 0.010104)],
        ["N6", 3, (4.419309, 1.291705, 0.019290)],
        ["N7", 3, (2.111291, -0.746117, 0.018068)],
        ["C8", 3, (0.849659, -1.070600, 0.010794)],
        ["C5'", 4, (1.052078, 1.092224, -0.000001)],
        ["C2'", 4, (-1.872561, -0.883347, -1.102487)],
        ["C3'", 4, (-0.472814, -0.446904, -1.365087)],
        ["O4'", 4, (-1.190606, 0.491559, 0.645394)],
        ["O2'", 4, (-1.903518, -2.126949, -0.665019)],
        ["O3'", 4, (0.263952, -1.439737, -1.802108)],
        ["O5'", 5, (0.496598, 1.344835, 0.000001)],
        ["P",   6, (0.792605, 1.387161, -0.000169)],
        ["OP1", 6, (0.471023, 2.128497, 0.712373)],
        ["OP2", 6, (1.873119, 1.330707, 0.059336)],
    ],

    'G': [
        ["C4'", 0, (-1.290627, 1.934672, -0.000000)],
        ["C1'", 0, (0.000000, 0.000000, 0.000000)],
        ["N9", 0, (1.468708, -0.000001, -0.000000)],
        ["C4", 3, (0.810758, 1.110910, 0.000003)],
        ["N1", 3, (2.729542, 2.870383, -0.004097)],
        ["N2", 3, (1.177098, 4.564092, 0.000022)],
        ["N3", 3, (0.396910, 2.396043, 0.002390)],
        ["C2", 3, (1.411283, 3.249483, -0.000035)],
        ["C5", 3, (2.100985, 0.632358, -0.004182)],
        ["C6", 3, (3.176985, 1.556655, -0.005911)],
        ["N7", 3, (2.108585, -0.756168, -0.007856)],
        ["C8", 3, (0.845640, -1.077105, -0.005711)],
        ["O6", 3, (4.385028, 1.323046, -0.008872)],
        ["C5'", 4, (1.060114, 1.070924, -0.000001)],
        ["C2'", 4, (-1.870486, -0.840342, -1.120496)],
        ["C3'", 4, (-0.472286, -0.429812, -1.370752)],
        ["O4'", 4, (-1.185897, 0.480439, 0.644563)],
        ["O2'", 4, (-1.940520, -2.089699, -0.772286)],
        ["O3'", 4, (0.283446, -1.465567, -1.864625)],
        ["O5'", 5, (0.503097, 1.336331, 0.000002)],
        ["P",   6, (0.814429, 1.374324, 0.000002)],
        ["OP1", 6, (0.568883, 2.061261, 0.481115)],
        ["OP2", 6, (1.672007, 1.409980, 0.122345)],

    ],
    'U': [
        ["C4'", 0, (-1.350570, 1.894768, -0.000000)],
        ["C1'", 0, (0.000000, 0.000000, 0.000000)],
        ["N1", 0, (1.520579, -0.000001, -0.000000)],
        ["C2", 3, (0.638019, 1.227940, 0.000004)],
        ["O2", 3, (0.076077, 2.277670, -0.006829)],
        ["N3", 3, (1.961198, 1.192599, 0.008837)],
        ["C4", 3, (2.696898, 0.071705, 0.015805)],
        ["O4", 3, (3.877673, 0.187693, 0.027359)],
        ["C5", 3, (1.967988, -1.162564, 0.010670)],
        ["C6", 3, (0.675351, -1.159303, 0.003821)],
        ["C5'", 4, (1.039819, 1.089789, -0.000002)],
        ["C2'", 4, (-1.876250, -0.753623, -1.160505)],
        ["C3'", 4, (-0.471871, -0.422424, -1.376286)],
        ["O4'", 4, (-1.186856, 0.459930, 0.660486)],
        ["O2'", 4, (-2.018161, -1.969474, -0.928107)],
        ["O3'", 4, (0.226097, -1.493296, -1.840805)],
        ["O5'", 5, (0.501982, 1.337641, -0.000000)],
        ["P",   6, (0.816116, 1.371327, 0.000005)],
        ["OP1", 6, (0.539718, 2.076826, 0.553216)],
        ["OP2", 6, (1.746668, 1.365949, 0.098877)],

    ],
    'C': [
        ["C4'", 0, (-1.317305, 1.922806, -0.000000)],
        ["C1'", 0, (0.000000, 0.000000, 0.000000)],
        ["N1", 0, (1.478102, -0.000001, -0.000000)],
        ["C2", 3, (0.664963, 1.227037, -0.000001)],
        ["O2", 3, (0.012728, 2.274666, -0.004938)],
        ["N3", 3, (2.019217, 1.239853, 0.004528)],
        ["C4", 3, (2.703047, 0.095194, 0.007302)],
        ["N4", 3, (4.032683, 0.156398, 0.015365)],
        ["C5", 3, (2.045381, -1.169470, 0.005066)],
        ["C6", 3, (0.704879, -1.170234, 0.001044)],
        ["C5'", 4, (1.069742, 1.064466, -0.000001)],
        ["C2'", 4, (-1.871240, -0.862669, -1.112873)],
        ["C3'", 4, (-0.471328, -0.429849, -1.368867)],
        ["O4'", 4, (-1.185353, 0.488814, 0.640954)],
        ["O2'", 4, (-1.924026, -2.126406, -0.733156)],
        ["O3'", 4, (0.305207, -1.461927, -1.871044)],
        ["O5'", 5, (0.506114, 1.336065, -0.000000)],
        ["P",   6, (0.820772, 1.369937, 0.000001)],
        ["OP1", 6, (0.471030, 2.122183, 0.580409)],
        ["OP2", 6, (1.828789, 1.318792, 0.142234)],

    ],
}
# torsion angle information for each residue type (name, symmetric or not, and atom names)
ANGL_INFOS_PER_RESD = { # order matters
    'A': [
        ['angl_0', False, ["C4'", "C1'", 'N9', "C4"]],
        ['angl_1', False, ['N9',  "C1'", "C4'", "C5'"]],
        ['angl_2', False, ["C1'", "C4'", "C5'", "O5'"]],
        ['angl_3', False, ["C4'", "C5'", "O5'", "P"]],
    ],
    'G': [
        ['angl_0', False, ["C4'", "C1'", 'N9',  "C4"]],
        ['angl_1', False, ['N9',  "C1'", "C4'", "C5'"]],
        ['angl_2', False, ["C1'", "C4'", "C5'", "O5'"]],
        ['angl_3', False, ["C4'", "C5'", "O5'", "P"]],
    ],
    'U': [
        ['angl_0', False, ["C4'", "C1'", 'N1',  "C2"]],
        ['angl_1', False, ['N1',  "C1'", "C4'", "C5'"]],
        ['angl_2', False, ["C1'", "C4'", "C5'", "O5'"]],
        ['angl_3', False, ["C4'", "C5'", "O5'", "P"]],
    ],
    'C': [
        ['angl_0', False, ["C4'", "C1'", 'N1',  "C2"]],
        ['angl_1', False, ['N1',  "C1'", "C4'", "C5'"]],
        ['angl_2', False, ["C1'", "C4'", "C5'", "O5'"]],
        ['angl_3', False, ["C4'", "C5'", "O5'", "P"]],
    ],
}

RNA_CONSTANTS =  ml_collections.ConfigDict({
        'RESD_NAMES': RESD_NAMES,
        'ATOM_NUM_MAX': ATOM_NUM_MAX,
        'ATOM_INFOS_PER_RESD': ATOM_INFOS_PER_RESD,
        'ATOM_NAMES_PER_RESD': ATOM_NAMES_PER_RESD,
        'N_ANGLS_PER_RESD_MAX': N_ANGLS_PER_RESD_MAX,
        'ANGL_INFOS_PER_RESD': ANGL_INFOS_PER_RESD,
    }
)


