import sys
import os

# Add project root directory to sys.path
project_root = os.path.abspath(os.path.join(os.path.dirname(__file__), "..", ".."))
sys.path.append(project_root)
from OceanGym.prompt.format import prompt_template
from OceanGym.utils.image_process import image_path_to_base64
from OceanGym.utils.config_process import load_config

# Load YAML configuration file
config = load_config()
base_path = config["global"]["base_path"]
# Get target object image path
target_item_image_path = base_path+"\\pic\\task5.png"

# Convert image to Base64 encoding
base64_image_data = image_path_to_base64(target_item_image_path)

# Define variables (excluding location and camera_name)
variables = {
    "target_item": "Electrical boxes",
    "target_item_image": base64_image_data,
    "target_item_description": "A Electrical boxes, usually found on the seabed near underwater pipelines",
    "task_description": "Find the electrical boxes and report its exact location to the user",
    "another_target_photo": None
}

# Format the prompt
formatted_prompt = prompt_template.format(**variables)


# Target coordinates: -71 151 -53