#!/bin/bash
source /opt/rh/devtoolset-10/enable

method_name="$1"
experiment_name="$2"
behaviors_path="$3"
save_dir="$4"
start_idx="$5"
end_idx="$6"
behavior_ids_subset="$7"
run_id="$8"
overwrite="$9"
verbose="${10}"

echo "method_name=$method_name"
echo "experiment_name=$experiment_name"
echo "behaviors_path=$behaviors_path"
echo "save_dir=$save_dir"
echo "start_idx=$start_idx"
echo "end_idx=$end_idx"
echo "behavior_ids_subset=$behavior_ids_subset"
echo "run_id=$run_id"
echo "overwrite=$overwrite"
echo "verbose=$verbose"

# Construct the base command
cmd="python -u generate_test_cases.py \
    --method_name $method_name \
    --experiment_name $experiment_name \
    --behaviors_path $behaviors_path \
    --save_dir $save_dir"

# Check if start_idx is provided and not empty
if [ ! -z "$start_idx" ]; then
    cmd="$cmd --behavior_start_idx $start_idx"
fi
# Check if end_idx is provided and not empty
if [ ! -z "$end_idx" ]; then
    cmd="$cmd --behavior_end_idx $end_idx"
fi
# Check if behavior_ids_subset is provided and not empty
if [ ! -z "$behavior_ids_subset" ]; then
    cmd="$cmd --behavior_ids_subset $behavior_ids_subset"
fi
# Check if run_id is provided and not empty
if [ ! -z "$run_id" ]; then
    cmd="$cmd --run_id $run_id"
fi
# Check if overwrite is provided and equals "True"
if [[ ! -z "$overwrite" && "$overwrite" == "True" ]]; then
    cmd="$cmd --overwrite"
fi
# Check if verbose is provided and equals "True"
if [[ ! -z "$verbose" && "$verbose" == "True" ]]; then
    cmd="$cmd --verbose"
fi

# Execute the command
eval $cmd
