**Directories**  

$\bullet$ sgf/: This directory contains text files where each file represents a game board state. The files record the positions of all the stones on the board.  

$\bullet$ sgf_label/: In this directory, each text file corresponds to a game board and contains annotations for the positions of 10 selected stones.
<br>

**Katago engine**

$\bullet$ katago: This is the executable file for the KataGo engine.
<br>

**python files**

$\bullet$ generate_reward_mean.py: compute $a_k$, $k \in \{ -\frac{n}{2},-\frac{n}{2}+1,...,\frac{n}{2} \}$.

$\bullet$ generate_rewards.py: For each board, compute $\forall T \subseteq N, v(\boldsymbol{x}_T)$

$\bullet$ generate_masks.py: (pqa)For each board, compute initial $I_{\text{and}}(S)$ and $I_{\text{or}}(S)$, subject to $u(x_T)$, according to Equation (1) and Equation (3).

$\bullet$ generate_masks_pq.py: (pqa)For each board, iteratively update parameters $a_k(k \in \{ -\frac{n}{2},-\frac{n}{2}+1,...,\frac{n}{2} \}), p_T(T \subseteq N), q_T(T \subseteq N)$ via Equantion (6).

steps: generate_reward_mean.py --> generate_rewards.py --> generate_masks.py --> generate_masks_pq.py 
<br>

$\bullet$ analysis_importance.py: For each board, compute $\forall T \subseteq N, \varphi(T)$.

$\bullet$ chosen_concept.py: Determine a set of salient interaction primitives $\Omega_{\text{salient}} = \{S: \vert I(S)\vert > \xi \}$, where $\xi=0.15\cdot \max_S \vert I(S)\vert$. 

$\bullet$ find_coalition.py: Manually annotate 50 common coalitions $T$ based on interaction primitives $\Omega_{\text{salient}}$.

$\bullet$ phiS_chosen_concept.py: Compute coalition attributions $\varphi(T)$ for each annotated coalition $T$​.

$\bullet$ main_board_background_paper.py: For each borad, plot the anaotated coalitions.

steps: analysis_importance.py --> chosen_concept.py --> find_coalition.py --> phiS_chosen_concept.py --> main_board_background_paper.py
<br>

$\bullet$ generate_masks_ori.py: (pq)For each board, compute initial $I_{\text{and}}(S)$ and $I_{\text{or}}(S)$, subject to $v(x_T)$, according to Equation (1) and Equation (3). 

$\bullet$ generate_masks_pq_ori.py: (pq)For each board,  iteratively update parameters $p_T(T \subseteq N), q_T(T \subseteq N)$ via Equantion (4).

$\bullet$ analysis_andor_strength_paper.py: compare the interaction effect of high-order interactions get from Equation (4) and Equation (6)

steps: generate_masks_ori.py --> generate_masks_ori.py --> analysis_andor_strength_paper.py
