# Evaluating Agents without Rewards

This repository contains the associated code for our paper, Evaluating Agents without Rewards.

## Setup

To install all dependencies with conda:
```
conda create -y -n agent-eval python=3.7
conda activate agent-eval
conda install -y imageio numpy opencv scipy tensorflow=2.1
conda install -y -c conda-forge sparse
```

## Loading and preprocessing

We record data for all agents using the wrapper in `collect_gym_dataset.py`, and then convert them to grayscale and downscale them using `downscale_and_mp4.py`. Other loading and preprocessing code is in `load_data.py`. Code for generating cooccurrence tensors from the preprocessed data is in `create_cooccurrence_tensor.py`.

## Task-agnostic metrics

Code for curiosity is in `curiosity.py`, empowerment is in `empowerment.py`, and information gain is in `infogain.py`.

We provide one example cooccurrence tensor on which to run our code: `montezuma_no_op_tensor.pkl`. Cooccurrence tensors for other agents are not included, as they exceed 100MB. You can compute the three task-agnostic metrics on this tensor using:
```
./curiosity.py montezuma_no_op_tensor.pkl
./empowerment.py montezuma_no_op_tensor.pkl
./infogain.py montezuma_no_op_tensor.pkl
```

## Human similarity

Code for loading the Atari-HEAD dataset is in `human_load.py`, and human similarity calculation is in `human_similarity.py`.
