#!/usr/bin/env python3
"""Compute human similarity given a human and agent matrix."""

import pickle
import sys

# Calculate the total occurrences of each observation and each observation pair for the human and agent (using a list for total occurrences so it is iterated by reference)
human_obs = set()
human_data = (sys.argv[1], human_obs)
agent_obs = set()
agent_data = (sys.argv[2], agent_obs)
for matrix_path, obs_set in [human_data, agent_data]:
    # Load the combined matrix from disk
    with open(matrix_path, 'rb') as f:
        cooccurrence_counts, scalar_to_index = pickle.load(f)
    for scalar in scalar_to_index:
        obs_set.add(scalar)

overlapping_obs = human_obs & agent_obs
print('Human similarity:', overlapping_obs / human_obs)
