import ml_collections


def get_default_config():
    config = ml_collections.ConfigDict(
        {
            "actor_lr": 3e-4,
            "critic_lr": 3e-4,
            "hidden_dims": (256, 256, 256),
            "discount": 0.99,
            "target_update_rate": 5e-3,
            "ema_update_rate": 5e-3,
            "warmup_steps": 1000,
            "ema_update_interval": 5,
            "eta": 1.0,
            "use_auto_norm": True,
            "is_max_q_backup": False,
            "max_q_repeat": 10,
            "beta_schedule": "vp",
            "loss_type": "l2",
            "n_timesteps": 10,
            "opt_max_steps": 1e6,
            "is_critic_opt_decay": False,
            "is_actor_opt_decay": False,
            "grad_norm_clip": 2.0,
            "top_k": 1,
            "reward_tune": "no",
            "num_samples": 200,
            "temperature": 0.1,
            "expectile": 0.6,
            "bc_quantile": 0.75,
            "adv_repeat": 25,
            "neg_lbd": 0.1,
            "pos_lbd": 0.3,
            "use_transition_cache": True,
            "use_bc_cache": True,
            "transition_model_type": "transition_mlp_00",
            "use_dl": False,
        }
    )
    return config


hyperparameters = {
    "halfcheetah-medium-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.6429729081645622,
        "expectile": 0.8377497026584306,
        "is_max_q_backup": True,
        "max_q_repeat": 5,
        "neg_lbd": 0.1176967548143512,
        "pos_lbd": 8.799642026379136,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 9.0,
        "top_k": 1,
    },
    "hopper-medium-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.8410536654757687,
        "expectile": 0.9361209299782248,
        "is_max_q_backup": False,
        "neg_lbd": 0.17431921418503876,
        "pos_lbd": 9.852218519140637,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 9.0,
        "top_k": 2,
        "num_samples": 200,
        "temperature": 0.1,
    },
    "walker2d-medium-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.6410785955513599,
        "expectile": 0.9183773442692522,
        "is_max_q_backup": True,
        "max_q_repeat": 3,
        "neg_lbd": 0.06411139090761309,
        "pos_lbd": 12.208173475103337,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 1.0,
        "top_k": 1,
    },
    "halfcheetah-medium-replay-v2": { # 1e6
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.762276830384471,
        "expectile": 0.7101719308704221,
        "is_max_q_backup": True,
        "max_q_repeat": 5,
        "neg_lbd": 1.2049023335181748,
        "pos_lbd": 7.598130182589872,
        "use_dl": False,
        "reward_tune": "no",
        "grad_norm_clip": 2.0,
        "top_k": 0,
    },
    "hopper-medium-replay-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.7267036836959362,
        "expectile": 0.7014871814676107,
        "is_max_q_backup": True,
        "max_q_repeat": 5,
        "neg_lbd": 2.5106834993082954,
        "pos_lbd": 10.06548313338589,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 4.0,
        "top_k": 2,
    },
    "walker2d-medium-replay-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.6355983268118839,
        "expectile": 0.6754898697875076,
        "is_max_q_backup": False,
        "neg_lbd": 0.13573584219480458,
        "pos_lbd": 7.843253127372372,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 4.0,
        "top_k": 1,
    },
    "halfcheetah-medium-expert-v2": {  # 1.8e6
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.751880095761756,
        "expectile": 0.6121415084361559,
        "is_max_q_backup": True,
        "max_q_repeat": 10,
        "neg_lbd": 2.663816168705537,
        "pos_lbd": 4.550447581099364,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 7.0,
        "top_k": 0,
    },
    "hopper-medium-expert-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.8648427600585753,
        "expectile": 0.6182615979154882,
        "is_max_q_backup": False,
        "neg_lbd": 1.097826913884983,
        "pos_lbd": 7.954604819364562,
        "use_dl": True,
        "reward_tune": "no",
        "grad_norm_clip": 5.0,
        "top_k": 2,
    },
    "walker2d-medium-expert-v2": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 1.0,
        "bc_quantile": 0.9218491248488142,
        "expectile": 0.8964264703548347,
        "is_max_q_backup": False,
        "neg_lbd": 9.14664506028888,
        "pos_lbd": 13.023108449691351,
        "use_dl": False,
        "reward_tune": "no",
        "grad_norm_clip": 5.0,
        "top_k": 1,
    },
    "antmaze-umaze-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 0.5,
        "bc_quantile": 0.505573107837739,
        "expectile": 0.711706571193027,
        "is_max_q_backup": True,
        "max_q_repeat": 3,
        "neg_lbd": 4.164595488174224,
        "pos_lbd": 13.006480380736926,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 2.0,
        "top_k": 2,
    },
    "antmaze-umaze-diverse-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 2.0,
        "bc_quantile": 0.6449384927308028,
        "expectile": 0.7517445820149333,
        "is_max_q_backup": True,
        "max_q_repeat": 3,
        "neg_lbd": 6.243974250167828,
        "pos_lbd": 13.42752737857227,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 3.0,
        "top_k": 2,
    },
    "antmaze-medium-play-v0": {
        "actor_lr": 1e-3,
        "critic_lr": 1e-3,
        "eta": 2.0,
        "bc_quantile": 0.721003821588496,
        "expectile": 0.6250332554225342,
        "is_max_q_backup": True,
        "max_q_repeat": 5,
        "neg_lbd": 5.0170580947509675,
        "pos_lbd": 10.919740523608723,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 2.0,
        "top_k": 1,
    },
    "antmaze-medium-diverse-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 3.0,
        "bc_quantile": 0.8930667064739497,
        "expectile": 0.8315607937808978,
        "is_max_q_backup": True,
        "max_q_repeat": 10,
        "neg_lbd": 7.594372801652041,
        "pos_lbd": 13.700527185220654,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 1.0,
        "top_k": 1,
    },
    "antmaze-large-play-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 4.5,
        "bc_quantile": 0.7208143120341909,
        "expectile": 0.8626585612017783,
        "is_max_q_backup": True,
        "max_q_repeat": 10,
        "neg_lbd": 11.84637725097654,
        "pos_lbd": 12.65770887699594,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 10.0,
        "top_k": 2,
    },
    "antmaze-large-diverse-v0": { # 1e6
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 3.5,
        "bc_quantile": 0.7369563475290042,
        "expectile": 0.7462456804778388,
        "is_max_q_backup": True,
        "max_q_repeat": 10,
        "neg_lbd": 1.8732104813812671,
        "pos_lbd": 10.394719361603682,
        "use_dl": True,
        "reward_tune": "cql_antmaze",
        "grad_norm_clip": 7.0,
        "top_k": 1,
    },
    "pen-human-v1": {
        "actor_lr": 3e-5,
        "critic_lr": 3e-5,
        "eta": 0.15,
        "is_max_q_backup": False,
        "reward_tune": "normalize",
        "grad_norm_clip": 7.0,
        "top_k": 2,
    },
    "pen-cloned-v1": {
        "actor_lr": 3e-5,
        "critic_lr": 3e-5,
        "eta": 0.1,
        "is_max_q_backup": False,
        "reward_tune": "normalize",
        "grad_norm_clip": 8.0,
        "top_k": 2,
    },
    "kitchen-complete-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 0.005,
        "is_max_q_backup": False,
        "reward_tune": "no",
        "grad_norm_clip": 9.0,
        "top_k": 2,
    },
    "kitchen-partial-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 0.005,
        "is_max_q_backup": False,
        "reward_tune": "no",
        "grad_norm_clip": 10.0,
        "top_k": 2,
    },
    "kitchen-mixed-v0": {
        "actor_lr": 3e-4,
        "critic_lr": 3e-4,
        "eta": 0.005,
        "is_max_q_backup": False,
        "reward_tune": "no",
        "grad_norm_clip": 10.0,
        "top_k": 0,
    },
}
