# Learning to Infer the Structure of Network Games

## Running the experiments

### Synthetic Datasets
The base file for running all experiments is gnn_learn_all.py. The arguments graph_type or game_type can be set to train the model on different scenarios.
```{bash}
python gnn_learn_all.py 
```

The figure 3 results for NuGgeT can be obtained by running:
```{bash}
wandb sweep experiment_linear_quadratic.yaml -p network_games --name linear_quadratic
```

The figure 4 results for NuGgeT can be obtained by running:
```{bash}
wandb swandb sweep experiment_linear_influence.yaml -p network_games --name linear_influence
```

The figure 5 results for NuGgeT can be obtained by running:
```{bash}
wandb sweep experiment_graphical_game.yaml -p network_games --name graphical_game
```

The figure 8 results for NuGgeT can be obtained by running:
```{bash}
wandb sweep experiment_number_of_games.yaml -p network_games --name number_of_games
```

The figure 9 results for NuGgeT can be obtained by running:
```{bash}
wandb sweep experiment_number_of_nodes.yaml -p network_games --name number_of_nodes
```

### Real World Datasets

Running NuGgeT on the Indian Villages Dataset:
```{bash}
python gnn_learn_all.py --graph_type indian_village --batch_size 1 --test_batch_size 1
```

Running NuGgeT on the Yelp Ratings Dataset:
```{bash}
python gnn_learn_all.py --graph_type yelp --batch_size 1 --test_batch_size 1
```