from spaghettini import quick_register


@quick_register
def get_multi_loaders(dataset_init, dataloader_init, train_dataset_args=dict(), valid_dataset_args=dict(),
                      test_dataset_args=dict(), train_dataloader_args=dict(), valid_dataloader_args=dict(),
                      test_dataloader_args=dict()):

    # Get training dataloader.
    train_loader = dataloader_init(dataset=dataset_init(**train_dataset_args), **train_dataloader_args)
    valid_loader = dataloader_init(dataset=dataset_init(**valid_dataset_args), **valid_dataloader_args)
    test_loader = dataloader_init(dataset=dataset_init(**test_dataset_args), **test_dataloader_args)

    return train_loader, valid_loader, test_loader
