import argparse

from spaghettini import load

import matplotlib as mpl

# mpl.use("Agg")


if __name__ == "__main__":
    # ____ Parse the args, get the config. ____
    parser = argparse.ArgumentParser()
    parser.add_argument("--cfg_dir", type=str,
                        help="The (relative) path to the configuration file")
    parser.add_argument("--tmp_dir", type=str,
                        help="The (absolute) path to the temporary checkpoint directory. ")
    parser.set_defaults(test_only=False)

    args = parser.parse_args()

    # ____ Load the config. ____
    cfg = load(args.cfg_dir, gather_hparams=False, verbose=False, record_config=False)

    # ____ Perform task. ____
    cfg.task_fn(cfg, cfg_dir=args.cfg_dir, tmp_dir=args.tmp_dir)
