# PVG
Prover Verifier Games
Accompanying code to the ICLR2022 submission "Learning to Give Checkable Answers with Prover-Verifier Games"

## Installation
* Create a new conda environment and activate it:
```
conda create -n pvn python=3.7
conda activate pvn
```
    
* Install PyTorch, following instructions in `https://pytorch.org`. 

* Install spaghettini, an experiment configuration manager. 
```
pip install spaghettini
```

* Install the rest of the packages. 
```
python setup.py install
```


## Reproducing Results

### Setting up Weights and Biases
We use Weight and Biases to log our experimental results. To see the logged results, 
* Get a Weights and Biases account. 
* Each experiment configuration file `PVN/runs/*/*.yaml` contains a logger field. Fill in this part of the configuration file with your wandb user information. 
* Run the experiments using the following instructions. 

### Reproducing Binary Erasure channel Experiments. 
* To reproduce the results of Prover-Verifier Training, run the following from root.
``` 
EXP_DIR='runs/binary_erasure/proof_verification_game'
python -um src.mains.run --cfg_dir ${EXP_DIR}/*.yaml --tmp_dir ${EXP_DIR}
```

* To reproduce the results of Collaborative Training, run the following from root.
``` 
EXP_DIR='runs/binary_erasure/collaborative'
python -um src.mains.run --cfg_dir ${EXP_DIR}/*.yaml --tmp_dir ${EXP_DIR}
```

### Reproducing the FindThePlus Experiments. 
* To reproduce the results of Prover-Verifier Training, run the following from root.
``` 
EXP_DIR='runs/find_plus/proof_verification_game'
python -um src.mains.run --cfg_dir ${EXP_DIR}/*.yaml --tmp_dir ${EXP_DIR}
```

* To reproduce the results of Collaborative Training, run the following from root.
``` 
EXP_DIR='runs/find_plus/collaborative'
python -um src.mains.run --cfg_dir ${EXP_DIR}/*.yaml --tmp_dir ${EXP_DIR}
```