import torch
import torch.nn as nn


def l2_norm_model_weights(model):
    # Convert model parameters to a vector
    parameters_vector = nn.utils.parameters_to_vector(model.parameters())

    # Calculate the L2 norm of the weights
    l2_norm = torch.norm(parameters_vector, 2)
    return l2_norm.detach().cpu().numpy()
